import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes

plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})

plt.interactive(True)
plt.close('all')

viscos=1/2000

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

x_wall = x2d[:,-1]
y_wall = y2d[:,-1]

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

name = '../../noback/pycalc-les/diffuser-10-degrees-WALE-600-150-300-iter2-inlet-fron-channel-with-ni600-straight-end-bezier-N-90-long/'

datax= np.loadtxt(str(name)+'x2d.dat')
x_LES=datax[0:-1]
ni_LES=int(datax[-1])
datay= np.loadtxt(str(name)+'y2d.dat')
y_LES=datay[0:-1]
nj_LES=int(datay[-1])

x2d_LES=np.zeros((ni_LES+1,nj_LES+1))
y2d_LES=np.zeros((ni_LES+1,nj_LES+1))

x2d_LES=np.reshape(x_LES,(ni_LES+1,nj_LES+1))
y2d_LES=np.reshape(y_LES,(ni_LES+1,nj_LES+1))

x_wall_LES = x2d_LES[:,-1]
y_wall_LES = y2d_LES[:,-1]

# compute cell centers
xp2d_LES=0.25*(x2d_LES[0:-1,0:-1]+x2d_LES[0:-1,1:]+x2d_LES[1:,0:-1]+x2d_LES[1:,1:])
yp2d_LES=0.25*(y2d_LES[0:-1,0:-1]+y2d_LES[0:-1,1:]+y2d_LES[1:,0:-1]+y2d_LES[1:,1:])




#%%%%%%%%%%%%%%%%%%%%% grid
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(x_wall,y_wall,'b-')
plt.plot(x_wall_LES,y_wall_LES,'r-')
plt.axis([-0.6, 8, 0.95, 1.7])


#%%%%%%%%%%%%%%%%%%%%% grid
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
for i in range(0,ni+1,5):
   plt.plot(x2d[i,:],y2d[i,:])
plt.plot(x2d[-1,:],y2d[-1,:])

for j in range(0,nj+1,5):
   plt.plot(x2d[:,j],y2d[:,j])
plt.plot(x2d[:,-1],y2d[:,-1])

plt.savefig('grid.png')




