
#
# compute re_delta1 for boundary layer flow
dx=x[3]-x[2]
re_disp_bl=np.zeros(ni)
delta_disp=np.zeros(ni)
for i in range (0,ni-1):
   d_disp=0
   for j in range (1,nj-1):
      up=u2d[i,j]/u2d[i,-1]
      dy=y2d[i,j]-y2d[i,j-1]
      d_disp=d_disp+(1.-min(up,1.))*dy

   delta_disp[i]=d_disp
   re_disp_bl[i]=d_disp*u2d[i,-1]/viscos

re_disp_bl[-1]=re_disp_bl[-1-1]
delta_disp[-1]=delta_disp[-1-1]

x_wall=x2d[:,-1]
y_wall=y2d[:,-1]

alpha = np.arctan(np.diff(y_wall)/np.diff(x_wall))*180/np.pi

print('\nangle (degrees): ',np.arctan(np.diff(y_wall)/np.diff(x_wall))*180/np.pi)

dpdi =np.diff(p2d[:,0])/np.diff(x2d[1:,0])
dpdi_10 =np.diff(p2d[:,10])/np.diff(x2d[1:,0])
dpdi_dx =np.zeros(ni)

dpdi_mean =np.zeros(ni)
for i in range(1,ni-1):
   dx=x2d[i+1,0]-x2d[i,0]
   dy=y2d[i,1]-y2d[i,0]
   ds = (dx**2+dy**2)**0.5
   dpdi_dx[i] = (p2d[i+1,0]-p2d[i-1,0])/ds
di=10
for i in range(1,ni-1):
   dpdi_mean[i] = np.mean(dpdi_dx[i-di:i+di])

##########################################  dpdi
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,0],dpdi_dx,'r-')
plt.plot(xp2d[:,0],dpdi_mean,'b-')
plt.ylabel("$dp/di$")
plt.xlabel("$x$")
#plt.axis([xp2d[0,0],xp2d[-1,0],0,0.2])
plt.savefig('dpdi.png',bbox_inches='tight')



##########################################  pw
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,0],p2d[:,0],'b-')
plt.ylabel("$p_{wall}$")
plt.xlabel("$x$")
#plt.axis([xp2d[0,0],xp2d[-1,0],0,0.2])
plt.savefig('p_wall.png',bbox_inches='tight')


##########################################  displacement thickness
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,1],delta_disp,'b-')
plt.ylabel("$\delta^*$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],0,0.2])
plt.savefig('delta_disp.png',bbox_inches='tight')

##########################################  Clauser beta 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
dpdx=np.gradient(p2d[:,-1],xp2d[:,1])
beta=delta_disp*dpdx/ustar**2
plt.plot(xp2d[:,1],beta,'b-')
plt.ylabel(r"$\beta$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],-11,16])
plt.savefig('beta-dpdx.png',bbox_inches='tight')

# compute p from Bernoullii
# p1+u1**2/2 = p2+u2**2/2 => p2=p1+(u1**2 - u2**2)/2
p1=0
ubulk1=np.trapz(u2d[0,:],yp2d[0,:])/(y2d[0,-1]-y2d[0,0])
p_bern=np.zeros(ni)
for i in range(0,ni):
   ubulk2=np.trapz(u2d[i,:],yp2d[i,:])/(y2d[i,-1]-y2d[i,0])
   p_bern[i]=p1+(ubulk1**2 - ubulk2**2)/2
   
dpdx_bern=np.gradient(p_bern,xp2d[:,0])
   

##########################################  P+
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.30,bottom=0.20)
dpdx=np.gradient(p2d[:,-1],xp2d[:,1])
p_plus=viscos*dpdx/ustar**3
p_plus_bern=viscos*dpdx_bern/ustar**3
plt.plot(xp2d[:,1],p_plus,'b-',label='LES')
plt.ylabel(r"$P^+$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],-0.04,0.3])
plt.savefig('p-plus.png',bbox_inches='tight')

##########################################  P+  zoom
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.30,bottom=0.20)
dpdx=np.gradient(p2d[:,-1],xp2d[:,1])
p_plus=viscos*dpdx/ustar**3
p_plus_bern=viscos*dpdx_bern/ustar**3
plt.plot(xp2d[:,1],p_plus,'b-',label='LES')
plt.ylabel(r"$P^+$")
plt.xlabel("$x$")
plt.axis([0,2.5, -0.04,0.4])
plt.savefig('p-plus-zoom.png',bbox_inches='tight')

##########################################  cf
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,1],cf,'b-')
plt.ylabel("$C_f$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],0,0.0075])
plt.savefig('cf.png',bbox_inches='tight')


########################################## U log
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.semilogx(yplus_DNS[::10],u_DNS[::10],'bo')
i1 =1
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'b-',label="inlet")
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'b--',label='x='+str(xx))

plt.legend(loc='best',prop=dict(size=13))
plt.ylabel("$U^+$")
plt.xlabel("$y^+$")
plt.axis([1, 2000, 0, 25])
plt.savefig('u_log.png',bbox_inches='tight')

########################################## V 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'b-',label="inlet")
xx=0;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'r-',label='x='+str(xx))
xx=1;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'k-',label='x='+str(xx))
xx=2;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'b--',label='x='+str(xx))
plt.legend(loc='best',prop=dict(size=13))
plt.ylabel("$V^+$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],y2d[-1,-1],0,2])
plt.savefig('v.png',bbox_inches='tight')

########################################## U  linear
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y_DNS[::10],u_DNS[::10],'bo',label='DNS')
i1 = 0
plt.plot(yp2d[i1,:],u2d[i1,:],'b-',label="inlet")
xx=0;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],u2d[i1,:],'r-',label='x='+str(xx))
xx=1;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],u2d[i1,:],'k-',label='x='+str(xx))
xx=2;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],u2d[i1,:],'b--',label='x='+str(xx))
plt.legend(loc='best',prop=dict(size=13))
plt.ylabel("$U$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],y2d[-1,-1],0,28])
plt.savefig('u.png',bbox_inches='tight')

########################################## vis 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'b-',label="inlet")
xx=0;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'r-',label='x='+str(xx))
xx=1;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'k-',label='x='+str(xx))
xx=2;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'b--',label='x='+str(xx))
plt.legend(loc='best',fontsize=14)
plt.ylabel(r"$\nu_t/\nu$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],y2d[-1,-1],0,3])
plt.savefig('vis.png',bbox_inches='tight')


########################################## uv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'b-',label='inlet')
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'b--',label='x='+str(xx))

plt.legend(loc='best',fontsize=14)

plt.ylabel(r"$\overline{u'v'}$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],y2d[-1,-1],-1.1,0.2])
plt.savefig('uv.png',bbox_inches='tight')







