import numpy as np
import sys
import re
import matplotlib.pyplot as plt

# taken from https://turbmodels.larc.nasa.gov/Other_LES_Data/2dhill_periodic.html
# variables="x","y"
# zone, t="hill grid points"
# # Note: there may be round-off errors
 # STRANDID=0, SOLUTIONTIME=0
 # I=197, J=129, K=1, ZONETYPE=Ordered
 # DATAPACKING=BLOCK
 # DT=(SINGLE SINGLE SINGLE SINGLE SINGLE )


plt.interactive(True)
plt.close('all')


ni = 197
nj = 129

#data = tecplot_reader('./stress_1.dat', 31)

name = 'hill_grid.dat'
data = np.fromfile(name,sep=" ")
number_of_var = 2
output = np.split(data, number_of_var)
data_np = np.asarray(output)

x = data_np[0,:]
y = data_np[1,:]

x2d=np.reshape(x,(nj,ni))
y2d=np.reshape(y,(nj,ni))

x2d=np.transpose(x2d)
y2d=np.transpose(y2d)


#%%%%%%%%%%%%%%%%%%%%% grid
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
for i in range(0,ni,5):
   plt.plot(x2d[i,:],y2d[i,:])
plt.plot(x2d[-1,:],y2d[-1,:])

for j in range(0,nj,5):
   plt.plot(x2d[:,j],y2d[:,j])
plt.plot(x2d[:,-1],y2d[:,-1])

plt.savefig('grid-tecplot.png')

