import scipy.io as sio
import sys
from matplotlib import ticker
import numpy as np
from matplotlib import ticker
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from gradients import compute_face_phi,dphidx,dphidy,init

plt.rcParams.update({'font.size': 22})

plt.close('all')

plt.interactive(True)

name = './'

datax= np.loadtxt(str(name)+"x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt(str(name)+"y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

zmax=1.0

# distance to nearest wall
ywall_s=0.5*(y2d[0:-1,0]+y2d[1:,0])
dist=yp2d-ywall_s[:,None]


viscos=1/10500

u2d=np.load('u2d_saved.npy')
p2d=np.load('p2d_saved.npy')
v2d=np.load('v2d_saved.npy')
k2d=np.load('k2d_saved.npy')
om2d=np.load('om2d_saved.npy')
vis2d=np.load('vis2d_saved.npy')


vis2d=vis2d/viscos

#load iteration history
u_iter= np.loadtxt(str(name)+"u-iteration.dat")
u5=u_iter[:,1]
u10=u_iter[:,2]
u20=u_iter[:,3]
u30=u_iter[:,4]
u40=u_iter[:,5]
u50=u_iter[:,6]


# compute cf
cf=np.zeros(ni)
yplus_s=np.zeros(ni)
yplus_n=np.zeros(ni)
cmu = 0.09
for i in range (0,ni-1):
     xt=x2d[i,0]-x2d[i-1,0]
     yt=y2d[i,0]-y2d[i-1,0]
     rl=(xt**2+yt**2)**0.5
     xt=xt/rl
     yt=yt/rl
     uwall=abs(u2d[i,1]*xt+v2d[i,1]*yt)
     xn=-yt
     yn=xt
     yp=abs((yp2d[i,1]-yp2d[i,0])*yn+(xp2d[i,1]-xp2d[i,0])*xn)
     ustar=(uwall*viscos/yp)**0.5
     ustars=(uwall*viscos/yp)**0.5*u2d[i,1]/abs(u2d[i,1])
     cf[i]=abs(ustars)*ustars/0.5
     yplus_s[i] = abs(ustars)*yp/viscos


     yp_n = 0.5*(y2d[i,-1]-y2d[i,-2])
     ustar_n=cmu**0.25*k2d[i,-1]**0.5
     yplus_n[i] = abs(ustar_n)*yp_n/viscos

cf[0]=cf[1]

ubulk = np.trapz(u2d[0,:],yp2d[0,:])/(y2d[0,-1]-y2d[0,0])
print('ubulk',ubulk)

u2d = u2d/ubulk
v2d = v2d/ubulk
k2d = k2d/ubulk**2

# compute geometric quantities
areaw,areawx,areawy,areas,areasx,areasy,vol,fx,fy,as_bound = init(x2d,y2d,xp2d,yp2d)

# compute face value of U and V
zero_bc=np.zeros(ni)
u2d_face_w,u2d_face_s=compute_face_phi(u2d,fx,fy,ni,nj,zero_bc)
v2d_face_w,v2d_face_s=compute_face_phi(v2d,fx,fy,ni,nj,zero_bc)

# x derivatives
dudx=dphidx(u2d_face_w,u2d_face_s,areawx,areasx,vol)
dvdx=dphidx(v2d_face_w,v2d_face_s,areawx,areasx,vol)

# y derivatives
dudy=dphidy(u2d_face_w,u2d_face_s,areawy,areasy,vol)
dvdy=dphidy(v2d_face_w,v2d_face_s,areawy,areasy,vol)

uv2d = -(vis2d*viscos-viscos)*(dudy+dvdx)

u2d_kom = u2d
p2d_kom = p2d
k2d_kom = k2d
uv2d_kom = uv2d
vis2d_kom = vis2d
cf_kom = cf


# compute geometric quantities
areaw,areawx,areawy,areas,areasx,areasy,vol,fx,fy,as_bound = init(x2d,y2d,xp2d,yp2d)

# compute face value of U and V
zero_bc=np.zeros(ni)
u2d_face_w,u2d_face_s=compute_face_phi(u2d,fx,fy,ni,nj,zero_bc)
v2d_face_w,v2d_face_s=compute_face_phi(v2d,fx,fy,ni,nj,zero_bc)

# x derivatives
dudx=dphidx(u2d_face_w,u2d_face_s,areawx,areasx,vol)
dvdx=dphidx(v2d_face_w,v2d_face_s,areawx,areasx,vol)

# y derivatives
dudy=dphidy(u2d_face_w,u2d_face_s,areawy,areasy,vol)
dvdy=dphidy(v2d_face_w,v2d_face_s,areawy,areasy,vol)

uv2d = -(vis2d*viscos-viscos)*(dudy+dvdx)

u2d_kom = u2d
p2d_kom = p2d
cf_kom = cf
k2d_kom = k2d
uv2d_kom = uv2d
vis2d_kom = vis2d


# coarse DNS benchmark by Karlsruhe
# Wall resolving periodic hill : Re_b = 10595
# x/h = 1.0
#
# Note [1] : Ub is bulk velocity
# Note [2] : p_dyn = 0.5 * rho * Ub * Ub
# Note [3] : Ub2   = Ub * Ub
#
# y/h       U/Ub       V/Ub       p/p_dyn   uu/(Ub2)  vv/(Ub2)  ww/(Ub2)  uv/(Ub2)  kres/(Ub2) (nu_t)/(nu_mol)
DNS_x005h=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_x005h.dat", dtype=None,comments="%")
DNS_x05h=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_x05h.dat", dtype=None,comments="%")
DNS_1xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_1xh.dat", dtype=None,comments="%")
DNS_2xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_2xh.dat", dtype=None,comments="%")
DNS_3xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_3xh.dat", dtype=None,comments="%")
DNS_4xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_4xh.dat", dtype=None,comments="%")
DNS_5xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_5xh.dat", dtype=None,comments="%")
DNS_6xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_6xh.dat", dtype=None,comments="%")
DNS_7xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_7xh.dat", dtype=None,comments="%")
DNS_8xh=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_8xh.dat", dtype=None,comments="%")
DNS_cf=np.genfromtxt("/chalmers/users/lada/DNS_hill/DNS_cf.dat", dtype=None,comments="%")

k_DNS_x005h = 0.5*(DNS_x005h[:,4]+DNS_x005h[:,5]+DNS_x005h[:,6])
k_DNS_x05h = 0.5*(DNS_x05h[:,4]+DNS_x05h[:,5]+DNS_x05h[:,6])
k_DNS_1xh = 0.5*(DNS_1xh[:,4]+DNS_1xh[:,5]+DNS_1xh[:,6])
k_DNS_2xh = 0.5*(DNS_2xh[:,4]+DNS_2xh[:,5]+DNS_2xh[:,6])
k_DNS_2xh = 0.5*(DNS_2xh[:,4]+DNS_2xh[:,5]+DNS_2xh[:,6])
k_DNS_3xh = 0.5*(DNS_3xh[:,4]+DNS_3xh[:,5]+DNS_3xh[:,6])
k_DNS_4xh = 0.5*(DNS_4xh[:,4]+DNS_4xh[:,5]+DNS_4xh[:,6])
k_DNS_5xh = 0.5*(DNS_5xh[:,4]+DNS_5xh[:,5]+DNS_5xh[:,6])
k_DNS_6xh = 0.5*(DNS_6xh[:,4]+DNS_6xh[:,5]+DNS_6xh[:,6])
k_DNS_7xh = 0.5*(DNS_7xh[:,4]+DNS_7xh[:,5]+DNS_7xh[:,6])
k_DNS_8xh = 0.5*(DNS_8xh[:,4]+DNS_8xh[:,5]+DNS_8xh[:,6])

x_DNS = DNS_cf[:,0]
cf_DNS = DNS_cf[:,1]


########################################## cf
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,0],cf_kom,'r--')
plt.plot(x_DNS,cf_DNS,'k--')
plt.xlabel("$x$")
plt.ylabel("$C_F$")
#plt.axis([0, 1.2,0,3.1])

plt.savefig('cf_hill.png')


########################################## uv 005h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.05
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_x005h[:,7],DNS_x005h[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=0.05$")
plt.axis([-0.02,0.01 , 0,3.1])
plt.savefig('uv005_hill.png')



########################################## uv 05h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_x05h[:,7],DNS_x05h[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=0.05$")
plt.axis([-0.03,0 , 0,3.1])
plt.savefig('uv05_hill.png')

########################################## uv 1h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_1xh[:,7],DNS_1xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=1$")
plt.axis([-0.04,0 , 0,3.1])
plt.savefig('uv1_hill.png')


########################################## uv 2h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_2xh[:,7],DNS_2xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=2$")
plt.axis([-0.04,0 , 0,3.1])
plt.savefig('uv2_hill.png')


########################################## uv 3h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=3
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_3xh[:,7],DNS_3xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=3$")
plt.axis([-0.04,0 , 0,3.1])
plt.savefig('uv3_hill.png')


########################################## uv 4h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=4
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_4xh[:,7],DNS_4xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=4$")
plt.axis([-0.03,0 , 0,3.1])
plt.savefig('uv4_hill.png')


########################################## uv 5h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_5xh[:,7],DNS_5xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=5$")
plt.axis([-0.03,0 , 0,3.1])
plt.savefig('uv5_hill.png')


########################################## uv 6h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=6
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_6xh[:,7],DNS_6xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=6$")
plt.axis([-0.03,0 , 0,3.1])
plt.savefig('uv6_hill.png')


########################################## uv 7h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=7
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_7xh[:,7],DNS_7xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=7$")
plt.axis([-0.03,0 , 0,3.1])
plt.savefig('uv7_hill.png')


########################################## uv 8h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=8
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot( uv2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_8xh[:,7],DNS_8xh[:,0],'k--',fillstyle='none')
plt.xlabel(r"$\overline{u'v'}$")
plt.ylabel("$y$")
#plt.title("$x=8$")
plt.axis([-0.04,0 , 0,3.1])
plt.savefig('uv8_hill.png')


########################################## k 005h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.05
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_x005h,DNS_x005h[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=0.05$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k005_hill.png')



########################################## k 05h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_x05h,DNS_x05h[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=0.5$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k05_hill.png')


########################################## k 1h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_1xh,DNS_1xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=1$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k1_hill.png')



########################################## k 2h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_2xh,DNS_2xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=2$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k2_hill.png')



########################################## k 3h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=3
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_3xh,DNS_3xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=3$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k3_hill.png')


########################################## k 4h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=4
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_4xh,DNS_4xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=4$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k4_hill.png')


########################################## k 5h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_5xh,DNS_5xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=5$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k5_hill.png')


########################################## k 6h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=6
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_6xh,DNS_6xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=6$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k6_hill.png')


########################################## k 7h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=7
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_7xh,DNS_7xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=7$")
plt.axis([0, 0.121,0,3.1])
plt.savefig('k7_hill.png')


########################################## k 8h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=8
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(k2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(k_DNS_8xh,DNS_8xh[:,0],'k--',fillstyle='none')
plt.xlabel("$k$")
plt.ylabel("$y$")
#plt.title("$x=8$")
plt.axis([0, 0.12,0,3.1])
plt.savefig('k8_hill.png')


########################################## U 005h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.05
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_x05h[:,1],DNS_x05h[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=0.05$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u005_hill.png')

########################################## U 05h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_x05h[:,1],DNS_x05h[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=0.5$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u05_hill.png')

########################################## U 1h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_1xh[:,1],DNS_1xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=1$")
plt.axis([-0.2, 1.2,0,3.1])

plt.savefig('u1_hill.png')

########################################## U 2h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_2xh[:,1],DNS_2xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=2$")
plt.axis([-0.3, 1.2,0,3.1])

plt.savefig('u2_hill.png')
########################################## U 3h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=3
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_3xh[:,1],DNS_3xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=3$")
plt.axis([-0.3, 1.2,0,3.1])

plt.savefig('u3_hill.png')
########################################## U 4h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=4
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_4xh[:,1],DNS_4xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=4$")
plt.axis([-0.2, 1.2,0,3.1])

plt.savefig('u4_hill.png')
########################################## U 5h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_5xh[:,1],DNS_5xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=5$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u5_hill.png')
########################################## U 6h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=6
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_6xh[:,1],DNS_6xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=6$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u6_hill.png')
########################################## U 7h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=7
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_7xh[:,1],DNS_7xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=7$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u7_hill.png')
########################################## U 8h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=8
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_kom[i1,:],yp2d[i1,:],'r--')
plt.plot(DNS_8xh[:,1],DNS_8xh[:,0],'k--',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
#plt.title("$x=8$")
plt.axis([0., 1.2,0,3.1])

plt.savefig('u8_hill.png')


########################################## vis 005h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.005
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
##plt.title("$x=0.005$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis005_hill.png')

########################################## vis 05h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=0.05
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
##plt.title("$x=0.05$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis05_hill.png')

########################################## vis 1h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=1$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis1_hill.png')

########################################## vis 2h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=2$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis2_hill.png')
########################################## vis 3h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=3
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=3$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis3_hill.png')
########################################## vis 4h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=4
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=4$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis4_hill.png')
########################################## vis 5h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=5$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis5_hill.png')
########################################## vis 6h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=6
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=6$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis6_hill.png')
########################################## vis 7h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=7
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=7$")
plt.axis([0, 5e2,0,3.1])

plt.savefig('vis7_hill.png')
########################################## vis 8h
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
xx=8
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_kom[i1,:],yp2d[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
#plt.title("$x=8$")
plt.axis([0., 5e2,0,3.1])

plt.savefig('vis8_hill.png')


########################################## u-hist 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
i1 = 0
#u5=u_iter[:,1]
#u10=u_iter[:,2]
#u20=u_iter[:,3]
#u30=u_iter[:,4]
#u40=u_iter[:,5]
#u50=u_iter[:,6]
#aaa=f'{yp2d[1,1]:.1e}'
#plt.plot(u5,'b--',label='y='+aaa)
plt.plot(u5[-100:-1],'b-',label='y='+f'{yp2d[ni-5,5]:.1e}')
plt.plot(u10[-100:-1],'r-',label='y='+f'{yp2d[ni-5,10]:.1e}')
plt.plot(u20[-100:-1],'k-',label='y='+f'{yp2d[ni-5,20]:.1e}')
plt.plot(u30[-100:-1],'b--',label='y='+f'{yp2d[ni-5,30]:.1e}')
plt.plot(u40[-100:-1],'r--',label='y='+f'{yp2d[ni-5,40]:.1e}')
plt.plot(u50[-100:-1],'k--',label='y='+f'{yp2d[ni-5,50]:.1e}')
#plt.legend(loc='best',fontsize=14)
plt.legend(loc='upper left',fontsize=14)



########################################## y+
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,0],yplus_s,'b-')
plt.plot(xp2d[:,0],yplus_n,'r--')
plt.xlabel("$x$")
plt.ylabel("$y^+$")

plt.savefig('yplus_hill.png')


