import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from IPython import display
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})


viscos=1/5200


u3d=np.load('/chalmers/users/lada/noback/pycalc-les/hill-RANS-k-omega-hybrid/u3d_saved.npy')
v3d=np.load('/chalmers/users/lada/noback/pycalc-les/hill-RANS-k-omega-hybrid/v3d_saved.npy')
p3d=np.load('/chalmers/users/lada/noback/pycalc-les/hill-RANS-k-omega-hybrid/p3d_saved.npy')
k3d=np.load('/chalmers/users/lada/noback/pycalc-les/hill-RANS-k-omega-hybrid/k3d_saved.npy')
om3d=np.load('/chalmers/users/lada/noback/pycalc-les/hill-RANS-k-omega-hybrid/om3d_saved.npy')

print('u2d.shape',u3d.shape)

ni,nj = u3d[:,:,1].shape


u2d_k=u3d[:,:,0]
v2d_k=v3d[:,:,0]
p2d_k=p3d[:,:,0]
k2d_k=k3d[:,:,0]
om2d_k=om3d[:,:,0]
vis2d_k=k2d_k/om2d_k

print('u2d_k.shape',u2d_k.shape)

np.save('u2d_saved', u2d_k)
np.save('v2d_saved', v2d_k)
np.save('p2d_saved', p2d_k)
np.save('k2d_saved', k2d_k)
np.save('om2d_saved', om2d_k)
np.save('vis2d_saved', vis2d_k)

