
def modify_init(u2d,v2d,k2d,om2d,eps2d,vis2d):
   
   k2d = np.ones((ni,nj))*0.1
   om2d = np.ones((ni,nj))*0.1

   vis2d = k2d/om2d 

   return u2d,v2d,k2d,om2d,eps2d,vis2d,dist

def modify_inlet():

   return u_bc_west,v_bc_west,k_bc_west,om_bc_west,eps_bc_west,u2d_face_w,convw

def modify_conv(convw,convs):

   print('np.sum(convw[0,:])',np.sum(convw[0,:]))
   print('np.sum(convw[1,:])',np.sum(convw[1,:]))
   print('np.sum(convw[-1,:])',np.sum(convw[-1,:]))
   print('np.sum(convw[-2,:])',np.sum(convw[-2,:]))

   return convw,convs

def modify_u(su2d,sp2d):

   global beta,uin,beta_old,uin_old

# this was used for varying beta
#  if iter == 0:
#     beta = np.loadtxt('beta.dat')
#     uin = np.loadtxt('uin.dat')
#     uin_old = uin
#     beta_old = beta
#     np.savetxt('u-iteration.dat', np.c_[iter,u2d[-1,5],u2d[-1,10],u2d[-1,20],u2d[-1,30],u2d[-1,40],\
#          u2d[-1,50],u2d[-1,100]])
#     np.savetxt('om-iteration.dat', np.c_[iter,om2d[-1,5],om2d[-1,10],om2d[-1,20],om2d[-1,30],om2d[-1,40],\
#          om2d[-1,50],om2d[-1,100]])
#     np.savetxt('beta-hist.dat', np.c_[beta])
#     np.savetxt('uin-hist.dat', np.c_[uin])
#  elif iter > 0:
#     with open('u-iteration.dat','ab') as f:
#        np.savetxt(f,np.c_[iter,u2d[-1,5],u2d[-1,10],u2d[-1,20],u2d[-1,30],u2d[-1,40],\
#          u2d[-1,50],u2d[-1,100]])
#     with open('om-iteration.dat','ab') as f:
#        np.savetxt(f, np.c_[iter,om2d[-1,5],om2d[-1,10],om2d[-1,20],om2d[-1,30],om2d[-1,40],\
#          om2d[-1,50],om2d[-1,100]])
#     with open('beta-hist.dat','ab') as f:
#        np.savetxt(f, np.c_[beta])
#     with open('uin-hist.dat','ab') as f:
#        np.savetxt(f, np.c_[uin])
#  if iter%2 == 0:
#     uin_old = uin
#     beta_old = beta


# north wall
   ustar=cmu**0.25*k2d[:,-1]**0.5
   tauw=ustar**2
   su2d[:,-1]=su2d[:,-1]-tauw*areas[:,-1]


# computing beta.  it does not work; it works in pyCALC-LES
   #uin=np.sum(convw[0,:].flatten())/(y2d[0,-1]-y2d[0,0])
   #uin_target = 1
   #beta = beta_old + 0.001*(uin_target - 2*uin_old + uin) 
#
# the value below is taken from simulations using pyCALC-LES
   beta = 0.01


#  if iter % 5 ==0:
#      np.savetxt('beta.dat', np.c_[beta])
#      np.savetxt('uin.dat', np.c_[uin])

   su2d=su2d+beta*vol

   return su2d,sp2d

def modify_v(su2d,sp2d):

   return su2d,sp2d

def modify_k(su2d,sp2d):

   return su2d,sp2d

def modify_om(su2d,sp2d):

   return su2d,sp2d

def modify_outlet(convw):

   return convw

def fix_omega():

   j = 0
   aw2d[:,j]=0
   ae2d[:,j]=0
   as2d[:,j]=0
   an2d[:,j]=0
   ap2d[:,j]=1
   su2d[:,j]=om_bc_south

# north wall
   j = -1
   ustar=cmu**0.25*k2d[:,j]**0.5
   dy=dist[0,j]
   aw2d[:,j]=0
   ae2d[:,j]=0
   as2d[:,j]=0
   an2d[:,j]=0
   ap_max=np.max(ap2d)
   ap2d[:,j]=ap_max
   su2d[:,j]=ap_max*ustar/kappa/dy/cmu**0.5

# eps = ustar**3/kappa/dy
# k = cmu**(-0.5)*ustar**2
#
# om = eps/k/cmu = ustar**3/kappa/dy/(cmu**(-0.5)*ustar**2)/cmu =  ustar/dy/cmu**0.5

# vist = k/om = cmu**(-0.5)*ustar**2/ustar*kappa*dy*cmu**0.5 = ustar*kappa*dy

   return aw2d,ae2d,as2d,an2d,ap2d,su2d,sp2d

def modify_vis(vis2d):

   return vis2d


def fix_k():

   if iter == 0:
      print('fix_k called')

#  north wall
   ustar=cmu**0.25*k2d[:,-1]**0.5
   dy=dist[0,-1]
   velabs=abs(u2d[:,-1])
#  ustar=compute_ustar_reich_solve(dy/viscos,velabs,ustar)
   ustar=compute_ustar_reich_solve(dy/viscos,velabs,ustar)
   kwall=cmu**(-0.5)*ustar**2

   ustar_min =np.min(ustar)
   ustar_max =np.max(ustar)

   kwall_min =np.min(kwall)
   kwall_max =np.max(kwall)

   aw2d[:,-1]=0
   ae2d[:,-1]=0
   as2d[:,-1]=0
   an2d[:,-1]=0
   ap_max=np.max(ap2d)
   ap2d[:,-1]=ap_max
   su2d[:,-1]=ap_max*kwall

   return aw2d,ae2d,as2d,an2d,ap2d,su2d,sp2d

def solve_ustar_reich(ustar,velabs,wdist):
    import numpy as xp
   
    return  ustar-velabs/(1/0.4*np.log(1+0.4*ustar*wdist)+7.8*(1-np.exp(-ustar*wdist/11))-ustar*wdist*np.exp(-ustar*wdist/3))
   
def compute_ustar_reich_solve(wdist,velabs,ustar):
   from scipy.optimize import fsolve,root,newton
   yplus=ustar*wdist/viscos
   ustar=ustar.flatten()
   velabs=velabs.flatten()
   wdist=wdist.flatten()
   ustar = newton(solve_ustar_reich,x0=ustar,args=(velabs,wdist))
   ustar = np.asarray(ustar)
   ustar=np.reshape(ustar,(ni))

   return ustar

