import numpy as np
import matplotlib.pyplot as plt
import sys

plt.interactive(True)

plt.close('all')

ni = 197
nj = 129

# this is the DNS  in
# 
#@article{froehlich:mellen:rodi:temmerman:leschziner:05,
          #author = "J. Froehlich and C. Mellen and W. Rodi and  L. Temmerman and M. A. and Leschziner",
          #title       ="Highly-resolved large eddy simulations of separated flow in a channel with streamwise
                       #periodic constrictions",
          #journal = jfm,
          #volume  ="526",
          #pages   = "19-66",
          #year      = 2005 }
# 
# the mesh can be downloaded at
#
# https://turbmodels.larc.nasa.gov/Other_LES_Data/2dhill_periodic.html


name = 'hill_grid.dat'
data = np.fromfile(name,sep=" ")
number_of_var = 2
output = np.split(data, number_of_var)
data_np = np.asarray(output)

x = data_np[0,:]
y = data_np[1,:]

x2d=np.reshape(x,(nj,ni))
y2d=np.reshape(y,(nj,ni))

x2d=np.transpose(x2d)
y2d=np.transpose(y2d)

x2d_org=np.copy(x2d)
y2d_org=np.copy(y2d)

x2d = x2d.flatten()
y2d = y2d.flatten()

ni = ni-1
nj = nj-1

y2d=np.append(y2d,nj)
np.savetxt('y2d.dat', y2d)

x2d=np.append(x2d,ni)
np.savetxt('x2d.dat', x2d)

# check it
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

y2=np.zeros((ni+1,nj+1))
y2=np.reshape(y,(ni+1,nj+1))

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])

x2=np.zeros((ni+1,nj+1))
x2=np.reshape(x,(ni+1,nj+1))

