# https://towardsdatascience.com/b%C3%A9zier-curve-bfffdadea212
import numpy as np
import matplotlib.pyplot as plt
import numpy as np
import sys

plt.interactive(True)

plt.close('all')


#P0, P1, P2 = np.array([
        #[0, 0],
        #[2, 4],
        #[5, 3]
#])


# channel height = 1
H=1

# inlet at x=-3
x0=-1
# outlet L=6
L=3
# Number of cells: 
ni=400
x=np.linspace(x0, L, ni+1)
dx=x[1]-x[0]
y=np.zeros(ni+1)

# diffuser opening: alpha
# use 20 cells 
N=10
alpha=8
dy=np.tan(alpha*np.pi/180)*N*dx
P0, P1, P2 = np.array([
	[-N*dx, H],
	[0, H],
	[N*dx, H+dy]
])


xx=np.linspace(0,3, ni+1)
yy=np.linspace(0,3, ni+1)*dy

# P1: center point
# P2: straight channel
# P0: diffuser part, alpha degress

# define bezier curve
P = lambda t: (1 - t)**2 * P0 + 2 * t * (1 - t) * P1 + t**2 * P2

# evaluate the curve on [P0,P2] sliced in m points
L_curved=P2[0]-P0[0]
m=int(L_curved/dx)+1

points = np.array([P(t) for t in np.linspace(0, 1, m)])

# get x and y coordinates of points separately
x_curve, y_curve = points[:,0], points[:,1]

print('\nangle (degrees): ',np.arctan(np.diff(y_curve)/np.diff(x_curve))*180/np.pi)
print('\nx_curve',x_curve)
print('\ny_curve',y_curve)

# find where x = x_curve[0]
i1 = (np.abs(x_curve[0]-x)).argmin()

# find where x = 0
i0 = (np.abs(x)).argmin()

# set y
#  first straight part
y[0:i1]=H
#  curved part
y[i1:i1+m]=y_curve
#  inclined part
# find where x = x_curve[-1]
i2 = (np.abs(x_curve[-1]-x)).argmin()
# slope
k=dy/0.6
y[i2+1:]= y[i2]+k*(x[i2+1:]-x[i2])


print('\nangle (degrees): ',np.arctan(np.diff(y)/np.diff(x))*180/np.pi)
print('\nx',x)
print('\ny',y)

# plot
plt.plot(x_curve, y_curve, 'b-')
plt.plot(x, y, 'r-')
plt.plot(xx, yy, 'g-')
plt.plot(*P0, 'r.')
plt.plot(*P1, 'r.')
plt.plot(*P2, 'r.')
plt.axis('equal')
