import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})

plt.interactive(True)

plt.close('all')
viscos=1/10000

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

y=yp2d[0,:]
y_s=y2d[0,:]




u2d=np.load('u2d_saved.npy')
p2d=np.load('p2d_saved.npy')
v2d=np.load('v2d_saved.npy')
k2d=np.load('k2d_saved.npy')
om2d=np.load('om2d_saved.npy')
vis2d=np.load('vis2d_saved.npy')


# average in x direction
u=np.mean(u2d,axis=0)
v=np.mean(v2d,axis=0)
k=np.mean(k2d,axis=0)
om=np.mean(om2d,axis=0)
vis=np.mean(vis2d,axis=0)
eps=0.09*k*om
dudy = np.gradient(u,y)

uv = vis*dudy

#     t_int=100./20.  !100 h/u_b according to laage de meux, audebert, manceau & perrin phys. fluids
#      t_int=5.*0.13  !100 h/u_b   h=0.13, U=1 => 5*h/U=5*0.13
#      t_int=100.*0.13  !100 h/u_b   h=0.13, U=1 => 100*h/U=100*0.13
#      a_int=exp(-dt(itstep)/t_int)
#      b_int=1.-a_int
#             u_rans_mean(i,j)=a_int*u_rans_mean(i,j)+b_int*u_rans(i,j)


data_ML = np.loadtxt('y-prand_k-c_k-c_omega_2-CFD.txt')
prand_k_ML = data_ML[:,1]
c_k_ML = data_ML[:,2]
c_omega_2_ML = data_ML[:,3]

data_ML = np.loadtxt('prand_k-c_k-c_omega_2.dat')
prand_k_ML_iter = data_ML[:,0]
c_k_ML_iter = data_ML[:,1]
c_omega_2_ML_iter = data_ML[:,2]



data_ML = np.loadtxt('prand_k-c_k-c_omega_2.dat')
prand_k_ML_iter = data_ML[:,0]
c_k_ML_iter = data_ML[:,1]
c_omega_2_ML_iter = data_ML[:,2]

vist = k2d/om2d

dudy=np.gradient(u,y)

ustar=(viscos*u[0]/y[0])**0.5
yplus=y*ustar/viscos
yplus_s=y_s*ustar/viscos


k_iter  = np.loadtxt('k-iteration.dat')

k1 = k_iter[:,1]
k2 = k_iter[:,2]
k3 = k_iter[:,3]
k4 = k_iter[:,4]
k5 = k_iter[:,5]
k6 = k_iter[:,6]
k7 = k_iter[:,7]

# load k-omega grid
name = '/chalmers/users/lada/pythons-rans-code-RANS/channel-2000-half-channel/'



############################ 10000
# load DNS data
# %     y/h             y+             U+           u'+           v'+          w'+           uv'+         dU/dy+
DNS_mean=np.genfromtxt("/chalmers/users/lada/DNS_channel_re10000/P10k.txt",comments="%")
y_DNS=DNS_mean[:,0];
yplus_DNS=DNS_mean[:,1];
u_DNS=DNS_mean[:,2];
u2_DNS=DNS_mean[:,3]**2;
v2_DNS=DNS_mean[:,4]**2;
w2_DNS=DNS_mean[:,5]**2;
uv_DNS=DNS_mean[:,6];
dudy_DNS= np.gradient(u_DNS,yplus_DNS)
k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS)

dudy_DNS = np.gradient(u_DNS,y_DNS)

vist_DNS = abs(uv_DNS/dudy_DNS)



# diss = m2/s3
# diss=viscos*ustar**2/L**2, L = viscos/ustar  => diss=viscos*ustar**2/(viscos/ustar)**2 = ustar**4/viscos

# find equi.distant DNS cells in log-scale
xx=0.
jDNS=[1]*40
for i in range (0,40):
   i1 = (np.abs(10.**xx-yplus_DNS)).argmin()
   jDNS[i]=int(i1)
   xx=xx+0.2

rt = k/om/viscos
fk = (0.278+(rt/8)**4)*(1+(rt/8)**4)**(-1)
fk_12 = (0.278+(rt/12)**4)*(1+(rt/12)**4)**(-1)
fmu = (0.025+rt/6)*(1+rt/6)**(-1)
fom = (0.1+rt/2.7)*((1+rt/2.7)*fmu)**(-1)

########################################## prand_k_mean 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(prand_k_ML_iter,'b-',label = r'$\sigma_{k,ML}$')
plt.xlabel('iteration')
plt.legend(loc="lower left",prop=dict(size=14))
axins1 = inset_axes(ax1, width="50%", height="50%", loc='lower right', borderpad=0.2)
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
plt.plot(prand_k_ML_iter,'b-')
axins1.yaxis.set_label_position("left")
axins1.yaxis.tick_left()
axins1.xaxis.set_label_position("top")
axins1.xaxis.tick_top()
plt.axis([1000,2000,0,1])

plt.savefig('c_k_mean.png',bbox_inches='tight')

########################################## c_omega_2_mean 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(c_omega_2_ML_iter,'b-',label = r'$c_{\omega 2,ML}$')
plt.xlabel('iteration')
plt.legend(loc="lower left",prop=dict(size=14))
axins1 = inset_axes(ax1, width="50%", height="50%", loc='lower right', borderpad=0.2)
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
plt.plot(c_omega_2_ML_iter,'b-')
axins1.yaxis.set_label_position("left")
axins1.yaxis.tick_left()
axins1.xaxis.set_label_position("top")
axins1.xaxis.tick_top()
plt.axis([1000,2000,0,0.1])

plt.savefig('c_omega_2_mean.png',bbox_inches='tight')

########################################## c_k_mean 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(c_k_ML_iter,'b-',label = r'$c_{k,ML}$')
plt.xlabel('iteration')
plt.legend(loc="lower left",prop=dict(size=14))
axins1 = inset_axes(ax1, width="50%", height="50%", loc='lower right', borderpad=0.2)
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
plt.plot(c_k_ML_iter,'b-')
axins1.yaxis.set_label_position("left")
axins1.yaxis.tick_left()
axins1.xaxis.set_label_position("top")
axins1.xaxis.tick_top()
plt.axis([1000,2000,0,0.6])

plt.savefig('c_k_mean.png',bbox_inches='tight')


########################################## U 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.semilogx(yplus,u,'b-')
plt.semilogx(yplus_DNS[jDNS],u_DNS[jDNS],'bo')
plt.ylabel("$U^+$")
plt.xlabel("$y^+$")
plt.axis([1, 10000, 0, 28])
plt.savefig('u_log_10000-channel.png',bbox_inches='tight')


########################################## uv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(yplus,uv,'b-',label = 'EARSM')
plt.plot(yplus_DNS[jDNS],uv_DNS[jDNS],'bo')
plt.ylabel(r"$\overline{u'v'}$")
plt.xlabel("$y^+$")
plt.axis([0, 10000, -1, 0])
plt.savefig('uv_10000-channel.png',bbox_inches='tight')


########################################## k 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(yplus,k,'b-',label='RANS')
plt.plot(yplus_DNS,k_DNS,'r--',label='DNS')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$k^+$")
plt.xlabel("$y^+$")
plt.axis([0, 10000, 0, 7.5])
plt.savefig('k_10000-channel.png',bbox_inches='tight')


########################################## k  zoom
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(yplus,k,'b-',label='RANS')
plt.plot(yplus_DNS,k_DNS,'r--',label='DNS')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$k^+$")
plt.xlabel("$y^+$")
plt.axis([1, 200, 0, 7.5])
plt.savefig('k_10000-channel-zoom.png',bbox_inches='tight')


########################################## vist  
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
vist = k/om
plt.plot(yplus,vis/viscos-1,'b-',label=r'$k-\omega$ ML')
plt.plot(yplus_DNS,vist_DNS/viscos,'r--',label='DNS')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$\nu_t^+$")
plt.xlabel("$y^+$")
plt.axis([0, 10000, 0, 750])
plt.savefig('vist_10000-channel.png',bbox_inches='tight')

########################################## vist  zoom
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(yplus,vis/viscos-1,'b-',label=r'$k-\omega$ ML')
plt.plot(yplus_DNS,vist_DNS/viscos,'r--',label='DNS')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$\nu_t^+$")
plt.xlabel("$y^+$")
plt.axis([0, 50, 0, 15.5])
plt.savefig('vist_10000-channel-zoom.png',bbox_inches='tight')



############################ u_iter
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(k1)
plt.plot(k2)
plt.plot(k3)
plt.plot(k4)
plt.plot(k5)
plt.plot(k6)
plt.plot(k7)
plt.savefig('k-iter-10000-channel.png',bbox_inches='tight')

########################################## prand_k   zoom
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y,prand_k_ML,'r--',label='NN-CFD')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$\sigma_k$")
plt.xlabel("$y$")
plt.xlim(0, 0.05)
plt.savefig('prand_k-10000-channel-zoom.png',bbox_inches='tight')

########################################## c_k   zoom
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y,c_k_ML,'r--',label='NN-CFD')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$C_{k}$")
plt.xlabel("$y$")
plt.xlim(0, 0.05)
plt.savefig('c_k-10000-channel.png',bbox_inches='tight')

########################################## c_omega   zoom
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y,c_omega_2_ML,'r--',label='NN-CFD')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$C_{\omega 2}$")
plt.xlabel("$y$")
plt.xlim(0, 0.05)
plt.savefig('c_omega-10000-channel-zoom.png',bbox_inches='tight')


########################################## prand_k   
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y,prand_k_ML,'r--',label='NN-CFD')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$\sigma_k$")
plt.xlabel("$y$")
plt.savefig('prand_k-10000-channel.png',bbox_inches='tight')

########################################## c_k   
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y,c_k_ML,'r--',label='NN-CFD')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$C_{k}$")
plt.xlabel("$y$")
plt.savefig('c_k-10000-channel.png',bbox_inches='tight')

########################################## c_omega 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y,c_omega_2_ML,'r--',label='NN-CFD')
plt.legend(loc="best",prop=dict(size=14))
plt.ylabel(r"$C_{\omega 2}$")
plt.xlabel("$y$")
plt.savefig('c_omega-10000-channel.png',bbox_inches='tight')



