# in this script I compute c_k and C_omega_2 from balance of k and omega equations, respectively
# tkaen from ~/noback/pycalc-les/pytorch-k-eq/pl_vist_ML-c_k-c_omega_2000_5200-plus-units.py


# it is used in the paper 
#L. Davidson<br>
#"Using Physical Informed Neural Network (PINN) to Improve a k-omega Turbulence Model",
#<i> ERCOFTAC Symposium on Engineering Turbulence Modelling and Measurements (ETMM-15)</i>, Dubrovnik on 22-24 September 2025.

import numpy as np
from numpy import linalg as LA
import math as m
import os
import sys
import matplotlib.pyplot as plt
from matplotlib import rcParams # for changing default values
import scipy.io as sio


plt.close('all')
plt.interactive(True)
# set all fontsizes to 12
rcParams["font.size"] = 16


# load k-omega grid
kom_data = np.loadtxt('y_u_k_om_uv_5200-RANS-half-channel.txt')
y_kom = kom_data[:,0]


prand_k_req = np.loadtxt('vist_pred-PINN-from-vist-diffusion-pinn-5200-plus-units-load-5-cells-required-grad-false.txt')
prand_k = np.loadtxt('vist_pred-PINN-from-vist-diffusion-pinn-5200-plus-units-load-5-cells.txt')

################################# Plot
fig, ax = plt.subplots(nrows=1, ncols=1) # Create a figure with one subplot
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y_kom[5:],prand_k,'b--',linewidth=2)
plt.plot(y_kom[5:],prand_k_req,'r--',linewidth=2)
plt.ylabel(r"$\sigma_k$")
plt.xlabel("$y$")
plt.legend(loc="best",prop=dict(size=14))
