import numpy as np
import time,random,sys
from scipy.signal import welch, hann
import math


def synt_fluct(nmodes,it,sli,yp,zp,uv_rans,visc,jmirror,dmin_synt):
#=========================== chapter 1 ============================================

#!!!  number of modes                        = nmodes
#!!!  smallest wavenumber                    = dxmin
#!!!  ratio  of ke and kmin (in wavenumber)  = wew1fct
#!!!  turb. velocity scale                   = up
#!!!  diss. rate.                            = epsm
#!!!  kinetic viscosity                      = visc
#!!!  length scale                           = sli
#!!!  mirror vfluct at j > jmirror

   global dxmin,amp,epsm,epsm,wnr1,wew1fct,xp,yp2d_synt,zp2d_synt,xp2d_synt,nj,up
   global e,kxio,kyio,kyio,sxio,syio,syio,utn,tfunk,wnre,dkn,arg1,arg2,arg3,arg,fi,psi,teta,alfa,wnr,kx,ky,kz,wnrn,\
          r11,r12,r13,r21,r22,r23,r31,r32,r33,a11,a22,a33,wnreta,uv_synt_mean,uvmean_check,a11i,a22i,a33i,\
          xp2d_wave,yp2d_wave,zp2d_wave,uv_rans_non,uv_rans_max
   global utn,tfunk,sx,e,rk,kxi,usynt_wave,usynt1,usynt,sy,vsynt,yp2d_org,usynt_aniso,scale_2

   uv_rans=np.abs(uv_rans)
   if it == 0:

      uvmean_check=0
      uv_synt_mean=0
# anisotropix fluctuations
#     R=np.loadtxt('R.dat')
      R=np.genfromtxt("R.dat", dtype=None,comments="%")
      r11=R[0,0]
      r12=R[0,1]
      r13=R[0,2]
      r21=R[1,0]
      r22=R[1,1]
      r23=R[1,2]
      r31=R[2,0]
      r32=R[2,1]
      r33=R[2,2]

#     A=np.loadtxt('a.dat')
      A=np.genfromtxt("a.dat", dtype=None,comments="%")
      a11=A[0]
      a22=A[1]
      a33=A[2]

      amp=1.452762113
      wew1fct=2

# in log region:  k/uvmax=3.3  => up=(3.3*uvmax)**0.5
# the uv_rans profile is input and taken from a pre-cursos RANS simulation
      if np.all(uv_rans==1):
         up=1
      else:
         up=(3.3*np.max(uv_rans))**0.5

      epsm=up**3/sli
#
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#     number of  grid points in y, z
      nj=len(yp)
      nk=len(zp)

# make it 2D
      zp2d_synt=np.repeat(zp[None,:], repeats=nj, axis=0)

# make it 2D
      yp2d_synt=np.repeat(yp[:,None], repeats=nk, axis=1)


      xp=0.5
# make it 2D
      xp2d_synt=np.ones((nj,nk))*xp

      yp2d_org=yp2d_synt
# transform to principal coord. directions
      xp2d_synt=r11*xp+r21*yp2d_org+r31*zp2d_synt
      yp2d_synt=r12*xp+r22*yp2d_synt+r32*zp2d_synt
      zp2d_synt=r13*xp+r23*yp2d_synt+r33*zp2d_synt

# search min grid step
      dminy=np.min(np.diff(yp))
      dminz=np.min(np.diff(zp))
      dxmin=min(dminy,dminz)

# don't let is be smaller than dmin_synt (i.e. is user-input)
      dxmin=max(dxmin,dmin_synt)

# create a seed from time 
      np.random.seed()
# below I don't use any seed; it means that if you run a simulation twice you'll get
# the samw synthetic fluctuations
      np.random.seed(2)

# zero all arrays to zero
      wnr=np.zeros(nmodes+2)
      fi=np.zeros(nmodes+2)
      teta=np.zeros(nmodes+2)
      psi=np.zeros(nmodes+2)
      wnr=np.zeros(nmodes+2)
      kxio=np.zeros((nj,nk,nmodes+2))
      kyio=np.zeros((nj,nk,nmodes+2))
      kzio=np.zeros((nj,nk,nmodes+2))
      sxio=np.zeros((nj,nk,nmodes+2))
      syio=np.zeros((nj,nk,nmodes+2))
      szio=np.zeros((nj,nk,nmodes+2))
#  yp2d_wave=np.zeros((nj,nk,nmodes+2))
      zp2d_wave=np.zeros((nj,nk,nmodes+2))
      u=np.zeros((nj,nk))
      v=np.zeros((nj,nk))
      w=np.zeros((nj,nk))
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

#     highest wave number, Section 27.3
      wnrn=2.*math.pi/dxmin
#
#     k_e (related to peak energy wave number), Section 27.4
      wnre=9.*math.pi*amp/(55.*sli)
#
# wavenumber used in the viscous expression (high wavenumbers) in the von Karman spectrum
      wnreta=(epsm/visc**3)**0.25

#     smallest wavenumber 
      wnr1=wnre/wew1fct

# wavenumber step
      dkn=(wnrn-wnr1)/nmodes

# wave numbers
      wnr=np.linspace(wnr1,wnrn,nmodes)

# invert the eigenvalue matrix (anisotropic)
      a11i=1/a11
      a22i=1/a22
      a33i=1/a33

# make a non-dimensional uv_rans profile
      uv_rans_max=np.max(uv_rans)
      uv_rans_non=(uv_rans/(uv_rans_max+1e-10))**0.5
# make it 2D
      uv_rans_non=np.repeat(uv_rans_non[:,None], repeats=nk, axis=1)


      print(f"\n{'sli: '} {sli}, {'visc: '}{visc:.2e}, {'nmodes: '}{nmodes}, {'dxmin: '}{dxmin:.3e}, {'dkn: '}{dkn:.3e}, {'dmin_synt: '}{dmin_synt:.3e}")

      print(f"\n{'wnre: '} {wnre:.2e}, {'wnr1: '}{wnr1:.2e}, {'epsm: '}{epsm:.3e}, {'wnrn: '}{wnrn:.3e}")

      print(f"\n{'eigenvalue 1, 2 and 3: '}{a11:.3e}, {a22:.3e}, {a33:.3e}")
      print(f"\n{'eigenvector R11, R12 and R13: '}{r11:.3e}, {r12:.3e}, {r13:.3e}")
      print(f"\n{'eigenvector R21, R22 and R23: '}{r21:.3e}, {r22:.3e}, {r23:.3e}")
      print(f"\n{'eigenvector R31, R32 and R33: '}{r31:.3e}, {r32:.3e}, {r33:.3e}\n")

      

#
#=========================== chapter 2 ============================================
#

# compute random angles
   fi = np.random.uniform(0.,2.*math.pi,nmodes)
   psi = np.random.uniform(0.,2.*math.pi,nmodes)
   alfa = np.random.uniform(0.,2.*math.pi,nmodes)
   ang = np.random.uniform(0.,1,nmodes)
   teta=np.arccos(1.-ang/0.5) 

   print('time step no,',it)


#   wavenumber vector from random angles
   kxio=np.sin(teta)*np.cos(fi)
   kyio=np.sin(teta)*np.sin(fi)
   kzio=np.cos(teta)
#
# sigma (s=sigma) from random angles. sigma is the unit direction which gives the direction
# of the synthetic velocity vector (u, v, w)
   sxio=np.cos(fi)*np.cos(teta)*np.cos(alfa)-np.sin(fi)*np.sin(alfa)
   syio=np.sin(fi)*np.cos(teta)*np.cos(alfa)+np.cos(fi)*np.sin(alfa)
   szio=-np.sin(teta)*np.cos(alfa)
   
#
#=========================== chapter 3 ============================================
#
# loop over all wavenumbers 
# Eq. 27.28
   kxi=r11*kxio+r21*kyio+r31*kzio
   kyi=r12*kxio+r22*kyio+r32*kzio
   kzi=r13*kxio+r23*kyio+r33*kzio

   sxi=r11*sxio+r21*syio+r31*szio
   syi=r12*sxio+r22*syio+r32*szio
   szi=r13*sxio+r23*syio+r33*szio

   sx=a11**0.5*sxi
   sy=a22**0.5*syi
   sz=a33**0.5*szi

   kx=kxi*wnr*a11i**0.5 
   ky=kyi*wnr*a22i**0.5
   kz=kzi*wnr*a33i**0.5
   rk=np.sqrt(kx**2+ky**2+kz**2)



   xp2d_wave=np.repeat(xp2d_synt[:,:,None], repeats=nmodes, axis=2)
   arg1=xp2d_wave*kx  # Eq. 27.28


   yp2d_wave=np.repeat(yp2d_synt[:,:,None], repeats=nmodes, axis=2)
   arg2=yp2d_wave*ky

   zp2d_wave=np.repeat(zp2d_synt[:,:,None], repeats=nmodes, axis=2)
   arg3=zp2d_wave*kz

   arg=arg1+arg2+arg3+psi  # Eq. 27.28

   tfunk=np.cos(arg)  # Eq. 27.8

# von Karman spectrum, Eq. 27.4
   e=amp/wnre*(wnr/wnre)**4/((1.+(wnr/wnre)**2)**(17./6.))*np.exp(-2*(wnr/wnreta)**2)

# include only wavenumber for which rk < wnrn
   e=np.where(rk < wnrn,e,0)

   utn=np.sqrt(e*up**2*dkn) # Eq. 27.4

# sum over all wavenumbers => synthetic velocity field 
   usynt=np.sum(2.*utn*tfunk*sx,axis=2) # 27.8 
   vsynt=np.sum(2.*utn*tfunk*sy,axis=2)
   wsynt=np.sum(2.*utn*tfunk*sz,axis=2)
   
# transform back to x-y-z  => anjsotropic fluct
   usynt_aniso=r11*usynt+r12*vsynt+r13*wsynt
   vsynt_aniso=r21*usynt+r22*vsynt+r23*wsynt
   wsynt_aniso=r31*usynt+r32*vsynt+r33*wsynt

# mean shear stress (must be computed before mirroring)
   uv=np.mean(usynt_aniso*vsynt_aniso)

# mirror vfluct
   if jmirror > 0:
      vsynt_aniso[jmirror:,:]=-vsynt_aniso[jmirror:,:]

# sum over timesteps
   uv_synt_mean=uv_synt_mean+uv

# compute average
   uvmean_time=np.abs(uv_synt_mean)/(it+1)
   print('uvmean_time',uvmean_time)

   scale_2=(uv_rans_max/uvmean_time)**0.5*uv_rans_non

# if uv_rans=1: don't scale
#  scale_2=np.where(uv_rans==1,1,(uv_rans_max/uvmean_time)**0.5*uv_rans_non)

# scale all fluctuations with uv_rans, see Section 5 in 
# L. Davidson "Two-equation hybrid RANS-LES models: A novel way to treat k and omega 
# at inlets and at embedded interfaces", J. of Turbulence, Volume 18, Issue 4, pp. 291-315, 2017.
   usynt_aniso=usynt_aniso*scale_2
   vsynt_aniso=vsynt_aniso*scale_2
   wsynt_aniso=wsynt_aniso*scale_2


# compute mean of synt fluct
   uvmean_check=uvmean_check+np.mean(usynt_aniso*vsynt_aniso,axis=1)

# peak of uv_rans
   j=np.where(uv_rans == np.amax(uv_rans))

# check peak
   print('synt: uvmean',np.abs(uvmean_check[j])/(it+1),'uv_rans_max=',np.max(np.abs(uv_rans)),'at j=',j)
 
   return usynt_aniso,vsynt_aniso,wsynt_aniso
