def compute_ustar(wdist,velabs,ustar_local,elog,n):

      for i in range(0,n):
         arg=np.maximum(elog*ustar_local*wdist/viscos,10.)
         ustar_local=0.41*velabs/np.log(arg)

      xyplus=ustar_local*wdist/viscos
      ustar_local=np.where(xyplus <= 11.69,(viscos*velabs/wdist)**0.5,ustar_local)

      return ustar_local
# /usr/bin/time -o out ~/anaconda3/bin/python example4-matlib-full-time-series.py
import scipy.io
import numpy as np
import sys
import matplotlib.pyplot as plt
import pandas as pd
from sklearn.preprocessing import MinMaxScaler
from sklearn.preprocessing import StandardScaler
from sklearn.svm import SVR
from sklearn.svm import LinearSVR
from sklearn.cluster import AgglomerativeClustering
#from sklearn.datasets.samples_generator import make_blobs
from sklearn.datasets import make_blobs
import pickle
from joblib import dump, load
from matplotlib import ticker

plt.close('all')

plt.interactive(True)

viscos=1/5200

# Read y
datay= np.loadtxt("y2d.dat")
yp_wall=datay[1]/2

yp_first_cell = np.loadtxt('yp-instant-IDDES.dat')
yp_second_cell = np.loadtxt('yp-2nd-instant-IDDES.dat')
yp_third_cell = np.loadtxt('yp-3rd-instant-IDDES.dat')



# Read local vel
u_first_cells_local = np.loadtxt('u-instant-IDDES-hist.dat')
u_second_cells_local = np.loadtxt('u2nd-instant-IDDES-hist.dat')
u_third_cells_local = np.loadtxt('u3rd-instant-IDDES-hist.dat')

u_first_cells=u_first_cells_local
u_second_cells=u_second_cells_local
u_third_cells=u_third_cells_local

u_wall=u_first_cells[:,0]




# use only N samples
N=100000
N=1000
N=len(u_wall)
ustar=(viscos*np.abs(u_wall)/yp_wall)**0.5


# make it 2D
ustar2d=np.repeat(ustar[None,:], repeats=9, axis=0)

n_wall0=len(u_wall)
n_vel=len(u_wall)

u_first_cell2d=np.transpose(u_first_cells[:,1:])
u_first_cell2d_full= u_first_cell2d

uplus2d=np.divide(u_first_cell2d,ustar2d)

NN=30
# pick every NNth
ustar2d=ustar2d[:,::NN]
uplus2d=uplus2d[:,::NN]
u_first_cell2d=u_first_cell2d[:,::NN]
u_wall=u_wall[::NN]


print('\nustar_min_cell2d[0]',np.min(ustar2d[0,:]))
print('ustar_min_cell2d[1]',np.min(ustar2d[1,:]))
print('ustar_min_cell2d[2]',np.min(ustar2d[2,:]))
print('ustar_min_cell2d[3]',np.min(ustar2d[3,:]))
print('ustar_min_cell2d[4]',np.min(ustar2d[4,:]))
print('ustar_min_cell2d[5]',np.min(ustar2d[5,:]))

print('\nustar_max_cell2d[0]',np.max(ustar2d[0,:]))
print('ustar_max_cell2d[1]',np.max(ustar2d[1,:]))
print('ustar_max_cell2d[2]',np.max(ustar2d[2,:]))
print('ustar_max_cell2d[3]',np.max(ustar2d[3,:]))
print('ustar_max_cell2d[4]',np.max(ustar2d[4,:]))
print('ustar_max_cell2d[5]',np.max(ustar2d[5,:]))


print('\nuplus_min_cell2d[0]',np.min(uplus2d[0,:]))
print('uplus_min_cell2d[1]',np.min(uplus2d[1,:]))
print('uplus_min_cell2d[2]',np.min(uplus2d[2,:]))
print('uplus_min_cell2d[3]',np.min(uplus2d[3,:]))
print('uplus_min_cell2d[4]',np.min(uplus2d[4,:]))
print('uplus_min_cell2d[5]',np.min(uplus2d[5,:]))
print('uplus_min_cell2d[6]',np.min(uplus2d[6,:]))
print('uplus_min_cell2d[7]',np.min(uplus2d[7,:]))
print('uplus_min_cell2d[8]',np.min(uplus2d[8,:]))

print('\nuplus_max_cell2d[0]',np.max(uplus2d[0,:]))
print('uplus_max_cell2d[1]',np.max(uplus2d[1,:]))
print('uplus_max_cell2d[2]',np.max(uplus2d[2,:]))
print('uplus_max_cell2d[3]',np.max(uplus2d[3,:]))
print('uplus_max_cell2d[4]',np.max(uplus2d[4,:]))
print('uplus_max_cell2d[5]',np.max(uplus2d[5,:]))
print('uplus_max_cell2d[6]',np.max(uplus2d[6,:]))
print('uplus_max_cell2d[7]',np.max(uplus2d[7,:]))
print('uplus_max_cell2d[8]',np.max(uplus2d[8,:]))



# compute y
y0= np.ones(n_wall0)

# compute y
y_first_cell2d=np.ones(n_vel)
y_first_cell2d= np.outer(yp_first_cell,y0)
## pick every NN
y_first_cell2d=y_first_cell2d[:,::NN]

# pick every NN

yplus_first_cell2d= y_first_cell2d*ustar2d/viscos

re_first_cell2d= y_first_cell2d*u_first_cell2d/viscos

# flatten along 1st index
# which points: n_start, n_end
n_start=0
n_end=9
u_first_cell=u_first_cell2d[n_start:n_end,:].flatten()
ustar=ustar2d[n_start:n_end,:].flatten()
uplus=uplus2d[n_start:n_end,:].flatten()





print('\ny_min,first_cell2d[0]',np.min(y_first_cell2d[0,:]))
print('y_min,first_cell2d[1]',np.min(y_first_cell2d[1,:]))
print('y_min,first_cell2d[2]',np.min(y_first_cell2d[2,:]))
print('y_min,first_cell2d[3]',np.min(y_first_cell2d[3,:]))
print('y_min,first_cell2d[4]',np.min(y_first_cell2d[4,:]))
print('y_min,first_cell2d[5]',np.min(y_first_cell2d[5,:]))

print('\ny_max,first_cell2d[0]',np.max(y_first_cell2d[0,:]))
print('y_max,first_cell2d[1]',np.max(y_first_cell2d[1,:]))
print('y_max,first_cell2d[2]',np.max(y_first_cell2d[2,:]))
print('y_max,first_cell2d[3]',np.max(y_first_cell2d[3,:]))
print('y_max,first_cell2d[4]',np.max(y_first_cell2d[4,:]))
print('y_max,first_cell2d[5]',np.max(y_first_cell2d[5,:]))
print('y_max,first_cell2d[6]',np.max(y_first_cell2d[6,:]))
print('y_max,first_cell2d[7]',np.max(y_first_cell2d[7,:]))
print('y_max,first_cell2d[8]',np.max(y_first_cell2d[8,:]))

print('\nyplus_min,first_cell2d[0]',np.min(yplus_first_cell2d[0,:]))
print('yplus_min,first_cell2d[1]',np.min(yplus_first_cell2d[1,:]))
print('yplus_min,first_cell2d[2]',np.min(yplus_first_cell2d[2,:]))
print('yplus_min,first_cell2d[3]',np.min(yplus_first_cell2d[3,:]))
print('yplus_min,first_cell2d[4]',np.min(yplus_first_cell2d[4,:]))
print('yplus_min,first_cell2d[5]',np.min(yplus_first_cell2d[5,:]))
print('yplus_min,first_cell2d[6]',np.min(yplus_first_cell2d[6,:]))
print('yplus_min,first_cell2d[7]',np.min(yplus_first_cell2d[7,:]))
print('yplus_min,first_cell2d[8]',np.min(yplus_first_cell2d[8,:]))

print('\nyplus_max,first_cell2d[0]',np.max(yplus_first_cell2d[0,:]))
print('yplus_max,first_cell2d[1]',np.max(yplus_first_cell2d[1,:]))
print('yplus_max,first_cell2d[2]',np.max(yplus_first_cell2d[2,:]))
print('yplus_max,first_cell2d[3]',np.max(yplus_first_cell2d[3,:]))
print('yplus_max,first_cell2d[4]',np.max(yplus_first_cell2d[4,:]))
print('yplus_max,first_cell2d[5]',np.max(yplus_first_cell2d[5,:]))
print('yplus_max,first_cell2d[6]',np.max(yplus_first_cell2d[6,:]))
print('yplus_max,first_cell2d[7]',np.max(yplus_first_cell2d[7,:]))
print('yplus_max,first_cell2d[8]',np.max(yplus_first_cell2d[8,:]))

print('\nyplus_mean,first_cell2d[0]',np.mean(yplus_first_cell2d[0,:]))
print('yplus_mean,first_cell2d[1]',np.mean(yplus_first_cell2d[1,:]))
print('yplus_mean,first_cell2d[2]',np.mean(yplus_first_cell2d[2,:]))
print('yplus_mean,first_cell2d[3]',np.mean(yplus_first_cell2d[3,:]))
print('yplus_mean,first_cell2d[4]',np.mean(yplus_first_cell2d[4,:]))
print('yplus_mean,first_cell2d[5]',np.mean(yplus_first_cell2d[5,:]))
print('yplus_mean,first_cell2d[6]',np.mean(yplus_first_cell2d[6,:]))
print('yplus_mean,first_cell2d[7]',np.mean(yplus_first_cell2d[7,:]))
print('yplus_mean,first_cell2d[8]',np.mean(yplus_first_cell2d[8,:]))

print('\nre_min,first_cell2d[0]',np.min(re_first_cell2d[0,:]))
print('re_min,first_cell2d[1]',np.min(re_first_cell2d[1,:]))
print('re_min,first_cell2d[2]',np.min(re_first_cell2d[2,:]))
print('re_min,first_cell2d[3]',np.min(re_first_cell2d[3,:]))
print('re_min,first_cell2d[4]',np.min(re_first_cell2d[4,:]))
print('re_min,first_cell2d[5]',np.min(re_first_cell2d[5,:]))

print('\nre_max,first_cell2d[0]',np.max(re_first_cell2d[0,:]))
print('re_max,first_cell2d[1]',np.max(re_first_cell2d[1,:]))
print('re_max,first_cell2d[2]',np.max(re_first_cell2d[2,:]))
print('re_max,first_cell2d[3]',np.max(re_first_cell2d[3,:]))
print('re_max,first_cell2d[4]',np.max(re_first_cell2d[4,:]))
print('re_max,first_cell2d[5]',np.max(re_first_cell2d[5,:]))

print('\nre_mean,first_cell2d[0]',np.mean(re_first_cell2d[0,:]))
print('re_mean,first_cell2d[1]',np.mean(re_first_cell2d[1,:]))
print('re_mean,first_cell2d[2]',np.mean(re_first_cell2d[2,:]))
print('re_mean,first_cell2d[3]',np.mean(re_first_cell2d[3,:]))
print('re_mean,first_cell2d[4]',np.mean(re_first_cell2d[4,:]))
print('re_mean,first_cell2d[5]',np.mean(re_first_cell2d[5,:]))


# flatten along 1st index
yplus_first_cell=yplus_first_cell2d[n_start:n_end,:].flatten()
re_first_cell=re_first_cell2d[n_start:n_end,:].flatten()
y_first_cell=y_first_cell2d[n_start:n_end,:].flatten()



u_second_cell2d=np.transpose(u_second_cells[:,1:])
# pick every NN
u_second_cell2d=u_second_cell2d[:,::NN]

print('\nu_max,second_cell2d[0]',np.max(u_second_cell2d[0,:]))
print('u_max,second_cell2d[1]',np.max(u_second_cell2d[1,:]))
print('u_max,second_cell2d[2]',np.max(u_second_cell2d[2,:]))
print('u_max,second_cell2d[3]',np.max(u_second_cell2d[3,:]))
print('u_max,second_cell2d[4]',np.max(u_second_cell2d[4,:]))
print('u_max,second_cell2d[5]',np.max(u_second_cell2d[5,:]))

print('\nu_mean,second_cell2d[0]',np.mean(u_second_cell2d[0,:]))
print('u_mean,second_cell2d[1]',np.mean(u_second_cell2d[1,:]))
print('u_mean,second_cell2d[2]',np.mean(u_second_cell2d[2,:]))
print('u_mean,second_cell2d[3]',np.mean(u_second_cell2d[3,:]))
print('u_mean,second_cell2d[4]',np.mean(u_second_cell2d[4,:]))
print('u_mean,second_cell2d[5]',np.mean(u_second_cell2d[5,:]))

# flatten along 1st index
u_second_cell=u_second_cell2d[n_start:n_end,:].flatten()

# compute y
#yplus_second_cell=np.zeros((6,n_vel))
#yplus_second_cell= np.outer(yp_second_cell,ustar)/viscos
y_second_cell=np.ones(n_vel)
y_second_cell2d= np.outer(yp_second_cell,y0)
# pick every NN
y_second_cell2d=y_second_cell2d[:,::NN]

print('\ny_min,second_cell2d[0]',np.min(y_second_cell2d[0,:]))
print('y_min,second_cell2d[1]',np.min(y_second_cell2d[1,:]))
print('y_min,second_cell2d[2]',np.min(y_second_cell2d[2,:]))
print('y_min,second_cell2d[3]',np.min(y_second_cell2d[3,:]))
print('y_min,second_cell2d[4]',np.min(y_second_cell2d[4,:]))
print('y_min,second_cell2d[5]',np.min(y_second_cell2d[5,:]))

print('\ny_max,second_cell2d[0]',np.max(y_second_cell2d[0,:]))
print('y_max,second_cell2d[1]',np.max(y_second_cell2d[1,:]))
print('y_max,second_cell2d[2]',np.max(y_second_cell2d[2,:]))
print('y_max,second_cell2d[3]',np.max(y_second_cell2d[3,:]))
print('y_max,second_cell2d[4]',np.max(y_second_cell2d[4,:]))
print('y_max,second_cell2d[5]',np.max(y_second_cell2d[5,:]))

# flatten along 1st index
#y_second_cell=y_second_cell2d.flatten()
y_second_cell=y_second_cell2d[n_start:n_end,:].flatten()

u_third_cell2d=np.transpose(u_third_cells[:,1:])
# pick every NN
u_third_cell2d=u_third_cell2d[:,::NN]

y_third_cell=np.ones(n_vel)
y_third_cell2d= np.outer(yp_third_cell,y0)
# pick every NN
y_third_cell2d=y_third_cell2d[:,::NN]

print('\ny_min,third_cell2d[0]',np.min(y_third_cell2d[0,:]))
print('y_min,third_cell2d[1]',np.min(y_third_cell2d[1,:]))
print('y_min,third_cell2d[2]',np.min(y_third_cell2d[2,:]))
print('y_min,third_cell2d[3]',np.min(y_third_cell2d[3,:]))
print('y_min,third_cell2d[4]',np.min(y_third_cell2d[4,:]))
print('y_min,third_cell2d[5]',np.min(y_third_cell2d[5,:]))

print('\ny_max,third_cell2d[0]',np.max(y_third_cell2d[0,:]))
print('y_max,third_cell2d[1]',np.max(y_third_cell2d[1,:]))
print('y_max,third_cell2d[2]',np.max(y_third_cell2d[2,:]))
print('y_max,third_cell2d[3]',np.max(y_third_cell2d[3,:]))
print('y_max,third_cell2d[4]',np.max(y_third_cell2d[4,:]))
print('y_max,third_cell2d[5]',np.max(y_third_cell2d[5,:]))




################## plot


datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

y=yp2d[1,:]
# z grid
zmax, nk=np.loadtxt('z.dat')
nk=np.int(nk)
zp = np.linspace(0, zmax, nk)

itstep,nk,dz=np.load('itstep.npy')
u2d=np.load('u_averaged.npy')/itstep
u=np.mean(u2d,axis=0)


yDNS= y
uDNS= u

dudyDNS=np.gradient(u,yDNS)

# compute autocorr, last cell
u1=u_first_cell2d_full[-1,:]
u1_fluct=u1-np.mean(u1)
two=np.correlate(u1_fluct,u1_fluct,'full')
# find max
nmax=np.argmax(two)
# and its value
two_max=np.max(two)
# Pick the right half and normalize
two_sym_norm=two[nmax:]/two_max
# find negaative values
neg_two_sym = np.where(two_sym_norm <0)
# first neg index
i_neg=neg_two_sym[0][0]

# auto correlation
dt=1
int_T_1=np.trapz(two_sym_norm[0:i_neg])*dt  # integral time scale in number of time steps

print('integral time scale (dt=1)',int_T_1)


# compute y
y_third_cell=np.ones(n_vel)
y_third_cell= np.outer(yp_third_cell,y0)

dudy_first_cell=(u_second_cell-u_first_cell)/(y_second_cell-y_first_cell)

# make it non-dimensional
tscale=viscos/u_first_cell**2  # [m2/s/(m2/s2) = [s]

dudy_first_cell=dudy_first_cell*tscale



print('\ndudy_min,first_cell',np.min(dudy_first_cell))
print('\ndudy_max,first_cell',np.max(dudy_first_cell))

# find element where y+ > 100
index_yplus_100= np.where(yplus_first_cell > 100)

# remove them
yplus_first_cell_org= yplus_first_cell
yplus_first_cell=np.delete(yplus_first_cell,index_yplus_100)
uplus=np.delete(uplus,index_yplus_100)
dudy_first_cell=np.delete(dudy_first_cell,index_yplus_100)
re_first_cell_org= re_first_cell

dudy_in_all_data=dudy_first_cell
yplus_in_all_data=yplus_first_cell
re_in_all_data=re_first_cell




print('\nyplus_min',np.min(yplus_in_all_data))
print('yplus_max',np.max(yplus_in_all_data))

print('\nre_min',np.min(re_in_all_data))
print('re_max',np.max(re_in_all_data))


y_first_cell_all=y_first_cell


# two input variables: y and u
# one output: ustar


# training and test data
index= np.arange(0,len(dudy_in_all_data), dtype=int)
# pick 20%
n_test=int(0.2*len(dudy_in_all_data))
n_svr=len(dudy_in_all_data)-n_test
index_test=np.random.choice(index, size=n_test, replace=False)
dudy_in_test=dudy_in_all_data[index_test]
yplus_in_test=yplus_in_all_data[index_test]
re_in_test=re_in_all_data[index_test]
uplus_out_test=uplus[index_test]
ustar_out_test=ustar[index_test]
y_first_cell_test=y_first_cell_all[index_test]

print('yplus_in_test[0]',yplus_in_test[0])



y_first_cell_test=y_first_cell[index_test]
dudy_in=np.delete(dudy_in_all_data,index_test)
re_in=np.delete(re_in_all_data,index_test)
yplus_in=np.delete(yplus_in_all_data,index_test)
uplus_out=np.delete(uplus,index_test)
y_first_cell=np.delete(y_first_cell_all,index_test)




print('\nlen(uplus)',len(uplus))
print('len(uplus_out)',len(uplus_out))
print('len(yplus_in_all_data)',len(yplus_in_all_data))
print('len(dudy_in_all_data)',len(dudy_in_all_data))
print('len(yplus_in)',len(yplus_in))
print('len(dudy_in)',len(dudy_in))
print('len(u_wall)',len(u_wall))

print('\nlen(uplus_out_test)',len(uplus_out_test))
print('len(yplus_in_test)',len(yplus_in_test))
print('len(dudy_in_test)',len(dudy_in_test))
print('n_test',n_test)
print('n_svr',n_svr)
print('n_wall0',n_wall0)

print('np.max(uplus_out)',np.max(uplus_out))
print('np.min(uplus_out)',np.min(uplus_out))

print('np.max(yplus_in)',np.max(yplus_in))
print('np.min(yplus_in)',np.min(yplus_in))

print('np.max(dudy_in)',np.max(dudy_in))
print('np.min(dudy_in)',np.min(dudy_in))

print('np.mean(yplus_in)',np.mean(yplus_in))
print('np.mean(dudy_in)',np.mean(dudy_in))


dudy_min=np.min(dudy_in)
dudy_max=np.max(dudy_in)
yplus_max=np.max(yplus_in)
yplus_min=np.min(yplus_in)
re_max=np.max(re_in)
re_min=np.min(re_in)


dudy_in=dudy_in.reshape(-1, 1)
yplus_in=yplus_in.reshape(-1, 1)
re_in=re_in.reshape(-1, 1)

# Use MinMax scaling 
#scaler=MinMaxScaler()
scaler_dudy=StandardScaler()
scaler_yplus=StandardScaler()
scaler_re=StandardScaler()
dudy_in=scaler_dudy.fit_transform(dudy_in)
yplus_in=scaler_yplus.fit_transform(yplus_in)
re_in=scaler_re.fit_transform(re_in)

y=uplus_out
X=np.zeros((n_svr,1))
X[:,0]=yplus_in[:,0]
# one variable
#X=np.zeros(n_svr)
#X=y_in[:,0]
#X=X.reshape(-1, 1)

print('starting SVR')


# ----------- Model fitting -----------
# Define models and set hyperparameter values
#model = SVR(kernel='rbf', epsilon = 0.01, C = 100)  #error: 0.06
C=0.01
C=1
C=100
C=0.1
C=10
eps=0.001
model = SVR(kernel='rbf', epsilon = eps, C = C)
# Define models and set hyperparameter values
#model = SVR(kernel='linear', epsilon = eps, C=C)
#model = LinearSVR(epsilon = eps , C = C)
#model = LinearSVR(epsilon = 0.01, C = 1)
#' linear’, ‘poly’, ‘rbf’, ‘sigmoid’, ‘precomputed
#model = SVR(kernel='rbf', epsilon = 0.1, C = 0.01)


print('eps,C=',eps,C)

# Fit the model
svr = model.fit(X, y.flatten())


print('yplus_in_test[0],dudy_in_test[0]',yplus_in_test[0],dudy_in_test[0])

# Use MinMax scaling 
dudy_in_test=dudy_in_test.reshape(-1, 1)
re_in_test=re_in_test.reshape(-1, 1)
yplus_in_test=yplus_in_test.reshape(-1, 1)
dudy_in_test=dudy_in_test.reshape(-1, 1)
dudy_in_test=scaler_dudy.transform(dudy_in_test)
re_in_test=scaler_re.transform(re_in_test)
yplus_in_test=scaler_yplus.transform(yplus_in_test)
dudy_in_test=scaler_dudy.transform(dudy_in_test)

# test
X_test=np.zeros((n_test,1))
X_test[:,0]=yplus_in_test[:,0]

# one variable
#X_test=np.zeros(n_test)
#X_test=y_in_test[:,0]
#
y_svr = model.predict(X_test)

print('y_svr[0]',y_svr[0])

# correlations
corr_uplus=np.dot(y_svr.flatten(),uplus_out_test.flatten())/(np.sum(uplus_out_test.flatten()**2))**0.5/(np.sum(y_svr**2))**0.5
print('correlation between prediction (svr) and uplus for DNS',corr_uplus)

# find difference
uplus_rms=np.std(y_svr-uplus_out_test)/(np.mean(uplus_out_test.flatten()**2))**0.5/(np.mean(y_svr**2))**0.5
print('max_error_uplus',np.max(y_svr-uplus_out_test))
print('min_error_uplus',np.min(y_svr-uplus_out_test))
print('rms_error',uplus_rms)

dy=yp_wall # distance between cell center to the wall
#velabs=np.abs(dudy_in_test[0:n].flatten())
#re_first_cell2d= y_first_cell2d*u_first_cell2d/viscos
re_in_no_scale=scaler_re.inverse_transform(re_in_test)
velabs=re_in_no_scale.flatten()/y_first_cell_test.flatten()*viscos

print('velabs.shape',velabs.shape)
# compute ustar
n=len(velabs)
ustar_log=ustar_out_test[0:n]

#ustar_log_new=compute_ustar(y_first_cell_test.flatten(),velabs,ustar_log,9,10)
ustar_log_new=compute_ustar(y_first_cell_test.flatten(),velabs,ustar_log,9.0,10)

uplus_log=velabs/ustar_log_new

uplus_log_ustar1=np.log(9.0*yDNS/viscos)/0.41

uplus_log_rms=np.std(uplus_log-uplus_out_test)/(np.mean(uplus_out_test.flatten()**2))**0.5/(np.mean(uplus_log**2))**0.5
print('rms_error_uplus_log',uplus_log_rms)







dy=yp_wall # distance between cell center to the wall
#velabs=np.abs(dudy_in_test[0:n].flatten())
#re_first_cell2d= y_first_cell2d*u_first_cell2d/viscos
yplus_in_no_scale=scaler_yplus.inverse_transform(yplus_in_test)
dudy_in_no_scale=scaler_dudy.inverse_transform(dudy_in_test)
velabs=yplus_in_no_scale.flatten()/y_first_cell_test.flatten()*viscos



# save the model to disk

filename = 'model-low-re-svr-C-10-eps-0.001-yplus-inst-uplus-output-first-cell-1-9-local-cells-300-samples-yplus.le.100.bin'
dump(model, filename)
dump(scaler_yplus,'model-low-ustar-svr-C-10-eps-0.001-yplus-inst-uplus-output-first-cell-1-9-local-cell_scaler-yplus-300-samples-yplus.le.100.bin')

np.savetxt('min-max-model-low-re-svr-C-10-eps-0.001-yplus-inst-uplus-output-first-cell-1-9-local-cells-loca-300-samples-yplus.le.100.txt', [yplus_max, yplus_min])

dudy_in_test_no_scale=scaler_dudy.inverse_transform(dudy_in_test.flatten())/tscale[index_test].flatten()
dudy_in_test_no_scale_with_t=scaler_dudy.inverse_transform(dudy_in_test.flatten())

corr_u_dudy=np.dot(velabs.flatten(),dudy_in_test_no_scale.flatten())/(np.sum(velabs.flatten()**2))**0.5/(np.sum(dudy_in_test_no_scale**2))**0.5
print('correlation between u ans dudy',corr_u_dudy)

corr_u_dudy_with_t=np.dot(velabs.flatten(),dudy_in_test_no_scale_with_t.flatten())/(np.sum(velabs.flatten()**2))**0.5/(np.sum(dudy_in_test_no_scale_with_t**2))**0.5

print('correlation between u ans dudy_with_t',corr_u_dudy_with_t)



# y_max,first_cell2d[0] 0.00045760361583418595
# y_max,first_cell2d[1] 0.0010141852616839084
# y_max,first_cell2d[2] 0.0015382906289576732
# y_max,first_cell2d[3] 0.0026577751227680924
# y_max,first_cell2d[4] 0.0043603711022920134
# y_max,first_cell2d[5] 0.006949806762650455
# y_max,first_cell2d[6] 0.010888014722598099
# y_max,first_cell2d[7] 0.01459643009101669
# y_max,first_cell2d[8] 0.019500809415750272

point_1= np.where(y_first_cell_test< 0.00046)
point_1=point_1[0]

point_2= np.where((y_first_cell_test> 0.00047) & (y_first_cell_test< 0.0011))
point_2=point_2[0]

point_3= np.where((y_first_cell_test> 0.0012) & (y_first_cell_test< 0.0016))
point_3=point_3[0]

point_4= np.where((y_first_cell_test> 0.0017) & (y_first_cell_test<  0.0027))
point_4=point_4[0]

point_5= np.where((y_first_cell_test>  0.0028) & (y_first_cell_test< 0.0044))
point_5=point_5[0]

point_6= np.where((y_first_cell_test> 0.0045) & (y_first_cell_test< 0.007))
point_6=point_6[0]

point_7= np.where((y_first_cell_test> 0.008) & (y_first_cell_test< 0.011))
point_7=point_7[0]

point_8= np.where((y_first_cell_test> 0.012) & (y_first_cell_test< 0.015))
point_8=point_8[0]

point_9= np.where((y_first_cell_test> 0.020))
point_9=point_9[0]

################### 2D scatter top view plot all points
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
ax=plt.gca()

# plot all points
#plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), uplus_out_test,marker='o', s=20.2,c='black')
plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), y_svr,marker='v', s=20.2,c='red')
#plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), uplus_log,marker='o', s=20.2,c='black')


# log-law
#plt.plot(yDNS/viscos,uplus_log_ustar1,'r-')
# IDDES data
plt.plot(yDNS/viscos,uDNS,'b-')

#label axes
ax.set_ylabel(r'$U^+$')
plt.xlabel('$y^+$')

plt.axis([0,120,0,24])

plt.savefig('scatter-ustar-vs-yplus-svr-C-10-eps-0.001-low-yplus-inst-uplus-output-first-cell-1-9-local-300-samples-yplus.le.100.png',bbox_inches='tight')

################### 2D scatter top view, split into y+
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
ax=plt.gca()

#plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), ustar_out_test, marker='o', s=20.2,c='black')
plt.scatter(scaler_re.inverse_transform(dudy_in_test[point_1]), uplus_out_test[point_1], marker='v', s=20.2,c='blue')
plt.scatter(scaler_re.inverse_transform(dudy_in_test[point_2]), uplus_out_test[point_2], marker='v', s=20.2,c='red')
plt.scatter(scaler_re.inverse_transform(dudy_in_test[point_3]), uplus_out_test[point_3], marker='v', s=20.2,c='black')

plt.scatter(scaler_re.inverse_transform(dudy_in_test[point_4]), uplus_out_test[point_4], marker='o', s=20.2,c='blue')
plt.scatter(scaler_re.inverse_transform(dudy_in_test[point_5]), uplus_out_test[point_5], marker='o', s=20.2,c='red')
plt.scatter(scaler_re.inverse_transform(dudy_in_test[point_6]), uplus_out_test[point_6], marker='o', s=20.2,c='black')

#label axes
ax.set_ylabel(r'$U^+$')
plt.xlabel('$Re$')

plt.axis([0,580,0,15])

plt.savefig('scatter-ustar-vs-yplus-split-svr-C-10-eps-0.001-low-yplus-inst-uplus-output-first-cell-1-9-local-300-samples-yplus.le.100.png',bbox_inches='tight')

################### 2D scatter top view, at y+, zoom at 7.1) & (yplus_no_scale< 16
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
ax=plt.gca()

#plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), ustar_out_test, marker='o', s=20.2,c='black')
plt.scatter(scaler_yplus.inverse_transform(yplus_in_test[point_2]), uplus_out_test[point_2], marker='v', s=20.2,c='red')

#label axes
ax.set_ylabel(r'$U^+$')
plt.xlabel('$y^+$')

plt.axis([9.8,11,8,9])

plt.savefig('scatter-uplus-vs-yplus-zoom-point-2-split-svr-C-10-eps-0.001-low-yplus-inst-uplus-output-first-cell-1-9-local-300-samples-yplus.le.100.png',bbox_inches='tight')


################### 2D scatter top view plot all points,DNS
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
ax=plt.gca()

# plot all points
plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), uplus_out_test,marker='o', s=20.2,c='black')
#plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), y_svr,marker='v', s=20.2,c='red')
#plt.scatter(scaler_yplus.inverse_transform(yplus_in_test), uplus_log,marker='o', s=20.2,c='black')


# log-law
#plt.plot(yDNS/viscos,uplus_log_ustar1,'r-')
# IDDES data
plt.plot(yDNS/viscos,uDNS,'b-')

#label axes
ax.set_ylabel(r'$U^+$')
plt.xlabel('$y^+$')

plt.axis([0,120,0,24])

plt.savefig('scatter-ustar-vs-yplus-DNS-first-cell-1-9-local-300-samples-yplus.le.100.png',bbox_inches='tight')


