import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes

plt.rcParams.update({'font.size': 22})

plt.interactive(True)
plt.close('all')

viscos=1/2000

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

x=xp2d[:,0]
y=yp2d[0,:]

#z grid
zmax, nk=np.loadtxt('z.dat')
nk=np.int(nk)
zp = np.linspace(0, zmax, nk)

itstep,nk,dz=np.load('itstep.npy')
p2d=np.load('p_averaged.npy')/itstep
u2d=np.load('u_averaged.npy')/itstep
v2d=np.load('v_averaged.npy')/itstep
w2d=np.load('w_averaged.npy')/itstep
k2d=np.load('k_averaged.npy')/itstep
vis2d=np.load('vis_averaged.npy')/itstep
eps2d=np.load('eps_averaged.npy')/itstep
uu2d=np.load('uu_stress.npy')/itstep
vv2d=np.load('vv_stress.npy')/itstep
ww2d=np.load('ww_stress.npy')/itstep
uv2d=np.load('uv_stress.npy')/itstep
fk2d=np.load('fk_averaged.npy')/itstep
om2d=np.load('om_averaged.npy')/itstep

uu2d=uu2d-u2d**2
vv2d=vv2d-v2d**2
uv2d=uv2d-u2d*v2d

ustar=(viscos*u2d[:,0]/yp2d[:,0])**0.5
yplus2d=np.ones((ni,nj))
for i in range(0,ni):
   yplus2d[i,:]=ustar[i]*yp2d[i,:]/viscos

cf=ustar**2/np.max(u2d[:,]**2)/0.5

kres_2d=0.5*(uu2d+vv2d+ww2d)


        # y/h             y+              U+             u'+             v'+             w'+           -Om_z+          om_x'+           om_y'+           om_z'+         uv'+             uw'+           vw'+             pr'+            ps'+          psto'+            p'
# ----------------------------------------------------------------------------------------------------------------------------------------
DNS_mean=np.genfromtxt("/chalmers/users/lada/DNS_channel_550_950_2000/Re2000_jimenez.dat",comments="%")
y_DNS=DNS_mean[:,0]
yplus_DNS=DNS_mean[:,1]
u_DNS=DNS_mean[:,2]
u2_DNS=DNS_mean[:,3]**2
v2_DNS=DNS_mean[:,4]**2
w2_DNS=DNS_mean[:,5]**2
uv_DNS=DNS_mean[:,10]

k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS)

#
# compute re_delta1 for boundary layer flow
dx=x[3]-x[2]
re_disp_bl=np.zeros(ni)
delta_disp=np.zeros(ni)
for i in range (0,ni-1):
   d_disp=0
   for j in range (1,nj-1):
      up=u2d[i,j]/u2d[i,-1]
      dy=y2d[i,j]-y2d[i,j-1]
      d_disp=d_disp+(1.-min(up,1.))*dy

   delta_disp[i]=d_disp
   re_disp_bl[i]=d_disp*u2d[i,-1]/viscos

re_disp_bl[-1]=re_disp_bl[-1-1]
delta_disp[-1]=delta_disp[-1-1]


##########################################  displacement thickness
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,1],delta_disp,'b-')
plt.ylabel("$\delta^*$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],0,0.2])
plt.savefig('delta_disp.png',bbox_inches='tight')

##########################################  Clauser beta 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
dpdx=np.gradient(p2d[:,-1],xp2d[:,1])
beta=delta_disp*dpdx/ustar**2
plt.plot(xp2d[:,1],beta,'b-')
plt.ylabel(r"$\beta$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],-1,4])
plt.savefig('beta-dpdx.png',bbox_inches='tight')


##########################################  P+
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.30,bottom=0.20)
dpdx=np.gradient(p2d[:,-1],xp2d[:,1])
p_plus=viscos*dpdx/ustar**3
plt.plot(xp2d[:,1],p_plus,'b-')
plt.ylabel(r"$P^+$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],-0.01,0.01])
plt.savefig('p-plus.png',bbox_inches='tight')


##########################################  cf
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
plt.plot(xp2d[:,1],cf,'b-')
plt.ylabel("$C_f$")
plt.xlabel("$x$")
plt.axis([xp2d[0,0],xp2d[-1,0],0,0.0075])
plt.savefig('cf.png',bbox_inches='tight')


########################################## U log
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.semilogx(yplus_DNS[::10],u_DNS[::10],'bo')
i1 =1
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'b-',label="inlet")
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.semilogx(yplus2d[i1,:],u2d[i1,:]/ustar[i1],'b--',label='x='+str(xx))

plt.legend(loc='best',prop=dict(size=13))
plt.ylabel("$U^+$")
plt.xlabel("$y^+$")
plt.axis([1, 2000, 0, 25])
plt.savefig('u_log.png',bbox_inches='tight')

########################################## V 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'b-',label="inlet")
xx=0;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'r-',label='x='+str(xx))
xx=1;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'k-',label='x='+str(xx))
xx=2;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],v2d[i1,:]/ustar[i1],'b--',label='x='+str(xx))
plt.legend(loc='best',prop=dict(size=13))
plt.ylabel("$V^+$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,0,2])
plt.savefig('v.png',bbox_inches='tight')

########################################## U  linear
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(y_DNS[::10],u_DNS[::10],'bo',label='DNS')
i1 = 0
plt.plot(yp2d[i1,:],u2d[i1,:],'b-',label="inlet")
xx=0;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],u2d[i1,:],'r-',label='x='+str(xx))
xx=1;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],u2d[i1,:],'k-',label='x='+str(xx))
xx=2;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],u2d[i1,:],'b--',label='x='+str(xx))
plt.legend(loc='best',prop=dict(size=13))
plt.ylabel("$U$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,0,28])
plt.savefig('u.png',bbox_inches='tight')

########################################## vis 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'b-',label="inlet")
xx=0;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'r-',label='x='+str(xx))
xx=1;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'k-',label='x='+str(xx))
xx=2;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vis2d[i1,:]/viscos,'b--',label='x='+str(xx))
plt.legend(loc='best',fontsize=14)
plt.ylabel(r"$\nu_t/\nu$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,0,3])
plt.savefig('vis.png',bbox_inches='tight')


########################################## uv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'b-',label='inlet')
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uv2d[i1,:]/ustar[i1]**2,'b--',label='x='+str(xx))

plt.legend(loc='best',fontsize=14)

plt.ylabel(r"$\overline{u'v'}$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,-2,0])
plt.savefig('uv.png',bbox_inches='tight')



########################################## uu 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],uu2d[i1,:]/ustar[i1]**2,'b-',label='inlet')
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uu2d[i1,:]/ustar[i1]**2,'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uu2d[i1,:]/ustar[i1]**2,'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],uu2d[i1,:]/ustar[i1]**2,'b--',label='x='+str(xx))

plt.legend(loc='best',fontsize=14)

plt.ylabel(r"$\overline{u'u'}$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,0,10])
plt.savefig('uu.png',bbox_inches='tight')



########################################## ww 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],ww2d[i1,:]/ustar[i1]**2,'b-',label='inlet')
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],ww2d[i1,:]/ustar[i1]**2,'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],ww2d[i1,:]/ustar[i1]**2,'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],ww2d[i1,:]/ustar[i1]**2,'b--',label='x='+str(xx))

plt.legend(loc='best',fontsize=14)

plt.ylabel(r"$\overline{w'w'}$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,0,3])
plt.savefig('ww.png',bbox_inches='tight')



########################################## vv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],vv2d[i1,:]/ustar[i1]**2,'b-',label='inlet')
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vv2d[i1,:]/ustar[i1]**2,'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vv2d[i1,:]/ustar[i1]**2,'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vv2d[i1,:]/ustar[i1]**2,'b--',label='x='+str(xx))

plt.legend(loc='best',fontsize=14)

plt.ylabel(r"$\overline{v'v'}^+$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,0,2])
plt.savefig('vv.png',bbox_inches='tight')



########################################## vv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
i1 = 0
plt.plot(yp2d[i1,:],vv2d[i1,:],'b-',label='inlet')
xx=0
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vv2d[i1,:],'r-',label='x='+str(xx))
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vv2d[i1,:],'k-',label='x='+str(xx))
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(yp2d[i1,:],vv2d[i1,:],'b--',label='x='+str(xx))

plt.legend(loc='best',fontsize=14)

plt.ylabel(r"$\overline{v'v'}$")
plt.xlabel("$y$")
plt.axis([y2d[i1,0],1,0,2])
plt.savefig('vv-no-ustar.png',bbox_inches='tight')





