import scipy.io as sio
import numpy as np
import sys
import matplotlib.pyplot as plt
#import gradients.py
from gradients import compute_face_phi,dphidx,dphidy,init
plt.rcParams.update({'font.size': 22})

plt.interactive(True)

plt.close('all')

viscos=1/2000

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

#z grid
zmax, nk=np.loadtxt('z.dat')
nk=int(nk)

x=xp2d[:,0]
y=yp2d[0,:]


name='../channel-2000-WALE-300-111-300-half-channel-2dt/'

N=16000

u=np.zeros((nj,nk,16000))
v=np.zeros((nj,nk,16000))
w=np.zeros((nj,nk,16000))

n=0
for itstep in range(0,N):
   if itstep%50 == 0:
      counter=itstep-int(itstep/15900)*15900
      file_name=str(name)+'inlet-files/uvw_' + str(counter+1) + '.npy'
      print('itstep,counter,file: ',itstep,counter,file_name)
      data = np.load(file_name)
      u[:,:,n]= data[:,:,0]
      v[:,:,n]= data[:,:,1]
      w[:,:,n]= data[:,:,2]
      n=n+1

u=u[:,:,0:n]
v=v[:,:,0:n]
w=w[:,:,0:n]

umean=np.mean(u,axis=(1,2))


ustar=(viscos*umean[0]/y[0])**0.5
yplus=y*ustar/viscos



        # y/h             y+              U+             u'+             v'+             w'+           -Om_z+          om_x'+           om_y'+           om_z'+         uv'+             uw'+           vw'+             pr'+            ps'+          psto'+            p'
# ----------------------------------------------------------------------------------------------------------------------------------------
DNS_mean=np.genfromtxt("/chalmers/users/lada/DNS_channel_550_950_2000/Re2000_jimenez.dat",comments="%")
y_DNS=DNS_mean[:,0]
yplus_DNS=DNS_mean[:,1]
u_DNS=DNS_mean[:,2]
u2_DNS=DNS_mean[:,3]**2
v2_DNS=DNS_mean[:,4]**2
w2_DNS=DNS_mean[:,5]**2
uv_DNS=DNS_mean[:,10]

k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS)




########################################## U log
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.semilogx(yplus_DNS,u_DNS,'r--',label='DNS')
plt.semilogx(yplus,umean/ustar,'b-',label="inlet")

plt.legend(loc='best',prop=dict(size=13))
plt.ylabel("$U^+$")
plt.xlabel("$y^+$")
plt.axis([1, 2000, 0, 25])
plt.savefig('u_inlet.png')

