
# compute face value of U and V
u2d_face_w,u2d_face_s=compute_face_phi_D_or_N(u2d,fx,fy,ni,nj,'d','n')
v2d_face_w,v2d_face_s=compute_face_phi_D_or_N(v2d,fx,fy,ni,nj,'d','d')
p2d_face_w,p2d_face_s=compute_face_phi_D_or_N(p2d,fx,fy,ni,nj,'n','n')
k2d_face_w,k2d_face_s=compute_face_phi_D_or_N(k_RANS2d,fx,fy,ni,nj,'d','n')
uv2d_face_w,uv2d_face_s=compute_face_phi_D_or_N(uv2d,fx,fy,ni,nj,'d','d')

# x derivatives
dudx=dphidx(u2d_face_w,u2d_face_s,areawx,areasx,vol)
dvdx=dphidx(v2d_face_w,v2d_face_s,areawx,areasx,vol)
dpdx=dphidx(p2d_face_w,p2d_face_s,areawx,areasx,vol)
dkdx=dphidx(k2d_face_w,k2d_face_s,areawx,areasx,vol)
duvdx=dphidx(uv2d_face_w,uv2d_face_s,areawx,areasx,vol)

# y derivatives
dudy=dphidy(u2d_face_w,u2d_face_s,areawy,areasy,vol)
dvdy=dphidy(v2d_face_w,v2d_face_s,areawy,areasy,vol)
dpdy=dphidy(p2d_face_w,p2d_face_s,areawy,areasy,vol)
dkdy=dphidy(k2d_face_w,k2d_face_s,areawy,areasy,vol)
duvdy=dphidy(uv2d_face_w,uv2d_face_s,areawy,areasy,vol)



############################ k eq.
# turb. diff 
visdkdx=vist_RANS2d*dkdx
visdkdy=vist_RANS2d*dkdy

visk_face_w,visk_face_s=compute_face_phi_D_or_N(visdkdy,fx,fy,ni,nj,'n','n')
dviskdy=dphidy(visk_face_w,visk_face_s,areawy,areasy,vol)
dviskdx=dphidx(visk_face_w,visk_face_s,areawx,areasx,vol)
turb_diff=dviskdy+dviskdx

# visc. diff 
dkdy_face_w,dkdy_face_s=compute_face_phi_D_or_N(dkdy,fx,fy,ni,nj,'n','n')
d2kdy2=dphidy(dkdy_face_w,dkdy_face_s,areawy,areasy,vol)
visc_diff=viscos*d2kdy2

# convection
d2kdy2=dphidy(dkdy_face_w,dkdy_face_s,areawy,areasy,vol)
convx=-u2d*dkdx
convy=-v2d*dkdy
conv=convx+convy

# production
pk=-uu2d*dudx-uv2d*(dudy+dvdy)-vv2d*dvdy

#************
# plot balance(k)
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.01
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(turb_diff[i,:],yp2d[i,:],'b-',label='turb.diff')
ax1.plot(visc_diff[i,:],yp2d[i,:],'r-',label='visc. diff')
ax1.plot(convx[i,:],yp2d[i,:],'b--',label='conv')
ax1.plot(pk[i,:],yp2d[i,:],'r--',label='prod')
ax1.plot(-eps_RANS2d[i,:],yp2d[i,:],'m-',label=r'$-\varepsilon_{RANS}$')
ax1.plot(-eps2d[i,:],yp2d[i,:],'g-',label=r'$-\varepsilon_{DNS}$')
M=3
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.axis([-0.02,0.02,0,0.05])
plt.xlabel('terms in $k$ eq.')
plt.ylabel('y/H')
plt.savefig('k-balance-python.png')

############################ uv eq.
# turb. diff 
visduvdx=vist_RANS2d*duvdx
visduvdy=vist_RANS2d*duvdy

visuv_face_w,visuv_face_s=compute_face_phi_D_or_N(visduvdy,fx,fy,ni,nj,'n','n')
dvisuvdy=dphidy(visuv_face_w,visuv_face_s,areawy,areasy,vol)
dvisuvdx=dphidx(visuv_face_w,visuv_face_s,areawx,areasx,vol)
turb_diff=dviskdy+dviskdx

# visc. diff 
duvdy_face_w,duvdy_face_s=compute_face_phi_D_or_N(duvdy,fx,fy,ni,nj,'n','n')
d2uvdy2=dphidy(duvdy_face_w,duvdy_face_s,areawy,areasy,vol)
visc_diff=viscos*d2uvdy2

# convection
d2uvdy2=dphidy(duvdy_face_w,duvdy_face_s,areawy,areasy,vol)
convx=-u2d*duvdx
convy=-v2d*duvdy
conv=convx+convy

# production P_ij= -v_iv_k*dV_j/dx_k  -v_jv_k*dV_i/dx_k 
# P_12 = -v_1v_1*dV_2/dx_1 -v_1v_2*dV_2/dx_2 -v_2v_1*dV_1/dx_1 -v_2v_2*dV_1/dx_2 
puv=-uu2d*dvdy-uv2d*dvdy-uv2d*dudx-vv2d*dudy

#************
# plot ddy(vis*dkdy)
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.01
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(turb_diff[i,:],yp2d[i,:],'b-',label='turb.diff')
ax1.plot(visc_diff[i,:],yp2d[i,:],'r-',label='visc. diff')
ax1.plot(convx[i,:],yp2d[i,:],'b--',label='conv')
ax1.plot(puv[i,:],yp2d[i,:],'r--',label='prod')
M=3
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.axis([-0.008,0.005,0,0.05])
plt.xlabel('terms in $\overline{u^\prime v^\prime }$ eq.')
plt.ylabel('y/H')
plt.ylabel('y/H')
plt.savefig('uv-balance-python.png')

# chech realizable
s11=dudx
s12=0.5*(dudy+dvdy)
s22=dvdy
s=(s11**2+2*s12**2+s22**2)**0.5
vis_limit = (2*s)**0.3333

sys.exit()

#************
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.1
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(k_RANS2d[i,:],yp2d[i,:],'b-',label='x='+str(xx))
M=3
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.xlabel(r'$k_{RANS}$')
plt.ylabel('y/H')
plt.savefig('k-RANS-python.png')

#************
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.1
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(vist_RANS2d[i,:]/viscos,yp2d[i,:],'b-',label='x='+str(xx))
M=3
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.xlabel(r'$\nu_{t,RANS}/\nu$')
plt.ylabel('y/H')
plt.savefig('vis-RANS-python.png')



################################ vector plot
fig2 = plt.figure()
plt.subplots_adjust(left=0.20,top=0.80,bottom=0.20)
k=6# plot every forth vector
ss=3.2 #vector length
plt.quiver(xp2d[::k,::k],yp2d[::k,::k],u2d[::k,::k],v2d[::k,::k],width=0.01)
plt.xlabel("$x$")
plt.ylabel("$y$")
plt.title("vector plot")
plt.savefig('vect_python.png')

################################ contour plot
fig2 = plt.figure()
plt.subplots_adjust(left=0.20,top=0.80,bottom=0.20)
plt.pcolormesh(xp2d,yp2d,dudy, vmin=-5,vmax=5,cmap=plt.get_cmap('hot'),shading='gouraud')
plt.colorbar()
plt.xlabel("$x$")
plt.ylabel("$y$")
plt.title(r"the gradient $\partial \bar{v}_1/\partial x_2$")
plt.savefig('dudy.png')


#************
# plot uv
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv2d[i,:],yp2d[i,:],'b-',label='x='+str(xx))
xx=2.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv2d[i,:],yp2d[i,:],'r-',label='x='+str(xx))
M = 2 # use only two major xticks
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.xlabel('$\overline{u^\prime v^\prime}$')
plt.ylabel('y/H')
plt.savefig('uv_python.png')


#************
# plot k_RANS
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(k_RANS2d[i,:],yp2d[i,:],'b-',label='x='+str(xx))
xx=2.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(k_RANS2d[i,:],yp2d[i,:],'r-',label='x='+str(xx))
M = 2 # use only two major xticks
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.xlabel('$k$')
plt.ylabel('y/H')
plt.savefig('k_RANS_python.png')



