import scipy.io as sio
import numpy as np
import sys
import matplotlib.pyplot as plt
import matplotlib.ticker as mtick
from matplotlib import ticker
from gradients import compute_face_phi_D_or_N,dphidx,dphidy,init

plt.rcParams.update({'font.size': 22})

plt.interactive(True)

plt.close('all')

nu=1/550
viscos=nu

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

x=xp2d[:,0]
y=yp2d[0,:]

#z grid
zmax, nk=np.loadtxt('z.dat')
nk=np.int(nk)
zp = np.linspace(0, zmax, nk)

itstep,nk,dz=np.load('itstep.npy')
p2d=np.load('p_averaged.npy')/itstep
u2d=np.load('u_averaged.npy')/itstep
v2d=np.load('v_averaged.npy')/itstep
w2d=np.load('w_averaged.npy')/itstep
k2d=np.load('k_averaged.npy')/itstep
vis2d=np.load('vis_averaged.npy')/itstep
eps2d=np.load('eps_averaged.npy')/itstep
uu2d=np.load('uu_stress.npy')/itstep
vv2d=np.load('vv_stress.npy')/itstep
ww2d=np.load('ww_stress.npy')/itstep
uv2d=np.load('uv_stress.npy')/itstep
fk2d=np.load('fk_averaged.npy')/itstep
om2d=np.load('om_averaged.npy')/itstep

uu2d=uu2d-u2d**2
vv2d=vv2d-v2d**2
uv2d=uv2d-u2d*v2d

ustar=(viscos*u2d[:,0]/yp2d[:,0])**0.5
yplus2d=np.ones((ni,nj))
for i in range(0,ni):
   yplus2d[i,:]=ustar[i]*yp2d[i,:]/viscos

cf=ustar**2/np.max(u2d[:,]**2)/0.5

kres_2d=0.5*(uu2d+vv2d+ww2d)


itstep_diss=np.load('itstep_dissipation.npy')
print('itstep,itstep_diss',itstep,itstep_diss)
eps2d= np.load('diss_visc_mean.npy')/itstep_diss



# compute geometric quantities
areaw,areawx,areawy,areas,areasx,areasy,vol,fx,fy = init(x2d,y2d,xp2d,yp2d)

flowin=np.trapz(u2d[0,:],yp2d[0,:])
# 0.9561458981023871


# compute face value of U and V
u2d_face_w,u2d_face_s=compute_face_phi_D_or_N(u2d,fx,fy,ni,nj,'d')
v2d_face_w,v2d_face_s=compute_face_phi_D_or_N(v2d,fx,fy,ni,nj,'d')
p2d_face_w,p2d_face_s=compute_face_phi_D_or_N(p2d,fx,fy,ni,nj,'n')
k2d_face_w,k2d_face_s=compute_face_phi_D_or_N(k2d,fx,fy,ni,nj,'d')
uv2d_face_w,uv2d_face_s=compute_face_phi_D_or_N(uv2d,fx,fy,ni,nj,'d')

# x derivatives
dudx=dphidx(u2d_face_w,u2d_face_s,areawx,areasx,vol)
dvdx=dphidx(v2d_face_w,v2d_face_s,areawx,areasx,vol)
dpdx=dphidx(p2d_face_w,p2d_face_s,areawx,areasx,vol)
dkdx=dphidx(k2d_face_w,k2d_face_s,areawx,areasx,vol)
duvdx=dphidx(uv2d_face_w,uv2d_face_s,areawx,areasx,vol)

# y derivatives
dudy=dphidy(u2d_face_w,u2d_face_s,areawy,areasy,vol)
dvdy=dphidy(v2d_face_w,v2d_face_s,areawy,areasy,vol)
dpdy=dphidy(p2d_face_w,p2d_face_s,areawy,areasy,vol)
dkdy=dphidy(k2d_face_w,k2d_face_s,areawy,areasy,vol)
duvdy=dphidy(uv2d_face_w,uv2d_face_s,areawy,areasy,vol)



############################ k eq.
# visc. diff 
dkdy_face_w,dkdy_face_s=compute_face_phi_D_or_N(dkdy,fx,fy,ni,nj,'n')
d2kdy2=dphidy(dkdy_face_w,dkdy_face_s,areawy,areasy,vol)
visc_diff=viscos*d2kdy2

# convection
d2kdy2=dphidy(dkdy_face_w,dkdy_face_s,areawy,areasy,vol)
convx=-u2d*dkdx
convy=-v2d*dkdy
conv=convx+convy

# production
pk=-uu2d*dudx-uv2d*(dudy+dvdy)-vv2d*dvdy

#************
# plot balance(k)
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.01
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(visc_diff[i,:],yp2d[i,:],'r-',label='visc. diff')
ax1.plot(convx[i,:],yp2d[i,:],'b--',label='conv')
ax1.plot(pk[i,:],yp2d[i,:],'r--',label='prod')
ax1.plot(-eps2d[i,:],yp2d[i,:],'g-',label=r'$-\varepsilon_{DNS}$')
M=3
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.axis([-100,100,y2d[i,0],0.5])
plt.xlabel('terms in $k$ eq.')
plt.ylabel('y/H')
plt.savefig('k-balance-python.png')

############################ uv eq.
# visc. diff 
duvdy_face_w,duvdy_face_s=compute_face_phi_D_or_N(duvdy,fx,fy,ni,nj,'n')
d2uvdy2=dphidy(duvdy_face_w,duvdy_face_s,areawy,areasy,vol)
visc_diff=viscos*d2uvdy2

# convection
d2uvdy2=dphidy(duvdy_face_w,duvdy_face_s,areawy,areasy,vol)
convx=-u2d*duvdx
convy=-v2d*duvdy
conv=convx+convy

# production P_ij= -v_iv_k*dV_j/dx_k  -v_jv_k*dV_i/dx_k 
# P_12 = -v_1v_1*dV_2/dx_1 -v_1v_2*dV_2/dx_2 -v_2v_1*dV_1/dx_1 -v_2v_2*dV_1/dx_2 
puv=-uu2d*dvdy-uv2d*dvdy-uv2d*dudx-vv2d*dudy

#************
# plot ddy(vis*dkdy)
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.01
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(visc_diff[i,:],yp2d[i,:],'r-',label='visc. diff')
ax1.plot(convx[i,:],yp2d[i,:],'b--',label='conv')
ax1.plot(puv[i,:],yp2d[i,:],'r--',label='prod')
M=3
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.axis([-100,100,y2d[i,0],0.5])
plt.xlabel('terms in $\overline{u^\prime v^\prime }$ eq.')
plt.ylabel('y/H')
plt.ylabel('y/H')
plt.savefig('uv-balance-python.png')

# chech realizable
s11=dudx
s12=0.5*(dudy+dvdy)
s22=dvdy
s=(s11**2+2*s12**2+s22**2)**0.5
vis_limit = (2*s)**0.3333


################################ vector plot
fig2 = plt.figure()
plt.subplots_adjust(left=0.20,top=0.80,bottom=0.20)
k=6# plot every forth vector
ss=3.2 #vector length
plt.quiver(xp2d[::k,::k],yp2d[::k,::k],u2d[::k,::k],v2d[::k,::k],width=0.01)
plt.xlabel("$x$")
plt.ylabel("$y$")
plt.title("vector plot")
plt.savefig('vect_python.png')

################################ contour plot
fig2 = plt.figure()
plt.subplots_adjust(left=0.20,top=0.80,bottom=0.20)
plt.pcolormesh(xp2d,yp2d,dudy, vmin=-5,vmax=5,cmap=plt.get_cmap('hot'),shading='gouraud')
plt.colorbar()
plt.xlabel("$x$")
plt.ylabel("$y$")
plt.title(r"the gradient $\partial \bar{v}_1/\partial x_2$")
plt.savefig('dudy.png')


#************
# plot uv
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv2d[i,:],yp2d[i,:],'b-',label='x='+str(xx))
xx=2.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv2d[i,:],yp2d[i,:],'r-',label='x='+str(xx))
M = 2 # use only two major xticks
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.xlabel('$\overline{u^\prime v^\prime}$')
plt.ylabel('y/H')
plt.savefig('uv_python.png')



#************
# plot u
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(u2d[i,:],yp2d[i,:],label='x='+str(xx))
xx=1.0
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(u2d[i,:],yp2d[i,:],label='x='+str(xx))
xx=2.5
i = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(u2d[i,:],yp2d[i,:],label='x='+str(xx))
M = 2 # use only two major xticks
xticks = ticker.MaxNLocator(M)
ax1.xaxis.set_major_locator(xticks)
plt.legend(loc='best',prop=dict(size=13))
#ax1.yaxis.set_label_coords(-0.095, 0.6)
plt.xlabel('$\overline{U}$')
plt.ylabel('y/H')
plt.savefig('u_python.png')


