
def modify_init(u3d,v3d,w3d,k3d,om3d,eps3d,vis3d):

   name='../channel-550-DNS-600-150-300-half-channel/'

   file_name=str(name)+'inlet-files/uvw_1.npy'
   print('file: ',file_name)
   data = xp.load(file_name)
   u_bc_west = data[:,:,0]
   v_bc_west = data[:,:,1]
   w_bc_west = data[:,:,2]

   print('w_bc_west.shape',w_bc_west.shape)

 #set inlet field in entre domain
   u3d=xp.repeat(u_bc_west[None,:,:], repeats=ni, axis=0)
   v3d=xp.repeat(v_bc_west[None,:,:], repeats=ni, axis=0)
   w3d=xp.repeat(w_bc_west[None,:,:], repeats=ni, axis=0)

   return u3d,v3d,w3d,k3d,om3d,eps3d,vis3d,dist3d

def modify_conv(convw,convs,convl):

   convs[:,0,:]=0
   convs[:,-1,:]=0

   return convw,convs,convl

def modify_u(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*u_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*u_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_v(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*v_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*v_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_w(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*w_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*w_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_k(su3d,sp3d,gen):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*k_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*k_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   comm_term=xp.zeros((ni,nj,nk))

   return su3d,sp3d,comm_term


def modify_eps(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*eps_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*eps_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound
   
   name='/scratch/lada/cartesian/channel-550-DNS-600-150-300-half-channel/'
   file_name=str(name)+'inlet-files/uvw_1.npy'
   print('file: ',file_name)
   data = xp.load(file_name)
   u_bc_west = data[:,:,0]
   v_bc_west = data[:,:,1]
   w_bc_west = data[:,:,2]
   k_bc_west = data[:,:,3]
   eps_bc_west = data[:,:,4]

   print('u_bc_west.shape',u_bc_west.shape)

# set inlet field in entre domain
   u3d=xp.repeat(u_bc_west[None,:,:], repeats=ni, axis=0)
   v3d=xp.repeat(v_bc_west[None,:,:], repeats=ni, axis=0)
   w3d=xp.repeat(w_bc_west[None,:,:], repeats=ni, axis=0)
   k3d=xp.repeat(k_bc_west[None,:,:], repeats=ni, axis=0)
   eps3d=xp.repeat(eps_bc_west[None,:,:], repeats=ni, axis=0)


   vis=cmu*k3d**2/eps3d+viscos

   return u3d,v3d,w3d,k3d,om3d,eps3d,vis3d,dist3d

def modify_inlet():

   global two_corr

   name='/scratch/lada/cartesian/channel-550-DNS-600-150-300-half-channel/'
   counter=itstep-int(itstep/15900)*15900
   file_name=str(name)+'inlet-files/uvw_' + str(counter+1) + '.npy'
   print('counter,file: ',counter,file_name)
   data = xp.load(file_name)
   u_bc_west = data[:,:,0]
   v_bc_west = data[:,:,1]
   w_bc_west = data[:,:,2]

   if itstep == 0:
      two_corr=xp.zeros(2*nk-1)

# compute two-point corr in node 10
   if itstep > itstep_start:
      two_corr=two_corr+xp.correlate(w_bc_west[10,:],w_bc_west[10,:],'full')

# compute average
   if itstep % 100 == 0:
      xp.save('two_corr_inlet',two_corr)

   return u_bc_west,v_bc_west,w_bc_west,k_bc_west,eps_bc_west,om_bc_west,u3d_face_w,convw

def modify_conv(convw,convs,convl):

   convs[:,0,:]=0
   convs[:,-1,:]=0

   return convw,convs,convl

def modify_u(su3d,sp3d):

   global count_step
   global itstep_diss_counter, tau11_mean,tau12_mean,tau13_mean,tau22_mean,diss_turb_mean,diss_visc_mean
   if itstep == 0 and iter == 0:
      print('modify_u  called')
      tau11_mean= xp.zeros((ni,nj))
      tau12_mean= xp.zeros((ni,nj))
      tau13_mean= xp.zeros((ni,nj))
      tau22_mean= xp.zeros((ni,nj))
      diss_turb_mean=xp.zeros((ni,nj))
      diss_visc_mean=xp.zeros((ni,nj))
      itstep_diss_counter = 0
      count_step = 0

   if itstep%10 == 0 or itstep == 0:

     if itstep >= itstep_start and iter == 0:

      itstep_diss_counter = itstep_diss_counter +1

      u3d_face_w,u3d_face_s,u3d_face_l=\
           compute_face_phi(u3d,u_bc_west,u_bc_east,u_bc_south,u_bc_north,u_bc_low,u_bc_high,\
           u_bc_west_type,u_bc_east_type,u_bc_south_type,u_bc_north_type,u_bc_low_type,u_bc_high_type)
      v3d_face_w,v3d_face_s,v3d_face_l=\
           compute_face_phi(v3d,v_bc_west,v_bc_east,v_bc_south,v_bc_north,v_bc_low,v_bc_high,\
           v_bc_west_type,v_bc_east_type,v_bc_south_type,v_bc_north_type,v_bc_low_type,v_bc_high_type)
      w3d_face_w,w3d_face_s,w3d_face_l=\
           compute_face_phi(w3d,w_bc_west,w_bc_east,w_bc_south,w_bc_north,w_bc_low,w_bc_high,\
           w_bc_west_type,w_bc_east_type,w_bc_south_type,w_bc_north_type,w_bc_low_type,w_bc_high_type)

      dudx=dphidx(u3d_face_w,u3d_face_s)
      dvdx=dphidx(v3d_face_w,v3d_face_s)
      dwdx=dphidx(w3d_face_w,w3d_face_s)

      dudy=dphidy(u3d_face_w,u3d_face_s)
      dvdy=dphidy(v3d_face_w,v3d_face_s)
      dwdy=dphidy(w3d_face_w,w3d_face_s)

      dudz=dphidz(u3d_face_l)
      dvdz=dphidz(v3d_face_l)
      dwdz=dphidz(w3d_face_l)

      s11=dudx
      s12=0.5*(dudy+dvdx)
      s13=0.5*(dudz+dwdx)

      s21=s12
      s22=dvdy
      s23=0.5*(dvdz+dwdy)

      s31=s13
      s32=s23
      s33=dwdz

      vist=vis3d
# Eq. 15 in Transport Equattions: diss_sgs =<2*(vist*sij*sij'- <vist><sij>*sij'> = 
#                                          =<2*(vist*sij*sij'> = 
#                                          =<2*(vist*sij*(sij-<sij>)> = 
#                                          =2*(<vist*sij*sij>-<vist*sij><sij>)
#                                          =-(<tauij*sij>-<tauij><sij>)
#                                            
      tau11 = 2*s11*viscos
      tau22 = 2*s22*viscos
      tau33 = 2*s33*viscos
      tau12 = 2*s12*viscos
      tau21 = tau12
      tau13 = 2*s13*viscos
      tau31 = tau13
      tau23 = 2*s23*viscos
      tau32 = tau23
      tau11_mean= tau11_mean + xp.mean(tau11,axis=2)
      tau12_mean= tau12_mean + xp.mean(tau12,axis=2)
      tau13_mean= tau13_mean + xp.mean(tau13,axis=2)
      tau22_mean= tau22_mean + xp.mean(tau22,axis=2)

      diss=tau11*s11+tau12*s12+tau13*s13\
          +tau21*s21+tau22*s22+tau23*s23\
          +tau31*s31+tau32*s32+tau33*s33


      diss_visc_mean=diss_visc_mean + xp.mean(diss,axis=2)

      xp.save('itstep_dissipation',itstep_diss_counter)
      xp.save('diss_visc_mean', diss_visc_mean)
      xp.save('tau11_mean', tau11_mean)
      xp.save('tau12_mean', tau12_mean)
      xp.save('tau22_mean', tau22_mean)

      print('itstep_dissipation',itstep_diss_counter)


   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*u_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*u_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_v(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*v_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*v_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_w(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*w_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*w_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_k(su3d,sp3d,gen):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*k_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*k_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   comm_term=xp.zeros((ni,nj,nk))

   return su3d,sp3d,comm_term


def modify_eps(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*eps_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*eps_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_om(su3d,sp3d,comm_term):

   return su3d,sp3d

def modify_outlet(convw):

# inlet
   flow_in=xp.sum(convw[0,:,:])
#  flow_out=xp.sum(convw[-1,:,:])
   flow_out=xp.sum(convw[-2,:])
   area_out=xp.sum(areaw[-1,:])


   uinc=(flow_in-flow_out)/area_out
   ares=areaw[-1,:,:]
#  convw[-1,:]=convw[-1,:]+uinc*ares
   convw[-1,:]=convw[-2,:]+uinc*ares

   print('xp.min(convw[-1,:,:])',xp.min(convw[-1,:,:]))

   convw[-1,:,:]= xp.maximum(convw[-1,:,:],1e-10)

   print('area_out',area_out)

   flow_out_new=xp.sum(convw[-1,:,:])

   print('flow_in',flow_in,'flow_out',flow_out,'area_out',area_out,'flow_out_new',flow_out_new,'uinc:',uinc)

   return convw,u_bc_east



def fix_omega():

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d



def modify_fk(fk3d):

   global l_dist,l_max,l_iddes,rt,fmu,l_c,f_t,f_l,f_e1,l_u,l_tilde,f_d,f_e,psi,f_b,f_dt,r_dt,r_dl,denom,s2,fk3d_org

   l_dist=0.15*dist3d
   l_max=0.15*delta_max
   dy=xp.diff(y2d[1:,:],axis=1)
# make it 3d
   dy=xp.repeat(dy[:,:,None],repeats=nk,axis=2)
 
   l_temp=xp.maximum(l_dist,l_max)
   l_temp=xp.maximum(l_temp,dy)
   l_iddes=xp.minimum(l_temp,delta_max)
#  l_iddes=xp.minimum(xp.maximum(l_dist,l_max,dy),delta_max)

   ueps=(eps3d*viscos)**0.25
   ystar=ueps*dist3d/viscos
   rt=k3d**2/eps3d/viscos
   fdampf2=((1.-xp.exp(-ystar/3.1))**2)*(1.-0.3*xp.exp(-(rt/6.5)**2))
   fmu=((1.-xp.exp(-ystar/14.))**2)*(1.+5./rt**0.75*xp.exp(-(rt/200.)**2))
   fmu=xp.minimum(fmu,1.)

   psi=xp.minimum(10,(fdampf2*fmu)**(-0.75))

   l_c=psi*cdes*l_iddes  #eq. 9

   vist=vis3d-viscos
   s2=gen
   denom=kappa**2*dist3d**2*s2**0.5
#         s2= (dudx**2+dudy**2+dudz**2+
#    .            dvdx**2+dvdy**2+dvdz**2+
#    .            dwdx**2+dwdy**2+dwdz**2)

   r_dt=vist/denom  #eq. 22
   r_dl=viscos/denom  #eq. 23

   f_t=xp.tanh((c_t**2*r_dt)**3)
   f_l=xp.tanh((c_l**2*r_dl)**10)

   f_e2=1.-xp.maximum(f_t,f_l) #eq. 19

   alpha=0.25-dist3d/delta_max

   f_e1=xp.where(alpha <= 0,2*xp.exp(-9*alpha**2),2*xp.exp(-11.09*alpha**2))

   f_b=  xp.minimum(2.*xp.exp(-9*alpha**2),1.)

   f_dt=1.-xp.tanh((8.*r_dt)**3)

   f_e=xp.maximum(f_e1-1.,0.)*psi*f_e2

   f_d=xp.maximum((1.-f_dt),f_b)

   l_u=k3d**1.5/eps3d

   l_tilde=f_d*l_u+(1-f_d)*l_c

   psi_small=l_u/l_tilde

   term1=xp.maximum((c_eps_2-c_eps_1*psi_small)/(c_eps_2-c_eps_1),0)
   fk3d=xp.minimum(term1,1) #IDD-PITM


   return fk3d

def fix_k():

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def fix_eps():

# south wall
   aw3d[:,0,:]=0
   ae3d[:,0,:]=0
   as3d[:,0,:]=0
   an3d[:,0,:]=0
   al3d[:,0,:]=0
   ah3d[:,0,:]=0
   ap_max=xp.max(ap3d)
   ap3d[:,0,:]=ap_max
   su3d[:,0,:]=ap_max*2*viscos*k3d[:,0,:]/dist3d[:,0,:]**2

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def modify_vis(vis3d):

   return vis3d

