
def modify_init(u3d,v3d,w3d,k3d,om3d,eps3d,vis3d):
   
   data=np.loadtxt('y_u_k_om_uv_395_DNS-python.txt')

   u_rans=data[0:nj,1]
# make it 2D
   u_rans=np.repeat(u_rans[:,None], repeats=nk, axis=1)

# set inlet field in enitre domain
   u3d=np.repeat(u_rans[None,:,:], repeats=ni, axis=0)

   return u3d,v3d,w3d,k3d,om3d,eps3d,vis3d,dist3d

def modify_inlet():

   global y_rans,y_rans,u_rans,v_rans,k_rans,om_rans,uv_rans,zp,a_synt,b_synt,usynt_inlet,vsynt_inlet,wsynt_inlet,\
          uu_synt,vv_synt,ww_synt,uv_synt,two_corr,u_time,w_synt,k_bc_west,eps_bc_west
  
   global usynt,vsynt,wsynt

   if itstep == 0:
      two_corr=np.zeros(2*nk-1)
      u_time=np.zeros(ntstep)
      y_u_k_om=np.loadtxt('y_u_k_om_uv_395_DNS-python.txt')
      y_rans=y_u_k_om[0:nj,0]
      u_rans=y_u_k_om[0:nj,1]
# make it 2D
      u_rans=np.repeat(u_rans[:,None], repeats=nk, axis=1)

      uv_rans=np.abs(y_u_k_om[0:nj,4])

# z grid
      zp = np.linspace(0, zmax, nk)
      usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
# correct usynt so that it is = 0 (easier to converge the p solver)
      uinc=np.sum(usynt*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
      usynt=usynt-uinc
      usynt_inlet=usynt
      vsynt_inlet=vsynt
      wsynt_inlet=wsynt
      uin=np.sum(u_rans*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
# tturb from ustar=1
      tturb=L_t_synt/1
      a_synt=np.exp(-dt[itstep]/tturb)
      b_synt=(1.-a_synt**2)**0.5
      print('uin,a_synt,b_synt,tturb',uin,a_synt,b_synt,tturb)
      uu_synt=np.zeros(nj)
      vv_synt=np.zeros(nj)
      ww_synt=np.zeros(nj)
      uv_synt=np.zeros(nj)

   usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
# correct usynt so that it is = 0 (easier to converge the p solver)
   uinc=np.sum(usynt*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
   usynt=usynt-uinc
   usynt_inlet=a_synt*usynt_inlet+b_synt*usynt
   vsynt_inlet=a_synt*vsynt_inlet+b_synt*vsynt
   wsynt_inlet=a_synt*wsynt_inlet+b_synt*wsynt
   u_bc_west=u_rans+usynt_inlet
   v_bc_west=vsynt_inlet
   w_bc_west=wsynt_inlet

   uu_synt=uu_synt+np.mean(usynt**2,axis=1)
   vv_synt=vv_synt+np.mean(vsynt**2,axis=1)
   ww_synt=ww_synt+np.mean(wsynt**2,axis=1)
   uv_synt=uv_synt+np.mean(usynt*vsynt,axis=1)

# update face velocity and convw at inlet
#  u3d_face_w[0,:,:]=u_bc_west
#  convw[0,:,:]=-u_bc_west*areawx[0,:,:]-v_bc_west*areawy[0,:,:]

# compute two-point corr in node 10
   two_corr=two_corr+np.correlate(w_bc_west[10,:],w_bc_west[10,:],'full')

# compute average
   if itstep % 100 == 0:
      np.save('two_corr_inlet',two_corr)
      np.save('u_time',u_time)
      np.save('uu_synt',uu_synt/(itstep+1))
      np.save('uv_synt',uv_synt/(itstep+1))

   return u_bc_west,v_bc_west,w_bc_west,k_bc_west,eps_bc_west,om_bc_west,u3d_face_w,convw

def modify_conv(convw,convs,convl):

   convs[:,0,:]=0
   convs[:,-1,:]=0

   return convw,convs,convl

def modify_u(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+np.maximum(convw[0,:,:],0)*u_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-np.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*u_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound


   return su3d,sp3d


def modify_v(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+np.maximum(convw[0,:,:],0)*v_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-np.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*v_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d


def modify_w(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+np.maximum(convw[0,:,:],0)*w_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-np.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*w_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d


def modify_k(su3d,sp3d,gen):

   return su3d,sp3d,comm_term


def modify_eps(su3d,sp3d):

   return su3d,sp3d

def modify_om(su3d,sp3d,comm_term):

   return su3d,sp3d

def modify_outlet(convw):

# inlet
   flow_in=np.sum(convw[0,:,:])
   flow_out=np.sum(convw[-1,:,:])
   area_out=np.sum(areaw[-1,:,:])

   uinc=(flow_in-flow_out)/area_out
   ares=areaw[-1,:,:]
   convw[-1,:,:]=convw[-1,:,:]+uinc*ares

   print('area_out',area_out)

   flow_out_new=np.sum(convw[-1,:,:])

   print('flow_in',flow_in,'flow_out',flow_out,'area_out',area_out,'flow_out_new',flow_out_new,'uinc:',uinc)

   return convw,u_bc_east

def modify_vis(vis3d):

   return vis3d
