from scipy import sparse
import numpy as np
import sys
import time
import pyamg
from scipy.sparse import spdiags,linalg,eye

def setup_case():
   global  acrank,acrank_conv, acrank_conv_keps, acrank_conv_kom,amg_cycle, amg_cycle_phi, \
   amg_relax, amg_relax_phi, blend,cdes,c_eps,c_eps_1,c_eps_2, c_l,c_omega_1, c_omega_2, cmu,c_t, coeff_v, coeff_w,\
   c_omega_1_sst_1, c_omega_2_sst_1, c_omega_1_sst_2,c_omega_2_sst_2, \
   convergence_limit_eps, convergence_limit_k, convergence_limit_om, convergence_limit_p, convergence_limit_t, convergence_limit_u, \
   convergence_limit_v, convergence_limit_w,cr_sst, \
   cyclic_x, cyclic_z, dt, dist3d,dz, dmin_synt,embedded,eps_bc_east,eps_bc_east_type,eps_bc_north,eps_bc_north_type, eps_bc_south, \
   eps_bc_south_type, eps_bc_west, eps_bc_west_type, eps_bc_low, eps_bc_high, eps_bc_low_type,eps_bc_high_type,eps_min,fkmin_limit,\
   fx, fy,fz,imon,itstep_stats, save_average_z, i_s_fair, k_s_fair, i_fair,i_fair_embedd, \
   itstep_save,itstep_start,jl0,jmirror_synt,jmon,kappa,k_bc_east,k_bc_east_type,k_bc_north,k_bc_north_type,k_bc_south,\
   k_bc_south_type,k_bc_west,k_bc_west_type,k_bc_low,k_bc_high,k_bc_low_type,k_bc_high_type,keps,keps_des,k_eq_les,kmon,kom, k_min,\
   kom_peng,kom_des,launder,L_t_synt,\
   maxit,min_iter, norm_order, ni,nj,nk,nmodes_synt,nsweep_keps,nsweep_kom, nsweep_t, \
   nsweep_vel, ntstep, om_bc_east, om_bc_east_type, om_bc_north, om_bc_north_type, \
   om_bc_south, om_bc_south_type, om_bc_west, om_bc_west_type, om_bc_low,om_bc_high, om_bc_low_type, om_bc_high_type, om_min,\
   p_bc_east, p_bc_east_type, p_bc_north, p_bc_north_type, p_bc_south, p_bc_south_type, p_bc_west, p_bc_west_type, p_bc_low,\
   p_bc_high, p_bc_low_type, p_bc_high_type,pans, prand_lam,prand_eps,\
   prand_k_sst_1, prand_k_sst_2, prand_omega_sst_1, prand_omega_sst_2, prand_k,prand_omega,prand_t, \
   resnorm_p,resnorm_vel,resnorm_t,restart,save,save_vtk_movie,scheme,scheme_turb,scheme_t, smag,solver_vel, solver_p, \
   solver_t,t_bc_east, t_bc_east_type, t_bc_north, t_bc_north_type, t_bc_sotth, t_bc_south_type, t_bc_west, t_bc_west_type, \
   t_bc_low,t_bc_high, t_bc_low_type, t_bc_high_type, temp, \
   solver_turb,solverx,sormax, s2,sst,sst_sst_uv_limit,u_bc_east, u_bc_east_type, u_bc_north, u_bc_north_type, \
   u_bc_south, u_bc_south_type, u_bc_west, u_bc_west_type, \
   u_bc_low,u_bc_high, u_bc_low_type, u_bc_high_type, urfvis, v_bc_east, v_bc_east_type, v_bc_north, v_bc_north_type, v_bc_south, \
   v_bc_south_type,v_bc_west,v_bc_west_type,v_bc_low,v_bc_high,v_bc_low_type,v_bc_high_type,viscos, vol,vtk,vtk_save,\
   vtk_file_name,w_bc_east,w_bc_east_type,w_bc_north,w_bc_north_type,\
   w_bc_south, w_bc_south_type, w_bc_west, w_bc_west_type, w_bc_low, w_bc_high, w_bc_low_type, w_bc_high_type,\
   wale, x_embed, x2d, xp2d, y2d, yp2d, z,zp,zmax

   import numpy as np
   import sys

# N.B. All variables that are set in this module must be included in the 'return' statement at the last line

########### section 1 choice of differencing scheme ###########
   scheme='c'  #hybrid first 2000 timesteps hybrid
   scheme='h'  #hybrid
   scheme_turb='u'  #hybrid upwind-central 
   acrank=1.0  # for pressure gradient
   acrank_conv=0.5  # for convection-diffusion
   acrank_conv_kom=1  # for convection-diffusion
   acrank_conv_keps=1  # for convection-diffusion
#  scheme_turb='h'  #hybrid upwind-central 


########### section 2 turbulence models ###########
   cmu=0.09
   pans = False
   keps = True
   kom_des = False
   keps_des = False
   kom = False
   wale = False
   smag = False
   c_eps_1=1.5
   c_eps_2=1.9
   cdes=0.67
   kappa=0.4
   c_t=1.87
   c_l=5
   cmu=0.09
   c_omega_1= 5./9.
   c_omega_2=3./40.
   prand_omega=2.0
   prand_eps=1.4
   prand_k=1.4
   jl0=0

   if keps:
      c_eps_1=1.5
      c_eps_2=1.9
      prand_k=1.4
      prand_eps=1.4

   if pans:
      prand_k=-1.4 # will be multiplied by fk3d in coeff()
      prand_eps=-1.4 # will be multiplied by fk3d in coeff()

   if kom or kom_des:
      prand_k=2.0
   if smag:
      cmu=0.1

########### section 3 restart/save ###########
   restart = False
   save = True

########### section 4 fluid properties ###########
   re =9.36e+5
   viscos =1./re


########### section 5 relaxation factors ###########
   urfvis=0.5

########### section 6 number of iteration and convergence criterira ###########
   maxit=5
   min_iter=1
   sormax=1e-3

   solver_vel='lgmres'
   solver_turb='lgmres'
   solver_turb='tdma'
   solver_vel='tdma'
   amg_relax='cg'
   amg_cycle='V'
   amg_relax='fgmres'
   amg_cycle='F'
   amg_relax='default'

#  amg_relax='cgnr'
#  amg_relax='cgne'
#  amg_relax='bicgstab'
   nsweep_vel=2
   nsweep_keps=2
   nsweep_kom=50
   convergence_limit_u=1e-5
   convergence_limit_v=1e-5
   convergence_limit_w=1e-5
   convergence_limit_eps=1e-5
   convergence_limit_k=1e-5
   convergence_limit_om=1e-6
   convergence_limit_p=5e-3

########### section 7 all variables are printed during the iteration at node ###########
   imon=0
   jmon=0
   kmon=0

########### section 8 time-averaging ###########
   ntstep=2000
   uin=1
   dt=0.001*xp.ones(ntstep)
   itstep_start=ntstep-100
   itstep_save=2000  # save every itstep_save timestep
   itstep_stats=1 # time average every itstep_stats timestep
   vtk=False


########### section 9 residual scaling parameters ###########
   resnorm_p=uin*zmax*y2d[1,-1]
   resnorm_vel=uin**2*zmax*y2d[1,-1]


########### Section 10 boundary conditions ###########
   cyclic_x = False
   cyclic_z = False

# synthetic inlet fluct
   L_t_synt=0.2*0.007
   nmodes_synt=600
   jmirror_synt=0  # mirror vsynt at node jmirror; jmirror=0 means no mirroring
   dmin_synt=dz

# boundary conditions for u
   u_bc_west=xp.zeros((nj,nk))
   u_bc_east=xp.zeros((nj,nk))
   u_bc_south=xp.zeros((ni,nk))
   u_bc_north=xp.zeros((ni,nk))
   u_bc_low=xp.zeros((ni,nj))
   u_bc_high=xp.zeros((ni,nj))

   u_bc_west_type='d' 
   u_bc_east_type='n' 
   u_bc_south_type='d'
   u_bc_north_type='n'
   u_bc_low_type='n'
   u_bc_high_type='n'

# boundary conditions for v
   v_bc_west=xp.zeros((nj,nk))
   v_bc_east=xp.zeros((nj,nk))
   v_bc_south=xp.zeros((ni,nk))
   v_bc_north=xp.zeros((ni,nk))
   v_bc_low=xp.zeros((ni,nj))
   v_bc_high=xp.zeros((ni,nj))

   v_bc_west_type='d' 
   v_bc_east_type='n' 
   v_bc_south_type='d'
   v_bc_north_type='d'
   v_bc_low_type='n'
   v_bc_high_type='n'

# boundary conditions for w
   w_bc_west=xp.zeros((nj,nk))
   w_bc_east=xp.zeros((nj,nk))
   w_bc_south=xp.zeros((ni,nk))
   w_bc_north=xp.zeros((ni,nk))
   w_bc_high=xp.zeros((ni,nj))
   w_bc_low=xp.zeros((ni,nj))

   w_bc_west_type='d' 
   w_bc_east_type='n' 
   w_bc_south_type='d'
   w_bc_north_type='n'
   w_bc_high_type='d'
   w_bc_low_type='d'

# boundary conditions for p
   p_bc_west=xp.zeros((nj,nk))
   p_bc_east=xp.zeros((nj,nk))
   p_bc_south=xp.zeros((ni,nk))
   p_bc_north=xp.zeros((ni,nk))
   p_bc_low=xp.zeros((ni,nj))
   p_bc_high=xp.zeros((ni,nj))

   p_bc_west_type='n'
   p_bc_east_type='n'
   p_bc_south_type='n'
   p_bc_north_type='n'
   p_bc_high_type='n'
   p_bc_low_type='n'

# boundary conditions for k
   k_bc_west=xp.zeros((nj,nk))
   k_bc_east=xp.zeros((nj,nk))
   k_bc_south=xp.zeros((ni,nk))
   k_bc_north=xp.zeros((ni,nk))
   k_bc_low=xp.zeros((ni,nj))
   k_bc_high=xp.zeros((ni,nj))

   k_bc_west_type='d'
   k_bc_east_type='n'
   k_bc_south_type='d'
   k_bc_north_type='n'
   k_bc_low_type='n'
   k_bc_high_type='n'

# boundary conditions for eps
   eps_bc_west=xp.zeros((nj,nk))
   eps_bc_east=xp.zeros((nj,nk))
   eps_bc_south=xp.zeros((ni,nk))
   eps_bc_north=xp.zeros((ni,nk))
   eps_bc_high=xp.zeros((ni,nj))
   eps_bc_low=xp.zeros((ni,nj))

   eps_bc_west_type='d'
   eps_bc_east_type='n'
   eps_bc_south_type='d' 
   eps_bc_north_type='n' 
   eps_bc_high_type='n' 
   eps_bc_low_type='n' 

# boundary conditions for omega
   om_bc_west=xp.zeros((nj,nk))
   om_bc_east=xp.zeros((nj,nk))
   om_bc_south=xp.zeros((ni,nk))
   om_bc_north=xp.zeros((ni,nk))

   xwall_s=0.5*(x2d[0:-1,0]+x2d[1:,0])
   ywall_s=0.5*(y2d[0:-1,0]+y2d[1:,0])
   dist2_s=(yp2d[:,0]-ywall_s)**2+(xp2d[:,0]-xwall_s)**2
   om_bc_south=6*viscos/0.075/dist2_s

# make it 2D
   om_bc_south=xp.repeat(om_bc_south[:,None], repeats=nk, axis=1)

   om_bc_west_type='d'
   om_bc_east_type='n'
   om_bc_south_type='d'
   om_bc_north_type='n'
   om_bc_high_type='n' 
   om_bc_low_type='n' 

   return 



def modify_init(u3d,v3d,w3d,k3d,om3d,eps3d,vis3d):
   
   global dist3d
# re-define dist3d = distance frok south wall
   ywall_s=0.5*(y2d[0:-1,0]+y2d[1:,0])
   dist_s=yp2d-ywall_s[:,None]
   dist=dist_s
   dist3d=xp.repeat(dist[:,:,None], repeats=nk, axis=2)

   data=xp.loadtxt('y_u_v_k_om_uv_hump.dat')

   y_rans_in=data[:,0]
   u_rans_in=data[:,1]
   v_rans_in=data[:,2]
   k_rans_in=data[:,3]
   om_rans_in=data[:,4]
   uv_rans_in=data[:,5]
   y_rans=yp2d[0,:]
   eps_rans_in=0.09*k_rans_in*om_rans_in

   u_rans=xp.interp(y_rans, y_rans_in, u_rans_in)
# make it 2D
   u_rans=xp.repeat(u_rans[:,None], repeats=nk, axis=1)

   k_rans=xp.interp(y_rans, y_rans_in, k_rans_in)
# make it 2D
   k_rans=xp.repeat(k_rans[:,None], repeats=nk, axis=1)

   eps_rans=xp.interp(y_rans, y_rans_in, eps_rans_in)
# make it 2D
   eps_rans=xp.repeat(eps_rans[:,None], repeats=nk, axis=1)

# set inlet field in entre domain
   u3d=xp.repeat(u_rans[None,:,:], repeats=ni, axis=0)
   k3d=xp.repeat(k_rans[None,:,:], repeats=ni, axis=0)
   eps3d=xp.repeat(eps_rans[None,:,:], repeats=ni, axis=0)

   vis3d=0.09*k3d**2/eps3d+viscos

   return u3d,v3d,w3d,k3d,om3d,eps3d,vis3d,dist3d

def modify_inlet():

   global y_rans,y_rans,u_rans,v_rans,k_rans,eps_rans,uv_rans,zp,a_synt,b_synt,usynt_inlet,vsynt_inlet,wsynt_inlet,\
          uu_synt,vv_synt,ww_synt,uv_synt,two_corr,u_time,uv_aver,w_synt,k_bc_west,eps_bc_west,om_bc_west,u_bc_west
  
   global usynt,vsynt,wsynt

   if itstep == 0:
      y_u_k_om=xp.loadtxt('y_u_v_k_om_uv_hump.dat')
      y_rans_in=y_u_k_om[:,0]
      u_rans_in=y_u_k_om[:,1]
      v_rans_in=y_u_k_om[:,2]
      k_rans_in=y_u_k_om[:,3]
      om_rans_in=y_u_k_om[:,4]
      uv_rans_in=y_u_k_om[:,5]
      eps_rans_in=0.09*k_rans_in*om_rans_in

      y_rans=yp2d[0,:]
      u_rans=xp.interp(y_rans, y_rans_in, u_rans_in)
# make it 2D
      u_rans=xp.repeat(u_rans[:,None], repeats=nk, axis=1)

      k_rans=xp.interp(y_rans, y_rans_in, k_rans_in)
# make it 2D
      k_rans=xp.repeat(k_rans[:,None], repeats=nk, axis=1)
      eps_rans=xp.interp(y_rans, y_rans_in, eps_rans_in)
# make it 2D
      eps_rans=xp.repeat(eps_rans[:,None], repeats=nk, axis=1)

      uv_rans=xp.interp(y_rans, y_rans_in, uv_rans_in)

      k_bc_west=k_rans
      eps_bc_west=eps_rans
      u_bc_west=u_rans



   return u_bc_west,v_bc_west,w_bc_west,k_bc_west,eps_bc_west,om_bc_west,u3d_face_w,convw

def modify_conv(convw,convs,convl):

   convs[:,0,:]=0
   convs[:,-1,:]=0

   return convw,convs,convl

def modify_u(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*u_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-xp.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*u_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound



   return su3d,sp3d


def modify_v(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*v_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-xp.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*v_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound



   return su3d,sp3d


def modify_w(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*w_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-xp.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*w_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound



   return su3d,sp3d


def modify_k(su3d,sp3d,gen):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*k_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-xp.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*k_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   comm_term=xp.zeros((nj,nk))

   return su3d,sp3d,comm_term

def modify_eps(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*eps_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*eps_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_om(su3d,sp3d,comm_term):

   return su3d,sp3d

def fix_k():

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def fix_omega():

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def modify_outlet(convw):

# inlet
   flow_in=xp.sum(convw[0,:,:])
   flow_out=xp.sum(convw[-1,:,:])
   area_out=xp.sum(areaw[-1,:,:])

   uinc=(flow_in-flow_out)/area_out
   ares=areaw[-1,:,:]
   convw[-1,:,:]=convw[-1,:,:]+uinc*ares

   print('area_out',area_out)

   flow_out_new=xp.sum(convw[-1,:,:])

   print('flow_in',flow_in,'flow_out',flow_out,'area_out',area_out,'flow_out_new',flow_out_new,'uinc:',uinc)

   return convw,u_bc_east

def modify_fk(fk3d):

   return fk3d

def fix_eps():

# south wall
   aw3d[:,0,:]=0
   ae3d[:,0,:]=0
   as3d[:,0,:]=0
   an3d[:,0,:]=0
   al3d[:,0,:]=0
   ah3d[:,0,:]=0
   ap_max=xp.max(ap3d)
   ap3d[:,0,:]=ap_max
   su3d[:,0,:]=ap_max*2*viscos*k3d[:,0,:]/dist3d[:,0,:]**2

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d


def modify_vis(vis3d):

   return vis3d


import numpy as np
import time,random,sys
from scipy.signal import welch, hann
import math


def synt_fluct(nmodes,it,sli,yp,zp,uv_rans,visc,jmirror,dmin_synt):
#=========================== chapter 1 ============================================

#!!!  number of modes                        = nmodes
#!!!  smallest wavenumber                    = dxmin
#!!!  ratio  of ke and kmin (in wavenumber)  = wew1fct
#!!!  turb. velocity scale                   = up
#!!!  diss. rate.                            = epsm
#!!!  kinetic viscosity                      = visc
#!!!  length scale                           = sli
#!!!  mirror vfluct at j > jmirror

   global dxmin,amp,epsm,epsm,wnr1,wew1fct,xp,yp2d_synt,zp2d_synt,xp2d_synt,nj,up
   global e,kxio,kyio,kyio,sxio,syio,syio,utn,tfunk,wnre,dkn,arg1,arg2,arg3,arg,fi,psi,teta,alfa,wnr,kx,ky,kz,wnrn,\
          r11,r12,r13,r21,r22,r23,r31,r32,r33,a11,a22,a33,wnreta,uv_synt_mean,uvmean_check,a11i,a22i,a33i,\
          xp2d_wave,yp2d_wave,zp2d_wave,uv_rans_non,uv_rans_max
   global utn,tfunk,sx,e,rk,kxi,usynt_wave,usynt1,usynt,sy,vsynt,yp2d_org,usynt_aniso,scale_2

   uv_rans=np.abs(uv_rans)
   if it == 0:

      uvmean_check=0
      uv_synt_mean=0
# anisotropix fluctuations
#     R=np.loadtxt('R.dat')
      R=np.genfromtxt("R.dat", dtype=None,comments="%")
      r11=R[0,0]
      r12=R[0,1]
      r13=R[0,2]
      r21=R[1,0]
      r22=R[1,1]
      r23=R[1,2]
      r31=R[2,0]
      r32=R[2,1]
      r33=R[2,2]

#     A=np.loadtxt('a.dat')
      A=np.genfromtxt("a.dat", dtype=None,comments="%")
      a11=A[0]
      a22=A[1]
      a33=A[2]

      amp=1.452762113
      wew1fct=2

# in log region:  k/uvmax=3.3  => up=(3.3*uvmax)**0.5
# the uv_rans profile is input and taken from a pre-cursos RANS simulation
      if np.all(uv_rans==1):
         up=1
      else:
         up=(3.3*np.max(uv_rans))**0.5

      epsm=up**3/sli
#
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#     number of  grid points in y, z
      nj=len(yp)
      nk=len(zp)

# make it 2D
      zp2d_synt=np.repeat(zp[None,:], repeats=nj, axis=0)

# make it 2D
      yp2d_synt=np.repeat(yp[:,None], repeats=nk, axis=1)


      xp=0.5
# make it 2D
      xp2d_synt=np.ones((nj,nk))*xp

      yp2d_org=yp2d_synt
# transform to principal coord. directions
      xp2d_synt=r11*xp+r21*yp2d_org+r31*zp2d_synt
      yp2d_synt=r12*xp+r22*yp2d_synt+r32*zp2d_synt
      zp2d_synt=r13*xp+r23*yp2d_synt+r33*zp2d_synt

# search min grid step
      dminy=np.min(np.diff(yp))
      dminz=np.min(np.diff(zp))
      dxmin=min(dminy,dminz)

# don't let is be smaller than dmin_synt (i.e. is user-input)
      dxmin=max(dxmin,dmin_synt)

# create a seed from time 
      np.random.seed()
# below I don't use any seed; it means that if you run a simulation twice you'll get
# the samw synthetic fluctuations
      np.random.seed(2)

# zero all arrays to zero
      wnr=np.zeros(nmodes+2)
      fi=np.zeros(nmodes+2)
      teta=np.zeros(nmodes+2)
      psi=np.zeros(nmodes+2)
      wnr=np.zeros(nmodes+2)
      kxio=np.zeros((nj,nk,nmodes+2))
      kyio=np.zeros((nj,nk,nmodes+2))
      kzio=np.zeros((nj,nk,nmodes+2))
      sxio=np.zeros((nj,nk,nmodes+2))
      syio=np.zeros((nj,nk,nmodes+2))
      szio=np.zeros((nj,nk,nmodes+2))
#  yp2d_wave=np.zeros((nj,nk,nmodes+2))
      zp2d_wave=np.zeros((nj,nk,nmodes+2))
      u=np.zeros((nj,nk))
      v=np.zeros((nj,nk))
      w=np.zeros((nj,nk))
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

#     highest wave number, Section 27.3
      wnrn=2.*math.pi/dxmin
#
#     k_e (related to peak energy wave number), Section 27.4
      wnre=9.*math.pi*amp/(55.*sli)
#
# wavenumber used in the viscous expression (high wavenumbers) in the von Karman spectrum
      wnreta=(epsm/visc**3)**0.25

#     smallest wavenumber 
      wnr1=wnre/wew1fct

# wavenumber step
      dkn=(wnrn-wnr1)/nmodes

# wave numbers
      wnr=np.linspace(wnr1,wnrn,nmodes)

# invert the eigenvalue matrix (anisotropic)
      a11i=1/a11
      a22i=1/a22
      a33i=1/a33

# make a non-dimensional uv_rans profile
      uv_rans_max=np.max(uv_rans)
      uv_rans_non=(uv_rans/(uv_rans_max+1e-10))**0.5
# make it 2D
      uv_rans_non=np.repeat(uv_rans_non[:,None], repeats=nk, axis=1)


      print(f"\n{'sli: '} {sli}, {'visc: '}{visc:.2e}, {'nmodes: '}{nmodes}, {'dxmin: '}{dxmin:.3e}, {'dkn: '}{dkn:.3e}, {'dmin_synt: '}{dmin_synt:.3e}")

      print(f"\n{'wnre: '} {wnre:.2e}, {'wnr1: '}{wnr1:.2e}, {'epsm: '}{epsm:.3e}, {'wnrn: '}{wnrn:.3e}")

      print(f"\n{'eigenvalue 1, 2 and 3: '}{a11:.3e}, {a22:.3e}, {a33:.3e}")
      print(f"\n{'eigenvector R11, R12 and R13: '}{r11:.3e}, {r12:.3e}, {r13:.3e}")
      print(f"\n{'eigenvector R21, R22 and R23: '}{r21:.3e}, {r22:.3e}, {r23:.3e}")
      print(f"\n{'eigenvector R31, R32 and R33: '}{r31:.3e}, {r32:.3e}, {r33:.3e}\n")

      

#
#=========================== chapter 2 ============================================
#

# compute random angles
   fi = np.random.uniform(0.,2.*math.pi,nmodes)
   psi = np.random.uniform(0.,2.*math.pi,nmodes)
   alfa = np.random.uniform(0.,2.*math.pi,nmodes)
   ang = np.random.uniform(0.,1,nmodes)
   teta=np.arccos(1.-ang/0.5) 

   print('time step no,',it)


#   wavenumber vector from random angles
   kxio=np.sin(teta)*np.cos(fi)
   kyio=np.sin(teta)*np.sin(fi)
   kzio=np.cos(teta)
#
# sigma (s=sigma) from random angles. sigma is the unit direction which gives the direction
# of the synthetic velocity vector (u, v, w)
   sxio=np.cos(fi)*np.cos(teta)*np.cos(alfa)-np.sin(fi)*np.sin(alfa)
   syio=np.sin(fi)*np.cos(teta)*np.cos(alfa)+np.cos(fi)*np.sin(alfa)
   szio=-np.sin(teta)*np.cos(alfa)
   
#
#=========================== chapter 3 ============================================
#
# loop over all wavenumbers 
# Eq. 27.28
   kxi=r11*kxio+r21*kyio+r31*kzio
   kyi=r12*kxio+r22*kyio+r32*kzio
   kzi=r13*kxio+r23*kyio+r33*kzio

   sxi=r11*sxio+r21*syio+r31*szio
   syi=r12*sxio+r22*syio+r32*szio
   szi=r13*sxio+r23*syio+r33*szio

   sx=a11**0.5*sxi
   sy=a22**0.5*syi
   sz=a33**0.5*szi

   kx=kxi*wnr*a11i**0.5 
   ky=kyi*wnr*a22i**0.5
   kz=kzi*wnr*a33i**0.5
   rk=np.sqrt(kx**2+ky**2+kz**2)



   xp2d_wave=np.repeat(xp2d_synt[:,:,None], repeats=nmodes, axis=2)
   arg1=xp2d_wave*kx  # Eq. 27.28


   yp2d_wave=np.repeat(yp2d_synt[:,:,None], repeats=nmodes, axis=2)
   arg2=yp2d_wave*ky

   zp2d_wave=np.repeat(zp2d_synt[:,:,None], repeats=nmodes, axis=2)
   arg3=zp2d_wave*kz

   arg=arg1+arg2+arg3+psi  # Eq. 27.28

   tfunk=np.cos(arg)  # Eq. 27.8

# von Karman spectrum, Eq. 27.4
   e=amp/wnre*(wnr/wnre)**4/((1.+(wnr/wnre)**2)**(17./6.))*np.exp(-2*(wnr/wnreta)**2)

# include only wavenumber for which rk < wnrn
   e=np.where(rk < wnrn,e,0)

   utn=np.sqrt(e*up**2*dkn) # Eq. 27.4

# sum over all wavenumbers => synthetic velocity field 
   usynt=np.sum(2.*utn*tfunk*sx,axis=2) # 27.8 
   vsynt=np.sum(2.*utn*tfunk*sy,axis=2)
   wsynt=np.sum(2.*utn*tfunk*sz,axis=2)
   
# transform back to x-y-z  => anjsotropic fluct
   usynt_aniso=r11*usynt+r12*vsynt+r13*wsynt
   vsynt_aniso=r21*usynt+r22*vsynt+r23*wsynt
   wsynt_aniso=r31*usynt+r32*vsynt+r33*wsynt

# mean shear stress (must be computed before mirroring)
   uv=np.mean(usynt_aniso*vsynt_aniso)

# mirror vfluct
   if jmirror > 0:
      vsynt_aniso[jmirror:,:]=-vsynt_aniso[jmirror:,:]

# sum over timesteps
   uv_synt_mean=uv_synt_mean+uv

# compute average
   uvmean_time=np.abs(uv_synt_mean)/(it+1)
   print('uvmean_time',uvmean_time)

   scale_2=(uv_rans_max/uvmean_time)**0.5*uv_rans_non

# if uv_rans=1: don't scale
#  scale_2=np.where(uv_rans==1,1,(uv_rans_max/uvmean_time)**0.5*uv_rans_non)

# scale all fluctuations with uv_rans, see Section 5 in 
# L. Davidson "Two-equation hybrid RANS-LES models: A novel way to treat k and omega 
# at inlets and at embedded interfaces", J. of Turbulence, Volume 18, Issue 4, pp. 291-315, 2017.
   usynt_aniso=usynt_aniso*scale_2
   vsynt_aniso=vsynt_aniso*scale_2
   wsynt_aniso=wsynt_aniso*scale_2


# compute mean of synt fluct
   uvmean_check=uvmean_check+np.mean(usynt_aniso*vsynt_aniso,axis=1)

# peak of uv_rans
   j=np.where(uv_rans == np.amax(uv_rans))

# check peak
   print('synt: uvmean',np.abs(uvmean_check[j])/(it+1),'uv_rans_max=',np.max(np.abs(uv_rans)),'at j=',j)
 
   return usynt_aniso,vsynt_aniso,wsynt_aniso
