import scipy.io as sio
import numpy as np
import sys

# load RANS data from a 1D RANS 
data = np.loadtxt("y_u_k_om_395.txt")

y=data[:,0]
u=data[:,1]
rk_turb=data[:,2]
om=data[:,3]
ed=0.09*rk_turb*om

dudy=np.gradient(u,y)

nj=len(y)

uu=np.zeros(nj)
vv=np.zeros(nj)
ww=np.zeros(nj)
uv=np.zeros(nj)

for j in range (0,nj-1):

    diss=ed[j]
    rk=rk_turb[j]
    ttau=rk/diss

    om12=ttau*0.5*dudy[j]
    om21=-om12
    om22=0.
    om11=0.
    s11=0.
    s12=ttau*0.5*dudy[j]
    s21=s12
    s22=0.
    s33=0.
    vor=(-2.*om12**2)
    str1=(s11**2+s12**2+s21**2+s22**2)

      
    cpr1=9./4.*(1.8-1.)
    p1=(1./27.*cpr1**2+9./20.*str1-2./3.*vor)*cpr1
    p2=p1**2-(1./9.*cpr1**2+9./10.*str1+2./3.*vor)**3
      
    if p2 >  0:
       if p1-p2**0.5 >= 0:
          sigg=1.
       else:
          sigg=-1.
       un=cpr1/3.+(p1+p2**0.5)**(1./3.)+sigg*(abs(p1-p2**0.5))**(1./3.)
    else:
       un=cpr1/3.+2.*(p1**2-p2)**(1./6.)*np.cos(1./3.*np.arccos(p1/(np.sqrt(p1**2-p2))))
      
    const=6./5.
    beta1=-const*un/(un**2-2.*vor)
    beta4=beta1/un

    uu[j]=2./3.*rk+rk*beta1*s11+rk*beta4*(s12*om21-om12*s21)
    vv[j]=2./3.*rk+rk*beta1*s22+rk*beta4*(s21*om12-om21*s12)
    ww[j]=2./3.*rk
    uv[j]=rk*(beta1*s12+beta4*(s11*om12-om12*s22))

# max(uv) at j=19
j= np.where(uv == np.amin(uv))

r11=float(uu[j])
r12=float(uv[j])
r13=0
r21=float(uv[j])
r22=float(vv[j])
r23=0
r31=0
r32=0
r33=float(ww[j])

stress=[[r11,r12,r13], \
        [r21,r22,r23], \
        [r31,r32,r33]]

diag_sum=np.trace(stress)/3.
stress=stress/diag_sum

lambd,V =np.linalg.eig(stress)

v1=[V[0,0],V[1,0], V[2,0]]
v2=[V[0,1],V[1,1], V[2,1]]
v3=[V[0,2],V[1,2], V[2,2]]

lambda_1=lambd[0]
lambda_2=lambd[1]
lambda_3=lambd[2]

# largest eigenvalue in x1*, smallest in x2*, i.e. OK
v1_new=v1
v2_new=v2
v3_new=v3

lambda_1_new=lambda_1
lambda_2_new=lambda_2
lambda_3_new=lambda_3

# 1st eigenvector in 1st or 3rd quadrant
# 2nd eigenvector in 2nd or 4th quadrant
# switch sign on 12 and 21 to fix the above requirements
v1_new[0]=-v1_new[0]
v2_new[1]=-v2_new[1]


r11=v1_new[0]
r12=v1_new[1]
r13=v1_new[2]

r21=v2_new[0]
r22=v2_new[1]
r23=v2_new[2]

r31=v3_new[0]
r32=v3_new[1]
r33=v3_new[2]

a11=lambda_1_new
a22=lambda_2_new
a33=lambda_3_new;

print('eigenvector 1= ',r11,r21,r31)
print('eigenvector 2= ',r12,r22,r32)
print('eigenvector 3= ',r13,r23,r33)

print('eigenvalue 1= ',a11)
print('eigenvalue 2= ',a22)
print('eigenvalue 3= ',a33)

l1=[r11,r12,r13]
l2=[r21,r22,r23]
l3=[r31,r32,r33]

col1=[r11,r21,r31]
col2=[r12,r22,r32]
col3=[r13,r23,r33]

np.savetxt('R_earsm_kom.dat', np.c_[col1, col2, col3])
f=open('R_earsm_kom.dat','a') #append
f.write('%from EARSM')
f.close()

np.savetxt('a_earsm_kom.dat', np.c_[a11,a22,a33])
fa=open('a_earsm_kom.dat','a') #append
fa.write('%from EARSM')
f.close()

