
from sklearn.preprocessing import MinMaxScaler
from sklearn.preprocessing import StandardScaler
from sklearn.linear_model import LinearRegression
from sklearn.svm import SVR
from sklearn.svm import LinearSVR
from joblib import dump, load
import numpy as np


global model,scaler_re,re_max,re_min,scaler_yplus,yplus_max,yplus_min,file1,dudy_min,dudy_max,scaler_dudy,ustar_south,ustar_north

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

y=yp2d[1,:]

viscos=1/5200

folder='/chalmers/users/lada/noback/pycalc-les/channel-5200-IDDES-fk-0-no-f_e-ML-database-3cells-1500000-timesteps/'

filename=str(folder)+'model-low-re-svrLINEAR-C-0.1-eps-0.001-re_u-yplus-inst-uplus-output-first-cell-1-7-cells-local.bin'
                           
model = load(filename)
print('model',model)
scaler_re = load(str(folder)+'model-low-ustar-svrLINEAR-C-0.1-eps-0.001-re_u-yplus-inst-uplus-output-first-cell-1-7-cell_scaler-re-local.bin')
scaler_yplus = load(str(folder)+'model-low-ustar-svrLINEAR-C-0.1-eps-0.001-re_u-yplus-inst-uplus-output-first-cell-1-7-cell_scaler-yplus-local.bin')
re_max,re_min,yplus_max,yplus_min = np.loadtxt(str(folder)+'min-max-model-low-re-svrLINEAR-C-0.1-eps-0.001-re_u-yplus-inst-uplus-output-first-cell-1-7-cells-local.txt')

print('re_max,re_min,yplus_max,yplus_min',re_max,re_min,yplus_max,yplus_min)
ni=2
nk=2
ustar_south=np.ones((ni,nk))
ustar_north=np.ones((ni,nk))


################# south wall
u2d_wall=np.ones((ni,nk))*7.7
# yplus=13.88892781

# u=7.7

# normalize
dy_wall=y[0]  # first cell


print('u2d_wall,dy_wall',u2d_wall[0,0],dy_wall)

for n in range(0,3):

      re=u2d_wall*dy_wall/viscos
      yplus=ustar_south*dy_wall/viscos

#flatten
      re=re.flatten()
      yplus=yplus.flatten()

      print('south n,re_min,max,mean',n,np.min(re),np.max(re),np.mean(re))
      print('south n,yplus_min,max,mean',n,np.min(yplus),np.max(yplus),np.mean(yplus))

# count values larger/smaller than max/min
      re_min_number= (re < re_min).sum()
      re_max_number= (re > re_max).sum()

      yplus_min_number= (yplus < yplus_min).sum()
      yplus_max_number= (yplus > yplus_max).sum()

      print('south: yplus_min_number',yplus_min_number)
      print('south: yplus_max_number',yplus_max_number)
      print('south: re_min_number',re_min_number)
      print('south: re_max_number',re_max_number)


# set limits
      re=np.minimum(re,re_max)
      re=np.maximum(re,re_min)
      yplus=np.minimum(yplus,yplus_max)
      yplus=np.maximum(yplus,yplus_min)

#size
      N=len(re)
# re-scale
      re=re.reshape(-1, 1)
      yplus=yplus.reshape(-1, 1)
      re=scaler_re.transform(re)
      yplus=scaler_yplus.transform(yplus)

# predict
      X=np.zeros((N,2))
      X[:,0]=yplus[:,0]
      X[:,1]=re[:,0]

# compute ustar
      y_svr = model.predict(X) # uplus

      uplus=np.reshape(y_svr,(ni,nk))
 
      ustar=np.divide(u2d_wall,uplus)
      ustar_south=ustar

      print('n,south ustar_south,max,mean',n,np.min(ustar_south),np.max(ustar_south),np.mean(ustar_south))

