import numpy as np
from scipy import sparse
from scipy.sparse import spdiags,linalg,eye
import sys
import time
import pyamg
import pyamgx


################################# test Python sparse matrix solver
ni=20
nj=20
nk=20
n=ni*nj*nk
ap=np.ones(n)*6
ae=np.ones(n)
aw=np.ones(n)
as1=np.ones(n)
an=np.ones(n)
al=np.ones(n)
ah=np.ones(n)
su=np.ones(n)
phi=np.zeros(n)
# set up the matrix
A = sparse.diags([ap, -ah[:-1], -al[1:], -an[0:-nk], -as1[nk:], -ae, -aw[nj*nk:],-aw,-ae[nj*nk*(ni-1):]], \
            [0, 1, -1, nk,-nk, nk*nj, -nk*nj, nj*nk*(ni-1), -nj*nk*(ni-1)], format='csr')
# solve the eq
phi,info=linalg.gmres(A,su,x0=phi, atol=1e-6, tol=1e-6,  maxiter=100)
# compute residual without normalizing with |b|=|su3d|
resid=np.linalg.norm(A*phi - su)
print('\n\n************************ GMRES solver works')
print('residual for GMRES solver',resid,'\n\n')


################################# test pyAMG solver
# PyAMG is easy to use! The following code constructs a two-dimensional Poisson problem and solves 
# the resulting linear system with Classical AMG.

A = pyamg.gallery.poisson((500,500), format='csr')  # 2D Poisson problem on 500x500 grid
ml = pyamg.ruge_stuben_solver(A)                    # construct the multigrid hierarchy
print(ml)                                           # print hierarchy information
b = np.random.rand(A.shape[0])                      # pick a random right hand side
x = ml.solve(b, tol=1e-10)                          # solve Ax=b to a tolerance of 1e-10

print('\n************************ pyAMG solver works')
print("residual for pyAMG solver: ", np.linalg.norm(b-A*x),'\n\n')          # compute norm of residual vector

pyamgx.initialize()
# use pyamgx
cfg = pyamgx.Config().create_from_dict({
     "config_version": 2,
     "determinism_flag": 1,
     "exception_handling" : 1,
     "solver": {
         "monitor_residual": 0,
         "solver": "BICGSTAB",
         "convergence": "RELATIVE_INI_CORE",
         "preconditioner": {
             "solver": "NOSOLVER"
         }
     }
 })


rsc = pyamgx.Resources()
rsc.create_simple(cfg)

# Create matrices and vectors:
A = pyamgx.Matrix().create(rsc)
x = pyamgx.Vector().create(rsc)
b = pyamgx.Vector().create(rsc)
 
# Create solver:
solver = pyamgx.Solver().create(rsc, cfg)
 
# Upload system:
M = sparse.csr_matrix(np.random.rand(5, 5))
rhs = np.random.rand(5)
sol = np.zeros(5, dtype=np.float64)
 
A.upload_CSR(M)
b.upload(rhs)
x.upload(sol)
 
# Setup and solve:
solver.setup(A)
solver.solve(b, x)
 
# Download solution
x.download(sol)
print('\n\n************************ pyAMGx solver works\n\n')
#print("pyamgx solution: ", sol)
#print("numpy solution: ",  linalg.spsolve(M, rhs))

