
from synt_fluct_stand_alone import  synt_fluct
from scipy import sparse
import numpy as xp
import sys
import time

global y_rans,y_rans,u_rans,v_rans,k_rans,om_rans,uv_rans,zp,a_synt,b_synt,usynt_inlet,vsynt_inlet,wsynt_inlet,\
          uu_synt,vv_synt,ww_synt,uv_synt,two_corr,u_time,w_synt,k_bc_west,eps_bc_west
  
global usynt,vsynt,wsynt


# load grid from channel-395-inlet-ni96-from-sqrt-u-times-v-lgmres-dymin-nmodes-1200-2dt/
########## grid specification ###########
name = 'channel-395-inlet-ni96-from-sqrt-u-times-v-lgmres-dymin-nmodes-1200-2dt/'
datax= xp.loadtxt(str(name)+"x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= xp.loadtxt(str(name)+"y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])
   
x2d=xp.zeros((ni+1,nj+1))
y2d=xp.zeros((ni+1,nj+1))
         
x2d=xp.reshape(x,(ni+1,nj+1))
y2d=xp.reshape(y,(ni+1,nj+1))
   
dataz=xp.loadtxt(str(name)+'z.dat')

zmax=dataz[0]
nk=dataz[1]
nk=int(nk)
dz=zmax/nk
dz3d=xp.ones((ni+1,nj+1,nk))*dz
z = xp.linspace(0, zmax, nk+1)

# loop over time steps
ntstep = 4
dt= 2.34e-03*xp.ones(ntstep)

# synthetic inlet fluct
L_t_synt=0.2
nmodes_synt=1200
jmirror_synt=int(nj/2) # mirror vsynt at node jmirror; jmirror=0 means no mirroring
dmin_synt=dz/2

viscos = 1/395

for itstep in range(0,ntstep):

   if itstep == 0:
      two_corr=xp.zeros(2*nk-1)
      u_time=xp.zeros(ntstep)
      y_u_k_om=xp.loadtxt(str(name)+'y_u_k_om_uv_395_DNS-python.txt')
      y_rans=y_u_k_om[:,0]
      u_rans=y_u_k_om[:,1]
# make it 2D
      u_rans=xp.repeat(u_rans[:,None], repeats=nk, axis=1)

      uv_rans=xp.abs(y_u_k_om[:,4])

# z grid
      zp = xp.linspace(0, zmax, nk)
      usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
# correct usynt so that it is = 0 (easier to converge the p solver)
      usynt_inlet=usynt
      vsynt_inlet=vsynt
      wsynt_inlet=wsynt
# tturb from ustar=1
      tturb=L_t_synt/1
      a_synt=xp.exp(-dt[itstep]/tturb)
      b_synt=(1.-a_synt**2)**0.5
      print('a_synt,b_synt,tturb',a_synt,b_synt,tturb)
      uu_synt=xp.zeros(nj)
      vv_synt=xp.zeros(nj)
      ww_synt=xp.zeros(nj)
      uv_synt=xp.zeros(nj)

   usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
# correct usynt so that it is = 0 (easier to converge the p solver)
   usynt_inlet=a_synt*usynt_inlet+b_synt*usynt
   vsynt_inlet=a_synt*vsynt_inlet+b_synt*vsynt
   wsynt_inlet=a_synt*wsynt_inlet+b_synt*wsynt
   u_bc_west=u_rans+usynt_inlet
   v_bc_west=vsynt_inlet
   w_bc_west=wsynt_inlet

   uu_synt=uu_synt+xp.mean(usynt**2,axis=1)
   vv_synt=vv_synt+xp.mean(vsynt**2,axis=1)
   ww_synt=ww_synt+xp.mean(wsynt**2,axis=1)
   uv_synt=uv_synt+xp.mean(usynt*vsynt,axis=1)

# update face velocity and convw at inlet
#  u3d_face_w[0,:,:]=u_bc_west
#  convw[0,:,:]=-u_bc_west*areawx[0,:,:]-v_bc_west*areawy[0,:,:]

# compute two-point corr in node 10
   two_corr=two_corr+xp.correlate(w_bc_west[10,:],w_bc_west[10,:],'full')

# compute average
   if itstep % 100 == 0:
      xp.save('two_corr_inlet',two_corr)
      xp.save('u_time',u_time)
      xp.save('uu_synt',uu_synt/(itstep+1))
      xp.save('uv_synt',uv_synt/(itstep+1))

