import scipy.io as sio
import numpy as np
import sys
import matplotlib.pyplot as plt
from matplotlib import ticker
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
import matplotlib.ticker as mtick
from matplotlib import ticker

plt.close('all')
#from IPython import display
plt.rcParams.update({'font.size': 26})
plt.interactive(True)



re =9.36e+5 
viscos =1./re

# file 1

name='./'

datax= np.loadtxt(str(name)+"x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt(str(name)+"y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

# read data 
itstep,nk,dz=np.load(str(name)+'itstep.npy')

# z grid
zmax, nk=np.loadtxt(str(name)+'z.dat')
nk=int(nk)
zp = np.linspace(0, zmax, nk)

# read data 
itstep,nk,dz=np.load(str(name)+'itstep.npy')

p2d=np.load(str(name)+'p_averaged.npy')/itstep
u2d=np.load(str(name)+'u_averaged.npy')/itstep
v2d=np.load(str(name)+'v_averaged.npy')/itstep
w2d=np.load(str(name)+'w_averaged.npy')/itstep
k_model_2d=np.load(str(name)+'k_averaged.npy')/itstep
vis2d=np.load(str(name)+'vis_averaged.npy')/itstep
uu2d=np.load(str(name)+'uu_stress.npy')/itstep
vv2d=np.load(str(name)+'vv_stress.npy')/itstep
ww2d=np.load(str(name)+'ww_stress.npy')/itstep
uv2d=np.load(str(name)+'uv_stress.npy')/itstep
fk2d=np.load(str(name)+'fk_averaged.npy')/itstep
eps2d=np.load(str(name)+'eps_averaged.npy')/itstep


uu2d=uu2d-u2d**2
uv2d=uv2d-u2d*v2d

diss2d=eps2d
dx=np.diff(x2d,axis=0)
dy=np.diff(y2d,axis=1)
rl=k_model_2d**1.5/diss2d
fk2d_computed=np.zeros((ni,nj))
delta_max=np.zeros((ni,nj))
for i in range (0,ni-2):
   for j in range (0,nj-2):
      delta_max[i,j]=max(dx[i,j],dy[i,j],dz)
      fk2d_computed[i,j]=rl[i,j]/delta_max[i,j]/0.67

kres_2d=0.5*(uu2d+vv2d+ww2d)

# compute re_theta for boundary layer flow
dx=x[3]-x[2]
re_mom_bl=np.zeros(ni)
for i in range (0,ni-1):
   d_mom=0
   d_mom_rans=0
   for j in range (1,nj-1):
      up=u2d[i,j]/u2d[i,-1]
      dy=y2d[i,j]-y2d[i,j-1]
      d_mom=d_mom+up*(1.-min(up,1.))*dy


   re_mom_bl[i]=d_mom*u2d[i,-1]/viscos


re_mom_bl[0]=re_mom_bl[1]
re_mom_bl[-1]=re_mom_bl[-2]

cf_exp_retheta=2*(1./0.384*np.log(re_mom_bl)+4.127)**(-2)


cf=np.zeros(ni)
ustarv=np.zeros(ni)
for i in range (0,ni-1):
     xt=x2d[i,0]-x2d[i-1,0]
     yt=y2d[i,0]-y2d[i-1,0]
     rl=(xt**2+yt**2)**0.5
     xt=xt/rl
     yt=yt/rl
     uwall=abs(u2d[i,0]*xt+v2d[i,0]*yt)
     xn=-yt
     yn=xt
     yp=0.5*abs((y2d[i,1]-y2d[i,0])*yn+(x2d[i,1]-x2d[i,1])*xn)
     ustar=(uwall*viscos/yp)**0.5
     ustars=(uwall*viscos/yp)**0.5*u2d[i,0]/abs(u2d[i,0])
     cf[i]=abs(ustars)*ustars/0.5

ustarv[0]=ustarv[1]

cf[0]=cf[1]


ywall=yp2d[:,0]
dist=yp2d-ywall[:,None]


jl0v=[0]*ni
jl0v_dist=np.zeros(ni)
for i in range (0,ni-1):
   for j in range (0,nj-1):
     if fk2d[i,j+1] > 1.0: 
#    if fk2d_computed[i,j+1] > 1.0: 
        jl0v[i]=int(j)
        jl0v_dist[i]=yp2d[i,j]-yp2d[i,0]
        break

jl0v[0]=jl0v[1]
jl0v[-1]=jl0v[-1-1]
jl0v_dist[0]=jl0v_dist[0]
jl0v_dist[-1]=jl0v_dist[-1-1]

p2d_iddes=p2d
u2d_iddes=u2d
k_model_2d_iddes=k_model_2d
fk2d_iddes=fk2d
vis2d_iddes=vis2d
uv2d_iddes=uv2d
uu2d_iddes=uu2d
cf_iddes=cf
jl0v_iddes=jl0v
jl0v_dist_iddes=jl0v_dist
re_mom_bl_iddes=re_mom_bl

f_e_mean=np.load(str(name)+'f_e_mean.npy')/itstep
l_u=k_model_2d**1.5/eps2d
f_dt=np.load(str(name)+'f_dt_mean.npy')/itstep
f_b=np.load(str(name)+'f_b_mean.npy')/itstep
f_d_mean=np.maximum((1.-f_dt),f_b)

l_dist=0.15*yp2d
delta_max=np.diff(x2d[:,1:],axis=0)
l_max=0.15*delta_max
dy=np.diff(y2d[1:,:],axis=1)

l_temp=np.maximum(l_dist,l_max)
l_temp=np.maximum(l_temp,dy)
l_iddes=np.minimum(l_temp,delta_max)
#  l_iddes=np.minimum(np.maximum(l_dist,l_max,dy),delta_max)
cdes=0.67
l_c_mean=cdes*l_iddes  #eq. 9
l_u=k_model_2d**1.5/eps2d
l_c_mean_iddes=l_c_mean
f_e_mean_iddes=f_e_mean
f_d_mean_iddes=f_d_mean
l_u_iddes=l_u

x065_off=np.genfromtxt("x065_off.dat", dtype=None,comments="%")
x080_off=np.genfromtxt("x080_off.dat", dtype=None,comments="%")
x090_off=np.genfromtxt("x090_off.dat", dtype=None,comments="%")
x100_off=np.genfromtxt("x100_off.dat", dtype=None,comments="%")
x110_off=np.genfromtxt("x110_off.dat", dtype=None,comments="%")
x120_off=np.genfromtxt("x120_off.dat", dtype=None,comments="%")
x130_off=np.genfromtxt("x130_off.dat", dtype=None,comments="%")

SPIV_avgvel_noflow_x100=np.genfromtxt("SPIV_avgvel_noflow_x100.dat", dtype=None,comments="%")
SPIV_avgvel_noflow_x110=np.genfromtxt("SPIV_avgvel_noflow_x110.dat", dtype=None,comments="%")
SPIV_avgvel_noflow_x120=np.genfromtxt("SPIV_avgvel_noflow_x120.dat", dtype=None,comments="%")
SPIV_avgvel_noflow_x130=np.genfromtxt("SPIV_avgvel_noflow_x130.dat", dtype=None,comments="%")

# exp
noflow_cf=np.genfromtxt("noflow_cp.dat", dtype=None,comments="%")
cp_exp=noflow_cf[:,1]
xp_exp=noflow_cf[:,0]

noflow_cp=np.genfromtxt("noflow_cf.dat", dtype=None,comments="%")
cf_exp=noflow_cp[:,1]
x_exp=noflow_cp[:,0]


cexp=420;
uin=34.6;



########################################## l_c l_u  iddes
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20,top=0.8)
xx=1.;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(l_u_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-',label='$l_u$')
ax1.plot(l_c_mean_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--',label='$l_c$')
ax1.set_ylabel("$y-y_{wall}$")

ax2 = ax1.twiny()
ax2.plot(fk2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'k-.',label=r'$\psi_u$')
ax2.plot(f_e_mean_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'b--',label='$l_c$')
ax2.plot(f_d_mean_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r-',label='$l_c$')

# giving labels to the axises
ax1.set_xlabel(r"$\langle l_u\rangle  \quad \langle l_c\rangle $")

# secondary y-axis label
ax2.set_xlabel(r'$\langle \psi\quad f_e\rangle  \quad \langle f_d\rangle $')
ax1.axis([0, 0.005,  0,0.05])
ax2.axis([0, 1.8,  0,0.05])
plt.savefig('lc-lu-fk-iddes-100-hump-etmm13-journal.png',bbox_inches='tight')



########################################## cf
# find boundary layer thickness
delta=np.zeros(ni)
for i in range(1,ni-1):
   for j in range(0,nj-2):
      up=u2d_iddes[i,j]/u2d_iddes[i,-1]
      up1=u2d_iddes[i,j+1]/u2d_iddes[i,-1]
      if up < 0.99 and up1 > 0.99:
         jj = j
         break
   up=u2d_iddes[i,jj]/u2d_iddes[i,-1]
   up1=u2d_iddes[i,jj+1]/u2d_iddes[i,-1]
   delta[i]=y[jj]+(0.99-up)*(y[jj+1]-y[jj])/(up1-up)

fig16,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
ax1.plot(xp2d[:,1],cf_iddes,'r--')
n1=60
ax1.plot(x_exp[:n1],cf_exp[:n1],'bo',fillstyle='none')
ax1.plot(x_exp[n1:-1:4],cf_exp[n1:-1:4],'bo',fillstyle='none')
ax1.set_xlabel('$x$')
ax1.set_ylabel('$C_f$',rotation=0)
ax1.yaxis.set_label_coords(-0.095, 0.4)
ax1.axis([-0.5,1.5,-0.002,0.0086])

axins1 = inset_axes(ax1, width="40%", height="40%", loc='upper right', borderpad=0.1)
plt.plot(xp2d[:,1],cf_iddes,'r--')
n1=60
plt.plot(x_exp[:n1],cf_exp[:n1],'bo',fillstyle='none')
plt.plot(x_exp[n1:-1:4],cf_exp[n1:-1:4],'bo',fillstyle='none')
plt.axis([0.5,1.2,-0.002,0.001])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
#axins1.yaxis.set_label_position("right")
#axins1.yaxis.tick_right()
axins1.xaxis.set_label_position("bottom")
axins1.xaxis.tick_bottom()
axins1.set_xticks([0.75,1.0])
axins1.set_xlabel('$x/c$',fontsize=10)

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)
axins1.tick_params(labelleft=False)

plt.savefig('cf_hump.png')



plt.subplots_adjust(left=0.30, bottom=0.2, right=0.92, top=0.82, wspace=0, hspace=0.0)
i1=148
i1=150
xmax=x2d[i1,1]/delta[1]
ax1.plot(re_mom_bl_iddes[0:i1],cf_iddes[0:i1],'r--',label="$x=0$")
#ax1.plot(re_mom_bl_iddes,cf_iddes,'r--',label="$x=0$")
M = 2
xticks = ticker.MaxNLocator(M)
ax1.yaxis.set_major_locator(xticks)
ax1.yaxis.set_label_coords(-0.095, 0.6)

h1=ax1.set_ylabel(r"$C_f$")
h1.set_rotation(0)

ax1.set_ylabel(r"$C_f$")
ax1.set_xlabel(r"$Re_\theta$")
ax2.set_xlabel(r"$x/c$")
ax1.axis([6000,7000,0.0025,0.0031])
ax1.yaxis.set_major_formatter(mtick.FormatStrFormatter('%.1e'))
#ax1.legend(loc="upper right",prop=dict(size=18))
ax2.axis([-2.1,x2d[i1,0],0.0025,0.0031])
plt.savefig('cf_vs_re_mom-etmm13-journal-hump.png')





########################################## cp
fig15,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)


p0=p2d_iddes[-1,1]
cp_org=(p2d_iddes[:,1]-p0)/0.5;
cp=cp_org+cp_exp[-1];
ax1.plot(xp2d[:,1],-cp,'r--')
ax1.yaxis.set_label_coords(-0.095, 0.4)

ax1.plot(xp_exp,-cp_exp,'bo',fillstyle='none')
ax1.set_xlabel('$x/c$')
ax1.set_ylabel('$-C_p$',rotation=0)
#ax1.ylabel("$-C_p$")
ax1.axis([-1.1,1.9,-.5,1])
plt.savefig('cp_hump.png')


########################################## uv i=0
fig18,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 =0

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')


ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'k-.')

ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(x065_off[:,6],x065_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 
plt.title("i=0")
plt.ylabel("$(y-y_{wall})/c$")
plt.axis([-0.002, 0,0,0.025])

plt.savefig('uv-i-0.png')

########################################## uv x=0
fig18,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')


ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(x065_off[:,6],x065_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 
plt.title("x=0")
plt.ylabel("$y$")
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.004, 0,0,0.025])

plt.savefig('uv0.png')


########################################## uv065
fig18,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.65;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'r--')


ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(x065_off[:,6],x065_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
M = 3
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 
M = 2
yticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.yaxis.set_major_locator(yticks) 
plt.ylabel("$y$")
plt.ylabel("$(y-y_{wall})/c$")
plt.axis([-0.0065, 0.004,0,0.02])


ax1.annotate('total', xy=(-0.004,0.005), xytext=(-0.006, 0.01),
            arrowprops=dict(facecolor='black', shrink=0.05),fontsize=15)
ax1.annotate('(-)modeled', xy=(0.001, 0.005), horizontalalignment='right',xytext=(0.0029,0.015),
            arrowprops=dict(facecolor='black', shrink=0.05),fontsize=15)


plt.savefig('uv065.png')


########################################## uv080
fig19,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.80;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'b-')

ax1.plot(x080_off[:,6],x080_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.03, 0.002,0,0.2])
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 


plt.savefig('uv080.png')

########################################## uv090
fig20,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.90;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'b-')

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'r--')


ax1.plot(x090_off[:,6],x090_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.03, 0.002,0,0.2])
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 


plt.savefig('uv090.png')

########################################## uv100
fig21,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.00;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'b-')

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'r--')

ax1.plot(x100_off[:,6],x100_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.ylabel("$(y-y_{wall})/c$")
plt.axis([-0.03, 0.002,0,0.2])
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 

ax1.annotate('total', xy=(-0.015,0.1), xytext=(-0.02, 0.15),
            arrowprops=dict(facecolor='black', shrink=0.05), horizontalalignment='right',fontsize=15)
ax1.annotate('(-)modeled', xy=(0.001, 0.04), horizontalalignment='right',xytext=(-0.01,0.05),
            arrowprops=dict(facecolor='black', shrink=0.05),fontsize=15)



plt.savefig('uv100.png')

########################################## uv110
fig22,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.10;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'b-')

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'r--')

ax1.plot(x110_off[:,6],x110_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.03, 0.003,0,0.2])
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 

plt.savefig('uv110.png')



########################################## uv120
fig23,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.20;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'b-')

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'r--')

ax1.plot(x120_off[:,6],x120_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.025, 0.003,0,0.2])
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 
plt.savefig('uv120.png')

########################################## uv130
fig24,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.30;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'b-')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'b-')

uv_sgs=-vis2d_iddes[i1,:]*np.gradient(u2d_iddes[i1,:],yp2d[i1,:])
uv_tot=uv2d_iddes[i1,:]+uv_sgs
ax1.plot(uv_tot,yp2d[i1,:]-yp2d[i1,0],'r--')
ax1.plot(-uv_sgs,yp2d[i1,:]-yp2d[i1,0],'r--')

ax1.plot(x130_off[:,6],x130_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.ylabel("$(y-y_{wall})/c$")
plt.axis([-0.025, 0.003,0,0.2])
M = 2
xticks = ticker.MaxNLocator(M) 
# Set the yaxis major locator using 
# your ticker object.  
ax1.xaxis.set_major_locator(xticks) 

ax1.annotate('total', xy=(-0.015,0.07), xytext=(-0.02, 0.1),
arrowprops=dict(facecolor='black', shrink=0.05), horizontalalignment='right',fontsize=15)

ax1.annotate('(-)modeled', xy=(0.0,0.02), 
arrowprops=dict(facecolor='black', shrink=0.05),
fontsize=15,
horizontalalignment='center',verticalalignment='top',
xytext=(-0.008,0.06))

plt.savefig('uv130.png')


#%%%%%%%%%%%%%%%%%%%%% grid
fig50,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
ii=8;
for i in range(0,ni,ii):
   plt.plot(x2d[i,:],y2d[i,:],'b-')
for j in range(0,nj,ii):
   plt.plot(x2d[:,j],y2d[:,j],'b-')

plt.axis([-2.1, 4.1 ,0 ,.91])
ax1.set_aspect('equal', adjustable='box')
plt.xlabel('$x/c$')
plt.ylabel('$y/c$')
plt.savefig('grid.png')

########################################## vis 065
fig9,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\langle \nu_t\rangle /\nu$')
plt.ylabel("$y-y_{wall}$")
plt.axis([0, 75,0,0.2])

plt.savefig('vis000_hump.png')

########################################## vis 065
fig9,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.65;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\nu_t/\nu$')
plt.ylabel("$y-y_{wall}$")
plt.axis([0, 40,0,0.2])

plt.savefig('vis065_hump.png')


########################################## vis 080
fig9,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.80;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\nu_t/\nu$')
plt.ylabel("$y-y_{wall}$")
plt.axis([0, 40.3,0,0.2])


plt.savefig('vis080_hump.png')


########################################## vis 090
fig10,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.90;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\nu_t/\nu$')
plt.ylabel("$y-y_{wall}$")
plt.axis([0, 40,0,0.2])


plt.savefig('vis090_hump.png')


########################################## vis 100
fig11,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.00;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\nu_t/\nu$')
plt.ylabel("$y$")
plt.axis([0, 40.3,0,0.2])

plt.savefig('vis100_hump.png')


########################################## vis 110
fig12,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.10;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\nu_t/\nu$')
plt.ylabel("$y$")
plt.axis([0, 40,0,0.2])


plt.savefig('vis110_hump.png')


########################################## vis 120
fig13,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.20;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\nu_t/\nu$')
plt.ylabel("$y$")
plt.axis([0, 40.3,0,0.2])

plt.savefig('vis120_hump.png')


########################################## vis 130
fig14,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.30;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d_iddes[i1,:]/viscos,yp2d[i1,:]-yp2d[i1,0],'r--')
plt.xlabel(r'$\nu_t/\nu$')
plt.ylabel("$y$")
plt.axis([0, 40,0,0.2])


plt.savefig('vis130_hump.png')





#%%%%%%%%%%%%%%%%%%%%% grid dx
fig51,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
dxv=np.zeros(ni)
dxv=np.diff(x2d[:,1])
dxv[-1]=dxv[-1-1]
plt.plot(x2d[0:-1,1],dxv,'b-')
plt.axis([-2.1, 4.1 ,0 ,.05])
plt.xlabel('$x$')
plt.ylabel(r'$\Delta x$')
plt.savefig('dxv-hump.png')



########################################## U 065
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.65;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x065_off[:,2],x065_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel(r"$\langle \bar{u}\rangle$")
plt.ylabel("$(y-y_{wall})/c$")
plt.axis([0, 1.3,0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax1, width="50%", height="50%", loc=2, borderpad=0.35)
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.axis([0, 1.0,0,0.004])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x065_off[:,2],x065_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')

plt.savefig('u065_hump.png')

########################################## U 080
fig2,ax2 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.80;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x080_off[:,2],x080_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.3,1.3,0.,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax2, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.axis([-0.22,0.005,0.,0.002])
plt.plot(x080_off[:,2],x080_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x080_off[:,2],x080_off[:,1],'bo',fillstyle='none')

plt.savefig('u080_hump.png')

########################################## U 090
fig3,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.90;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x090_off[:,2],x090_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x090_off[:,2],x090_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.axis([-0.3,0.01,0.,0.002])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x090_off[:,2],x090_off[:,1],'bo',fillstyle='none')

plt.savefig('u090_hump.png')

########################################## U 100
fig4,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.00;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x100_off[:,2],x100_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel(r"$\langle \bar{u}\rangle$")
plt.ylabel("$(y-y_{wall})/c$")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x100_off[:,2],x100_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.axis([-0.25,0.01,0.,0.0035])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x100_off[:,2],x100_off[:,1],'bo',fillstyle='none')

plt.savefig('u100_hump.png')

########################################## U 110
fig5,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.10;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x110_off[:,2],x110_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x110_off[:,2],x110_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.axis([-0.05,0.07,0.,0.0035])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x110_off[:,2],x110_off[:,1],'bo',fillstyle='none')

plt.savefig('u110_hump.png')


########################################## U 120
fig6,ax3 = plt.subplots()
plt.subplots_adjust(left=0.15,bottom=0.20)
xx=1.20;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x120_off[:,2],x120_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y-y_{wall}$")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x120_off[:,2],x120_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.axis([0.,0.3,0.,0.004])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x120_off[:,2],x120_off[:,1],'bo',fillstyle='none')

plt.savefig('u120_hump.png')

########################################## U 130
fig7,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.30;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x130_off[:,2],x130_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel(r"$\langle \bar{u}\rangle$")
plt.ylabel("$(y-y_{wall})/c$")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d_iddes[i1,:],yp2d[i1,:]-yp2d[i1,0],'r--')
plt.plot(x130_off[:,2],x130_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.axis([0.,0.4,0.,0.004])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x130_off[:,2],x130_off[:,1],'bo',fillstyle='none')

plt.savefig('u130_hump.png')




