import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from IPython import display
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})


# makes sure figures are updated when using ipython
display.clear_output(wait=True)

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))


#%%%%%%%%%%%%%%%%%%%%% grid
for i in range(0,ni+1,8):
   plt.plot(x2d[i,:],y2d[i,:])

for j in range(0,nj+1,8):
   plt.plot(x2d[:,j],y2d[:,j])

plt.plot(x2d[-1,:],y2d[-1,:])
plt.plot(x2d[:,-1],y2d[:,-1])

plt.xlabel('$x$')
plt.ylabel('$y$')
plt.axis([-2.1 ,4, 0,1])
plt.axis('equal')
plt.axis('off')

plt.savefig('grid-hump.png',bbox_inches='tight')


