import os.path                                                                                                                  
import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})
plt.interactive(True)

re =9.36e+5 
viscos =1./re

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

nk=2
zmax=4.5

itstep,nk,dz=np.load('itstep.npy')
#itstep=1900
#nk= 32
#dz= 0.00625
p2d=np.load('p_averaged.npy')/itstep
u2d=np.load('u_averaged.npy')/itstep
v2d=np.load('v_averaged.npy')/itstep
w2d=np.load('w_averaged.npy')/itstep
k2d=np.load('k_averaged.npy')/itstep
vis2d=np.load('vis_averaged.npy')/itstep
uu2d=np.load('uu_stress.npy')/itstep
vv2d=np.load('vv_stress.npy')/itstep
ww2d=np.load('ww_stress.npy')/itstep
uv2d=np.load('uv_stress.npy')/itstep
fk2d=np.load('fk_averaged.npy')/itstep
om2d=np.load('om_averaged.npy')/itstep

uu2d=uu2d-u2d**2
uv2d=uv2d-u2d*v2d


kres_2d=0.5*(uu2d+vv2d+ww2d)

vis2d=vis2d/viscos

jl0v_dist=np.zeros(ni)
jl0v=np.zeros(ni)
for i in range (0,ni-1):
   for j in range (0,nj-1):
     if fk2d[i,j+1] > 1.0:
        jl0v[i]=int(j)
        jl0v_dist[i]=yp2d[i,j]-yp2d[i,0]
        break

jl0v[0]=jl0v[1]
jl0v[-1]=jl0v[-1-1]
jl0v_dist[0]=jl0v_dist[0]
jl0v_dist[-1]=jl0v_dist[-1-1]



# compute cf
cf=np.zeros(ni)
ustarv=np.zeros(ni)
for i in range (0,ni-1):
     xt=x2d[i,0]-x2d[i-1,0]
     yt=y2d[i,0]-y2d[i-1,0]
     rl=(xt**2+yt**2)**0.5
     xt=xt/rl
     yt=yt/rl
     uwall=abs(u2d[i,0]*xt+v2d[i,0]*yt)
     xn=-yt
     yn=xt
     yp=0.5*abs((y2d[i,1]-y2d[i,0])*yn+(x2d[i,1]-x2d[i,1])*xn)
     ustar=(uwall*viscos/yp)**0.5
     ustars=(uwall*viscos/yp)**0.5*u2d[i,0]/abs(u2d[i,0])
     cf[i]=abs(ustars)*ustars/0.5

ustarv[0]=ustarv[1]

cf[0]=cf[1]

#  compute re_theta for boundary layer flow
dx=x[3]-x[2]
re_mom_bl=np.zeros(ni)
for i in range (0,ni-1):
   d_mom=0
   for j in range (1,nj-1):
      up=u2d[i,j]/u2d[i,-1]
      dy=y2d[i,j]-y2d[i,j-1]
      d_mom=d_mom+up*(1.-min(up,1.))*dy

   re_mom_bl[i]=d_mom*u2d[i,-1]/viscos

re_mom_bl[-1]=re_mom_bl[-1-1]

cf_exp_retheta=2*(1./0.384*np.log(re_mom_bl)+4.127)**(-2)

u_time_exists= os.path.isfile('u-time-history.dat')     
if u_time_exists:
#  u_time= np.loadtxt("u-time-history.dat")
# don'r read  last collumn
   u_time = np.genfromtxt('u-time-history.dat', usecols=[0,1,2,3,4,5,6], invalid_raise=False)
   u5=u_time[:,1]
   u10=u_time[:,2]
   u20=u_time[:,3]
   u30=u_time[:,4]
   u40=u_time[:,5]
   u50=u_time[:,6]
#  u60=u_time[:,7]




x065_off=np.genfromtxt("x065_off.dat", dtype=None,comments="%")
x080_off=np.genfromtxt("x080_off.dat", dtype=None,comments="%")
x090_off=np.genfromtxt("x090_off.dat", dtype=None,comments="%")
x100_off=np.genfromtxt("x100_off.dat", dtype=None,comments="%")
x110_off=np.genfromtxt("x110_off.dat", dtype=None,comments="%")
x120_off=np.genfromtxt("x120_off.dat", dtype=None,comments="%")
x130_off=np.genfromtxt("x130_off.dat", dtype=None,comments="%")

SPIV_avgvel_noflow_x100=np.genfromtxt("SPIV_avgvel_noflow_x100.dat", dtype=None,comments="%")
SPIV_avgvel_noflow_x110=np.genfromtxt("SPIV_avgvel_noflow_x110.dat", dtype=None,comments="%")
SPIV_avgvel_noflow_x120=np.genfromtxt("SPIV_avgvel_noflow_x120.dat", dtype=None,comments="%")
SPIV_avgvel_noflow_x130=np.genfromtxt("SPIV_avgvel_noflow_x130.dat", dtype=None,comments="%")

# exp
noflow_cf=np.genfromtxt("noflow_cp.dat", dtype=None,comments="%")
cp_exp=noflow_cf[:,1]
xp_exp=noflow_cf[:,0]

noflow_cp=np.genfromtxt("noflow_cf.dat", dtype=None,comments="%")
cf_exp=noflow_cp[:,1]
x_exp=noflow_cp[:,0]

cexp=420;
uin=34.6;

ymaxz=0.03




########################################## Cf bound
i=80
fig16,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
ax1.plot(re_mom_bl[0:i],cf[0:i],'b-')
plt.xlabel(r"$Re_\theta$")
plt.ylabel("$C_f$")
plt.axis([6000,7000,0.002,0.0055])
plt.savefig('cf-vs-re-theta.png')


########################################## Cf
fig16,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(xp2d[:,1],cf,'b-',2)
plt.plot(x_exp,cf_exp,'bo')
plt.xlabel("$x$")
plt.ylabel("$C_f$")
plt.axis([-0.5,1.5,-0.005,0.01])
plt.savefig('cfhump.png')



########################################## omega_wall
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.25,bottom=0.20)
# prescrirbed  wall b.c.
dy=0.5*(y2d[1:,1]-y2d[1:,0])
omega_wall=6*viscos/dy**2/0.075
plt.plot(xp2d[:,1],omega_wall,'b-',label="target$")
plt.plot(xp2d[:,1],om2d[:,0],'r--',label="value")
plt.legend(loc="upper right",prop=dict(size=18))
plt.xlabel('$x')
plt.ylabel(r"$\omega_{wall}$")
plt.savefig('omega-wall-vs-x.png')


########################################## cp
fig15,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
p0=p2d[14,1]
cp_org=(p2d[:,0]-p0)/0.5;
cp=cp_org+cp_exp[0];
plt.plot(xp2d[:,0],-cp,'b-')
plt.plot(xp_exp,-cp_exp,'bo')
plt.xlabel('x')
plt.ylabel('y')
plt.axis([-0.5,1.5,-.5,1])
plt.savefig('cphump.png')

########################################## cp 10-20-30-40-50
fig15,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
p0=p2d[14,1]

plt.plot(xp2d[:,0],-((p2d[:,10]-p0)/0.5+cp_exp[0]),'b-')
plt.plot(xp2d[:,0],-((p2d[:,20]-p0)/0.5+cp_exp[0]),'r--')
plt.plot(xp2d[:,0],-((p2d[:,30]-p0)/0.5+cp_exp[0]),'k-.')
plt.plot(xp2d[:,0],-((p2d[:,40]-p0)/0.5+cp_exp[0]),'g-')
plt.plot(xp2d[:,0],-((p2d[:,50]-p0)/0.5+cp_exp[0]),'g--')


plt.xlabel('x')
plt.ylabel('y')
plt.axis([-0.5,1.5,-.5,1])
plt.savefig('cphump-10-20-30-40-50.png')



########################################## U 065
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.65;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.plot(x065_off[:,2],x065_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("x")
plt.ylabel("y")
plt.title("065")
plt.axis([0, 1.3,0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax1, width="50%", height="50%", loc=2, borderpad=0.35)
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.axis([0, 1.3,0,0.01])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x065_off[:,2],x065_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')

plt.savefig('u065_hump.png')

########################################## U 080
fig2,ax2 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.80;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.plot(x080_off[:,2],x080_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("x")
plt.ylabel("y")
plt.title("080")
plt.axis([-0.3,1.3,0.,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax2, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.axis([-0.2,0.01,0.,0.01])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x080_off[:,2],x080_off[:,1],'bo',fillstyle='none')

plt.savefig('u080_hump.png')

########################################## U 090
fig3,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.90;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.plot(x090_off[:,2],x090_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("x")
plt.ylabel("y")
plt.title("090")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.axis([-0.3,0.01,0.,0.01])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x090_off[:,2],x090_off[:,1],'bo',fillstyle='none')

plt.savefig('u090_hump.png')

########################################## U 100
fig4,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.00;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.plot(x100_off[:,2],x100_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("x")
plt.ylabel("y")
plt.title("100")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.axis([-0.25,0.01,0.,0.01])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x100_off[:,2],x100_off[:,1],'bo',fillstyle='none')

plt.savefig('u100_hump.png')

########################################## U 110
fig5,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.10;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.plot(x110_off[:,2],x110_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("x")
plt.ylabel("y")
plt.title("110")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.axis([-0.08,0.01,0.,0.01])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x110_off[:,2],x110_off[:,1],'bo',fillstyle='none')

plt.savefig('u110_hump.png')

########################################## U 120
fig6,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.20;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.plot(x120_off[:,2],x120_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("x")
plt.ylabel("y")
plt.title("120")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.axis([0.,0.3,0.,0.01])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x120_off[:,2],x120_off[:,1],'bo',fillstyle='none')

plt.savefig('u120_hump.png')

########################################## U 130
fig7,ax3 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.30;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.plot(x130_off[:,2],x130_off[:,1]-yp2d[i1,0],'bo',fillstyle='none')
plt.xlabel("x")
plt.ylabel("y")
plt.title("130")
plt.axis([-0.3,1.3,0.0,0.2])

# Create inset of width 30% and height 40% of the parent axes' bounding box
# at the lower left corner (loc=3)
# upper left corner (loc=2)
# use borderpad=1, i.e.
# 22 points padding (as 22pt is the default fontsize) to the parent axes

axins1 = inset_axes(ax3, width="40%", height="40%", loc=2, borderpad=0.35)
plt.plot(u2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.axis([0.,0.4,0.,0.01])
# reduce fotnsize 
axins1.tick_params(axis = 'both', which = 'major', labelsize = 10)
axins1.yaxis.set_label_position("right")
axins1.yaxis.tick_right()

# Turn ticklabels of insets off
#axins1.tick_params(labelleft=False, labelbottom=False)

plt.plot(x130_off[:,2],x130_off[:,1],'bo',fillstyle='none')

plt.savefig('u130_hump.png')


########################################## vis 065
fig8,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.65;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.xlabel("x")
plt.ylabel("y")
plt.title("065")
plt.axis([0, 400,0,0.2])

plt.savefig('vis065_hump.png')


########################################## vis 080
fig9,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.80;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.xlabel("x")
plt.ylabel("y")
plt.title("080")
plt.axis([0, 1000.3,0,0.2])

plt.savefig('vis080_hump.png')


########################################## vis 090
fig10,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=0.90;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.xlabel("x")
plt.ylabel("y")
plt.title("090")
plt.axis([0, 1000,0,0.2])

plt.savefig('vis050_hump.png')


########################################## vis 100
fig11,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.00;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.xlabel("x")
plt.ylabel("y")
plt.title("100")
plt.axis([0, 1000,0,0.2])

plt.savefig('vis100_hump.png')


########################################## vis 110
fig12,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.10;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.xlabel("x")
plt.ylabel("y")
plt.title("110")
plt.axis([0, 1000,0,0.2])

plt.savefig('vis110_hump.png')


########################################## vis 120
fig13,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.20;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.xlabel("x")
plt.ylabel("y")
plt.title("120")
plt.axis([0, 1000,0,0.2])

plt.savefig('vis120_hump.png')


########################################## vis 130
fig14,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
xx=1.30;
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:]-yp2d[i1,0],'b-')
plt.xlabel("x")
plt.ylabel("y")
plt.title("140")
plt.axis([0, 1000,0,0.2])

plt.savefig('vis130_hump.png')


if u_time_exists:
########################################## u time
   fig1,ax1 = plt.subplots()
   plt.subplots_adjust(left=0.20,bottom=0.20)
   plt.plot(u5,'b-',label="$j=5$")
   plt.plot(u10,'r-',label="$j=10$")
   plt.plot(u20,'k-',label="$j=20$")
   plt.plot(u30,'b--',label="$j=30$")
   plt.plot(u40,'r--',label="$j=40$")
   plt.plot(u50,'k--',label="$j=50$")
#  plt.plot(u60,'g-',label="$j=60$")
#plt.legend()
   plt.xlabel('time step')
   plt.xlabel('$U$')
   plt.savefig('u_vs_time.png',bbox_inches='tight')



