import numpy as np
import sys


datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

zmax, nk=np.loadtxt('z.dat')

nk=np.int(nk)

# velocity
# load CALC results
b= np.loadtxt("u3d.dat")
u3d=b.reshape(nk,nj,ni).swapaxes(0,2)
b= np.loadtxt("v3d.dat")
v3d=b.reshape(nk,nj,ni).swapaxes(0,2)
b= np.loadtxt("w3d.dat")
w3d=b.reshape(nk,nj,ni).swapaxes(0,2)
b= np.loadtxt("p3d.dat")
p3d=b.reshape(nk,nj,ni).swapaxes(0,2)
b= np.loadtxt("k3d.dat")
k3d=b.reshape(nk,nj,ni).swapaxes(0,2)
b= np.loadtxt("om3d.dat")
om3d=b.reshape(nk,nj,ni).swapaxes(0,2)

vist=k3d/om3d

vismax=np.max(vist)
vmax=np.max(v3d)
re =9.36e+5
viscos =1./re

print('vismax/viscos',vismax/viscos)
print('vmax',vmax)

np.save('u3d_saved', u3d)
np.save('v3d_saved', v3d)
np.save('w3d_saved', w3d)
np.save('p3d_saved', p3d)
np.save('k3d_saved', k3d)
np.save('om3d_saved', om3d)

