import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from IPython import display
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})

plt.interactive(True)
global x2d,y2d,cyclic_x,cyclix_z,ni,nj,nk


# makes sure figures are updated when using ipython
display.clear_output(wait=True)

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

nk=32
zmax=4.5

viscos=1/10500

itstep,nk,dz=np.load('itstep.npy')
p2d=np.load('p_averaged.npy')/itstep
u2d=np.load('u_averaged.npy')/itstep
v2d=np.load('v_averaged.npy')/itstep
w2d=np.load('w_averaged.npy')/itstep
k2d=np.load('k_averaged.npy')/itstep
vis2d=np.load('vis_averaged.npy')/itstep
uu2d=np.load('uu_stress.npy')/itstep
vv2d=np.load('vv_stress.npy')/itstep
ww2d=np.load('ww_stress.npy')/itstep
uv2d=np.load('uv_stress.npy')/itstep
fk2d=np.load('fk_averaged.npy')/itstep
om2d=np.load('om_averaged.npy')/itstep
eps2d=np.load('eps_averaged.npy')/itstep

uu2d=uu2d-u2d**2
uv2d=uv2d-u2d*v2d


kres_2d=0.5*(uu2d+vv2d+ww2d)

vis2d=vis2d/viscos

# compute cf
cf=np.zeros(ni)
for i in range (0,ni-1):
     xt=x2d[i,0]-x2d[i-1,0]
     yt=y2d[i,0]-y2d[i-1,0]
     rl=(xt**2+yt**2)**0.5
     xt=xt/rl
     yt=yt/rl
     uwall=abs(u2d[i,1]*xt+v2d[i,1]*yt)
     xn=-yt
     yn=xt
     yp=abs((yp2d[i,1]-yp2d[i,0])*yn+(xp2d[i,1]-xp2d[i,0])*xn)
     ustar=(uwall*viscos/yp)**0.5
     ustars=(uwall*viscos/yp)**0.5*u2d[i,1]/abs(u2d[i,1])
     cf[i]=abs(ustars)*ustars/0.5


cf[0]=cf[1]

ubulk = np.trapz(u2d[0,:],yp2d[0,:])/(y2d[0,-1]-y2d[0,0])
print('ubulk',ubulk)

u2d = u2d/ubulk
v2d = v2d/ubulk
k2d = k2d/ubulk**2


# coarse DNS benchmark by Karlsruhe
# Wall resolving periodic hill : Re_b = 10595
# x/h = 1.0
#
# Note [1] : Ub is bulk velocity
# Note [2] : p_dyn = 0.5 * rho * Ub * Ub
# Note [3] : Ub2   = Ub * Ub
#
# y/h       U/Ub       V/Ub       p/p_dyn   uu/(Ub2)  vv/(Ub2)  ww/(Ub2)  uv/(Ub2)  kres/(Ub2) (nu_t)/(nu_mol)
DNS_x005h=np.genfromtxt("DNS_x005h.dat", dtype=None,comments="%")
DNS_x05h=np.genfromtxt("DNS_x05h.dat", dtype=None,comments="%")
DNS_1xh=np.genfromtxt("DNS_1xh.dat", dtype=None,comments="%")
DNS_2xh=np.genfromtxt("DNS_2xh.dat", dtype=None,comments="%")
DNS_3xh=np.genfromtxt("DNS_3xh.dat", dtype=None,comments="%")
DNS_4xh=np.genfromtxt("DNS_4xh.dat", dtype=None,comments="%")
DNS_5xh=np.genfromtxt("DNS_5xh.dat", dtype=None,comments="%")
DNS_6xh=np.genfromtxt("DNS_6xh.dat", dtype=None,comments="%")
DNS_7xh=np.genfromtxt("DNS_7xh.dat", dtype=None,comments="%")
DNS_8xh=np.genfromtxt("DNS_8xh.dat", dtype=None,comments="%")
DNS_cf=np.genfromtxt("DNS_cf.dat", dtype=None,comments="%")

x_DNS = DNS_cf[:,0]
cf_DNS = DNS_cf[:,1]


########################################## cf
fig1,ax1 = plt.subplots()
plt.plot(xp2d[:,0],cf,'b-')
plt.plot(x_DNS,cf_DNS,'r--')
plt.xlabel("$x$")
plt.ylabel("$C_F$")
#plt.axis([0, 1.2,0,3.1])

plt.savefig('cf_hill.png')


########################################## U 005h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=0.05
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_x005h[:,1],DNS_x005h[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=0.05$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u005_hill.png')


########################################## U 05h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=0.5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_x05h[:,1],DNS_x05h[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=0.5$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u05_hill.png')

########################################## U 1h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_1xh[:,1],DNS_1xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=1$")
plt.axis([-0.2, 1.2,0,3.1])

plt.savefig('u1_hill.png')

########################################## U 2h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_2xh[:,1],DNS_2xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=2$")
plt.axis([-0.3, 1.2,0,3.1])

plt.savefig('u2_hill.png')
########################################## U 3h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=3
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_3xh[:,1],DNS_3xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=3$")
plt.axis([-0.3, 1.2,0,3.1])

plt.savefig('u3_hill.png')
########################################## U 4h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=4
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_4xh[:,1],DNS_4xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=4$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u4_hill.png')
########################################## U 5h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_5xh[:,1],DNS_5xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=5$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u5_hill.png')
########################################## U 6h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=6
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_6xh[:,1],DNS_6xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=6$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u6_hill.png')
########################################## U 7h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=7
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_7xh[:,1],DNS_7xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=7$")
plt.axis([0, 1.2,0,3.1])

plt.savefig('u7_hill.png')
########################################## U 8h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=8
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(u2d[i1,:],yp2d[i1,:],'b-')
plt.plot(DNS_8xh[:,1],DNS_8xh[:,0],'bo',fillstyle='none')
plt.xlabel("$U$")
plt.ylabel("$y$")
plt.title("$x=8$")
plt.axis([0., 1.2,0,3.1])

plt.savefig('u8_hill.png')

#sys.exit()

########################################## vis 005h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=0.005
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=0.005$")
plt.axis([0, 20,0,3.1])

plt.savefig('vis005_hill.png')

########################################## vis 05h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=0.05
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=0.05$")
plt.axis([0, 20,0,3.1])

plt.savefig('vis05_hill.png')

########################################## vis 1h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=1
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=1$")
plt.axis([-0.2, 20,0,3.1])

plt.savefig('vis1_hill.png')

########################################## vis 2h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=2
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=2$")
plt.axis([-0.3, 20,0,3.1])

plt.savefig('vis2_hill.png')
########################################## vis 3h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=3
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=3$")
plt.axis([-0.3, 20,0,3.1])

plt.savefig('vis3_hill.png')
########################################## vis 4h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=4
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=4$")
plt.axis([0, 20,0,3.1])

plt.savefig('vis4_hill.png')
########################################## vis 5h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=5
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=5$")
plt.axis([0, 20,0,3.1])

plt.savefig('vis5_hill.png')
########################################## vis 6h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=6
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=6$")
plt.axis([0, 20,0,3.1])

plt.savefig('vis6_hill.png')
########################################## vis 7h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=7
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=7$")
plt.axis([0, 20,0,3.1])

plt.savefig('vis7_hill.png')
########################################## vis 8h
fig1,ax1 = plt.subplots()
plt.clf() #clear the figure
xx=8
i1 = (np.abs(xx-xp2d[:,1])).argmin()  # find index which closest fits xx
plt.plot(vis2d[i1,:],yp2d[i1,:],'b-')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y$")
plt.title("$x=8$")
plt.axis([0., 20,0,3.1])

plt.savefig('vis8_hill.png')

sys.exit()


plt.plot(x080_off[:,2],x080_off[:,1],'bo',fillstyle='none')

plt.savefig('vis080_hump.png')

