
def modify_init(u3d,v3d,w3d,k3d,om3d,eps3d,vis3d):
   
   return u3d,v3d,w3d,k3d,om3d,eps3d,vis3d, dist3d

def modify_inlet():

   return u_bc_west,v_bc_west,w_bc_west,k_bc_west,eps_bc_west,om_bc_west,u3d_face_w,convw

def modify_conv(convw,convs,convl):

   return convw,convs,convl

def modify_u(su3d,sp3d):

   taus=xp.sum(viscos*as_bound*u3d[:,0,:])
   taun=xp.sum(viscos*an_bound*u3d[:,-1,:])
   sumvol=xp.sum(vol)
   sumps=xp.sum(p3d[:,0,:]*areasx[:,0,:])
   uin=xp.sum(convw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
   total_forces=taus+taun+sumps

   beta=total_forces/sumvol
   Ub=1
   H=1
   beta = 1.079E-02*Ub/H

   su3d=su3d+beta*vol

   print('ubulk=%7.3E,taus=%7.3E,taan=%7.3E,sumps=%7.3E,beta=%7.3E' %(uin,taus,taun,sumps,beta))

   return su3d,sp3d

def modify_v(su3d,sp3d):

   return su3d,sp3d


def modify_w(su3d,sp3d):

   return su3d,sp3d

def modify_k(su3d,sp3d,gen):

   comm_term=xp.zeros((ni,nj,nk))

   return su3d,sp3d,comm_term

def modify_eps(su3d,sp3d):

   return su3d,sp3d

def modify_om(su3d,sp3d,comm_term):

   return su3d,sp3d

def fix_omega():

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d


def modify_outlet(convw):

   return convw,u_bc_east

def modify_fk(fk3d):

   global l_dist,l_max,l_iddes,rt,fmu,l_c,f_t,f_l,f_e1,l_u,l_tilde,f_d,f_e,f_b,f_dt,r_dt,r_dl,denom,f_l,f_t

   global f_e_mean,f_e1_mean,f_e2_mean,f_d_mean,f_dt_mean,f_dt_mean,f_b_mean,denom_mean,l_c_mean,l_tilde_mean,\
          f_l_mean,f_t_mean

   l_dist=0.15*dist3d
   l_max=0.15*delta_max
   dy=xp.diff(y2d[1:,:],axis=1)
# make it 3d
   dy=xp.repeat(dy[:,:,None],repeats=nk,axis=2)

   l_temp=xp.maximum(l_dist,l_max)
   l_temp=xp.maximum(l_temp,dy)
   l_iddes=xp.minimum(l_temp,delta_max)
#  l_iddes=xp.minimum(xp.maximum(l_dist,l_max,dy),delta_max)

   ueps=(eps3d*viscos)**0.25
   ystar=ueps*dist3d/viscos
   rt=k3d**2/eps3d/viscos
   fdampf2=((1.-xp.exp(-ystar/3.1))**2)*(1.-0.3*xp.exp(-(rt/6.5)**2))
   fmu=((1.-xp.exp(-ystar/14.))**2)*(1.+5./rt**0.75*xp.exp(-(rt/200.)**2))
   fmu=xp.minimum(fmu,1.)

   psi=xp.minimum(10,(fdampf2*fmu)**(-0.75))

   l_c=psi*cdes*l_iddes  #eq. 9

   vist=vis3d-viscos
   denom=kappa**2*dist3d**2*gen**0.5

   r_dt=vist/denom  #eq. 22
   r_dl=viscos/denom  #eq. 23

   f_t=xp.tanh((c_t**2*r_dt)**3)
   f_l=xp.tanh((c_l**2*r_dl)**10)

   f_e2=1.-xp.maximum(f_t,f_l) #eq. 19

   alpha=0.25-dist3d/delta_max

   f_e1=xp.where(alpha <= 0,2*xp.exp(-9*alpha**2),2*xp.exp(-11.09*alpha**2))

   f_b=  xp.minimum(2.*xp.exp(-9*alpha**2),1.)

   f_dt=1.-xp.tanh((8.*r_dt)**3)

   f_e=xp.maximum(f_e1-1.,0.)*psi*f_e2

   f_d=xp.maximum((1.-f_dt),f_b)

   l_u=k3d**1.5/eps3d

   l_tilde=f_d*(1+f_e)*l_u+(1-f_d)*l_c

   fk3d=l_u/l_tilde

#  l_tilde=f_d*l_u+(1-f_d)*l_c

#  fk3d=xp.minimum(fk3d,1.9/1.5)

   if iter == 0 and itstep ==0:
      f_e_mean=xp.zeros(nj)
      f_e1_mean=xp.zeros(nj)
      f_e2_mean=xp.zeros(nj)
      f_d_mean=xp.zeros(nj)
      f_dt_mean=xp.zeros(nj)
      f_b_mean=xp.zeros(nj)
      l_c_mean=xp.zeros(nj)
      l_tilde_mean=xp.zeros(nj)
      denom_mean=xp.zeros(nj)
      f_l_mean = xp.zeros(nj)
      f_t_mean = xp.zeros(nj)

   if iter == 0 and itstep%itstep_stats == 0 and itstep >= itstep_start:
      f_e_mean,f_d_mean,f_dt_mean,f_b_mean,denom_mean,f_e1_mean,f_e2_mean,l_c_mean,l_tilde_mean,\
          f_l_mean,f_t_mean=aver_iddes(denom,f_e,f_e1,f_e2,f_d,f_dt,f_b,l_c,l_tilde,\
          denom_mean,f_e_mean,f_e1_mean,f_e2_mean,f_d_mean,f_dt_mean,f_b_mean,l_c_mean,l_tilde_mean,\
          f_l_mean,f_t_mean)

   if iter == 0 and (itstep == ntstep-1 or itstep%itstep_save == 0):
      print('IDDES functions saved')
      xp.save('f_e_mean', f_e_mean)
      xp.save('f_d_mean', f_d_mean)
      xp.save('l_c_mean', l_c_mean)
      xp.save('f_dt_mean',f_dt_mean)
      xp.save('f_b_mean',f_b_mean)
      xp.save('f_e1_mean',f_e1_mean)
      xp.save('f_e2_mean',f_e2_mean)
      xp.save('l_tilde_mean',l_tilde_mean)
      xp.save('denom_mean',denom_mean)
      xp.save('f_l_mean', f_l_mean)
      xp.save('f_t_mean', f_t_mean)

   return fk3d

def aver_iddes(denom,f_e,f_e1,f_e2,f_d,f_dt,f_b,l_c,l_tilde,\
    denom_mean,f_e_mean,f_e1_mean,f_e2_mean,f_d_mean,f_dt_mean,f_b_mean,l_c_mean,l_tilde_mean,\
        f_l_mean,f_t_mean):

   f_e_mean=f_e_mean+xp.mean(f_e,axis=(0,2))
   f_e1_mean=f_e1_mean+xp.mean(f_e1,axis=(0,2))
   f_e2_mean=f_e2_mean+xp.mean(f_e2,axis=(0,2))
   f_d_mean=f_d_mean+xp.mean(f_d,axis=(0,2))
   l_c_mean=l_c_mean+xp.mean(l_c,axis=(0,2))
   l_tilde_mean=l_tilde_mean+xp.mean(l_tilde,axis=(0,2))
   f_dt_mean=f_dt_mean+xp.mean(f_dt,axis=(0,2))
   f_b_mean=f_b_mean+xp.mean(f_b,axis=(0,2))
   denom_mean=denom_mean+xp.mean(denom,axis=(0,2))
   f_l_mean=f_l_mean+xp.mean(f_l,axis=(0,2))
   f_t_mean=f_t_mean+xp.mean(f_t,axis=(0,2))

   return f_e_mean,f_d_mean,f_dt_mean,f_b_mean,denom_mean,f_e1_mean,f_e2_mean,\
       l_c_mean,l_tilde_mean,f_l_mean,f_t_mean

def fix_eps():

# south wall
   aw3d[:,0,:]=0
   ae3d[:,0,:]=0
   as3d[:,0,:]=0
   an3d[:,0,:]=0
   al3d[:,0,:]=0
   ah3d[:,0,:]=0
   ap_max=xp.max(ap3d)
   ap3d[:,0,:]=ap_max
   su3d[:,0,:]=ap_max*2*viscos*k3d[:,0,:]/dist3d[:,0,:]**2

# north wall
   aw3d[:,-1,:]=0
   ae3d[:,-1,:]=0
   as3d[:,-1,:]=0
   an3d[:,-1,:]=0
   al3d[:,-1,:]=0
   ah3d[:,-1,:]=0
   ap_max=xp.max(ap3d)
   ap3d[:,-1,:]=ap_max
   su3d[:,-1,:]=ap_max*2*viscos*k3d[:,-1,:]/dist3d[:,-1,:]**2

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def fix_k():

   global su3d1,sp3d1,ap3d1, fk3d1

   su3d1 = su3d
   sp3d1 = sp3d
   ap3d1 = ap3d
   fk3d1 = fk3d



   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d



def modify_vis(vis3d):

   return vis3d



