import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from IPython import display
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})


viscos=1/5200


# z grid
zmax, nk=np.loadtxt('z.dat')
nk=int(nk)
zp = np.linspace(0, zmax, nk)

name = "../hill-PANS-GPU/"

u3d=np.load(str(name)+'u3d_saved.npy')
v3d=np.load(str(name)+'v3d_saved.npy')
w3d=np.load(str(name)+'w3d_saved.npy')
p3d=np.load(str(name)+'p3d_saved.npy')
k3d=np.load(str(name)+'k3d_saved.npy')
eps3d=np.load(str(name)+'eps3d_saved.npy')

u3d_96=np.repeat(u3d, repeats=3, axis=2)
v3d_96=np.repeat(v3d, repeats=3, axis=2)
w3d_96=np.repeat(w3d, repeats=3, axis=2)
p3d_96=np.repeat(p3d, repeats=3, axis=2)
k3d_96=np.repeat(k3d, repeats=3, axis=2)
eps3d_96=np.repeat(eps3d, repeats=3, axis=2)


print('u3d_96.shape',u3d_96.shape)


np.save('u3d_saved', u3d_96)
np.save('v3d_saved', v3d_96)
np.save('w3d_saved', w3d_96)
np.save('p3d_saved', p3d_96)
np.save('k3d_saved', k3d_96)
np.save('eps3d_saved', eps3d_96)

