
def setup_case():
   import numpy as np
   import sys

# N.B. All variables that are set in this module must be included in the 'return' statement at the last line

########### section 0 choice of CPU or GPU ###################
   gpu = False

########### section 1 choice of differencing scheme ###########
   scheme='h'  #hybrid
   scheme_turb='u'  #hybrid upwind-central 
   acrank=1.0  # for pressure gradient
   acrank_conv=0.5  # for convection-diffusion
   acrank_conv_kom=1  # for convection-diffusion
   acrank_conv_keps=1  # for convection-diffusion
#  scheme_turb='h'  #hybrid upwind-central 


########### section 2 turbulence models ###########
   cmu=0.09
   pans = False
   keps = True
   kom_des = False
   keps_des = False
   kom = False
   wale = False
   smag = False
   c_eps_1=1.5
   c_eps_2=1.9
   cmu=0.09
   c_omega_1= 5./9.
   c_omega_2=3./40.
   prand_omega=2.0
   prand_eps=1.4
   prand_k=1.4
   jl0=0

   if keps:
      prand_k=1.4 

   if pans:
      prand_k=-1.4 # will be multiplied by fk3d in coeff()
      prand_eps=-1.4 # will be multiplied by fk3d in coeff()

   if kom or kom_des:
      prand_k=2.0
   if smag:
      cmu=0.1

########### section 3 restart/save ###########
   restart = False
   save = True

########### section 4 fluid properties ###########
   viscos=1/950

########### section 5 relaxation factors ###########
   urfvis=0.5

########### section 6 number of iteration and convergence criterira ###########
   maxit=5
   min_iter=1
   sormax=1e-3

   amg_relax='default'
   solver_vel='lgmres'
   solver_turb='lgmres'
   amg_relax='fgmres'
   amg_cycle='F'
   nsweep_vel=50
   nsweep_keps=50
   nsweep_kom=50
   convergence_limit_u=1e-5
   convergence_limit_v=1e-5
   convergence_limit_w=1e-5
   convergence_limit_eps=1e-4
   convergence_limit_k=1e-4
   convergence_limit_om=1e-8
   convergence_limit_p=5e-4

########### section 7 all variables are printed during the iteration at node ###########
   imon=0
   jmon=0
   kmon=0

########### section 8 time-averaging ###########
   ntstep=1000
   uin=20
   dt=4*(x2d[1,0]-x2d[0,0])*xp.ones(ntstep)/uin
   itstep_start=ntstep-100
   itstep_save=2000  # save every itstep_save timestep
   itstep_stats=1 # time average every itstep_stats timestep
   vtk=True


########### section 9 residual scaling parameters ###########
   resnorm_p=uin*zmax*y2d[1,-1]
   resnorm_vel=uin**2*zmax*y2d[1,-1]


########### Section 10 boundary conditions ###########
   cyclic_x = True
   cyclic_z = False

# synthetic inlet fluct
   L_t_synt=0.2
   nmodes_synt=150
   jmirror_synt=int(nj/2) # mirror vsynt at node jmirror; jmirror=0 means no mirroring
   dmin_synt=dz/2

# boundary conditions for u
   u_bc_west=xp.zeros((nj,nk))
   u_bc_east=xp.zeros((nj,nk))
   u_bc_south=xp.zeros((ni,nk))
   u_bc_north=xp.zeros((ni,nk))
   u_bc_low=xp.zeros((ni,nj))
   u_bc_high=xp.zeros((ni,nj))

   u_bc_west_type='d' 
   u_bc_east_type='n' 
   u_bc_south_type='d'
   u_bc_north_type='d'
   u_bc_low_type='n'
   u_bc_high_type='n'


# boundary conditions for v
   v_bc_west=xp.zeros((nj,nk))
   v_bc_east=xp.zeros((nj,nk))
   v_bc_south=xp.zeros((ni,nk))
   v_bc_north=xp.zeros((ni,nk))
   v_bc_low=xp.zeros((ni,nj))
   v_bc_high=xp.zeros((ni,nj))

   v_bc_west_type='d' 
   v_bc_east_type='n' 
   v_bc_south_type='d'
   v_bc_north_type='d'
   v_bc_low_type='n'
   v_bc_high_type='n'

# boundary conditions for w
   w_bc_west=xp.zeros((nj,nk))
   w_bc_east=xp.zeros((nj,nk))
   w_bc_south=xp.zeros((ni,nk))
   w_bc_north=xp.zeros((ni,nk))
   w_bc_low=xp.zeros((ni,nj))
   w_bc_high=xp.zeros((ni,nj))

   w_bc_west_type='d' 
   w_bc_east_type='n' 
   w_bc_south_type='d'
   w_bc_north_type='d'
   w_bc_low_type='d'
   w_bc_high_type='d'

# boundary conditions for p
   p_bc_west=xp.zeros((nj,nk))
   p_bc_east=xp.zeros((nj,nk))
   p_bc_south=xp.zeros((ni,nk))
   p_bc_north=xp.zeros((ni,nk))
   p_bc_low=xp.zeros((ni,nj))
   p_bc_high=xp.zeros((ni,nj))

   p_bc_west_type='n'
   p_bc_east_type='n'
   p_bc_south_type='n'
   p_bc_north_type='n'
   p_bc_low_type='n'
   p_bc_high_type='n'

# boundary conditions for k
   k_bc_west=xp.zeros((nj,nk))
   k_bc_east=xp.zeros((nj,nk))
   k_bc_south=xp.zeros((ni,nk))
   k_bc_north=xp.zeros((ni,nk))
   k_bc_low=xp.zeros((ni,nj))
   k_bc_high=xp.zeros((ni,nj))

   k_bc_west_type='d'
   k_bc_east_type='d'
   k_bc_south_type='d'
   k_bc_north_type='d'
   k_bc_low_type='n'
   k_bc_high_type='n'

# boundary conditions for eps
   eps_bc_west=xp.zeros((nj,nk))
   eps_bc_east=xp.zeros((nj,nk))
   eps_bc_south=xp.zeros((ni,nk))
   eps_bc_north=xp.zeros((ni,nk))
   eps_bc_low=xp.zeros((ni,nj))
   eps_bc_high=xp.zeros((ni,nj))

   eps_bc_west_type='d'
   eps_bc_east_type='d'
   eps_bc_south_type='d' 
   eps_bc_north_type='d' 
   eps_bc_low_type='n'
   eps_bc_high_type='n'

# boundary conditions for omega
   om_bc_west=xp.zeros((nj,nk))
   om_bc_east=xp.zeros((nj,nk))
   om_bc_south=xp.zeros((ni,nk))
   om_bc_north=xp.zeros((ni,nk))
   om_bc_low=xp.zeros((ni,nj))
   om_bc_high=xp.zeros((ni,nj))

   xwall_s=0.5*(x2d[0:-1,0]+x2d[1:,0])
   ywall_s=0.5*(y2d[0:-1,0]+y2d[1:,0])
   dist2_s=(yp2d[:,0]-ywall_s)**2+(xp2d[:,0]-xwall_s)**2
   om_bc_south=6*viscos/c_omega_2/dist2_s

# make it 2D
   om_bc_south=xp.repeat(om_bc_south[:,None], repeats=nk, axis=1)

   xwall_n=0.5*(x2d[0:-1,-1]+x2d[1:,-1])
   ywall_n=0.5*(y2d[0:-1,-1]+y2d[1:,-1])
   dist2_n=(yp2d[:,-1]-ywall_n)**2+(xp2d[:,-1]-xwall_n)**2
   om_bc_north=6*viscos/c_omega_2/dist2_n

# make it 2D
   om_bc_north=xp.repeat(om_bc_north[:,None], repeats=nk, axis=1)

   om_bc_west_type='d'
   om_bc_east_type='n'
   om_bc_south_type='d'
   om_bc_north_type='d'
   om_bc_low_type='n'
   om_bc_high_type='n'

   return 


