import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from IPython import display
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})

plt.interactive(True)

viscos=1/5200

# makes sure figures are updated when using ipython
display.clear_output(wait=True)

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

y=yp2d[1,:]
nk=32
zmax=1.6
# z grid
zmax, nk=np.loadtxt('z.dat')
nk=int(nk)
zp = np.linspace(0, zmax, nk)



itstep,nk,dz=np.load('itstep.npy')
p2d=np.load('p_averaged.npy')/itstep
u2d=np.load('u_averaged.npy')/itstep
v2d=np.load('v_averaged.npy')/itstep
w2d=np.load('w_averaged.npy')/itstep
k2d=np.load('k_averaged.npy')/itstep
vis2d=np.load('vis_averaged.npy')/itstep
uu2d=np.load('uu_stress.npy')/itstep
vv2d=np.load('vv_stress.npy')/itstep
ww2d=np.load('ww_stress.npy')/itstep
uv2d=np.load('uv_stress.npy')/itstep
fk2d=np.load('fk_averaged.npy')/itstep
om2d=np.load('om_averaged.npy')/itstep

uu2d=uu2d-u2d**2
uv2d=uv2d-u2d*v2d



u=np.mean(u2d,axis=0)
om=np.mean(om2d,axis=0)
k=np.mean(k2d,axis=0)
vis=np.mean(vis2d,axis=0)

dudy=np.gradient(u,y)
uv=-vis*dudy

DNS_mean=np.genfromtxt("LM_Channel_5200_mean_prof.dat",comments="%")
y_DNS=DNS_mean[:,0];
yplus_DNS=DNS_mean[:,1];
u_DNS=DNS_mean[:,2];

DNS_stress=np.genfromtxt("LM_Channel_5200_vel_fluc_prof.dat",comments="%")
u2DNS=DNS_stress[:,2];
v2DNS=DNS_stress[:,3];
w2DNS=DNS_stress[:,4];
uvDNS=DNS_stress[:,5];


k_DNS=0.5*(u2DNS+v2DNS+w2DNS)

ustar=(viscos*u[0]/y[0])**0.5

yplus=y*ustar/viscos

# find equi.distant DNS cells in log-scale
xx=0.
jDNS=[1]*40
for i in range (0,40):
   i1 = (np.abs(10.**xx-yplus_DNS)).argmin()
   jDNS[i]=int(i1)
   xx=xx+0.2

# save profiles on disk
dudy=np.gradient(u,y)
uv=-vis*dudy

np.savetxt('y_u_k_om_uv_5200.txt', np.c_[y,u,k,om,uv])

u_time= np.loadtxt("u-time-history.dat")

u5=u_time[:,1]
u10=u_time[:,2]
u20=u_time[:,3]
u30=u_time[:,4]
u40=u_time[:,5]
u50=u_time[:,6]
u60=u_time[:,7]



########################################## U  log
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.semilogx(yplus,u,'b-')
plt.semilogx(yplus_DNS[jDNS],u_DNS[jDNS],'bo')
plt.ylabel("$U^+$")
plt.xlabel("$y^+$")
plt.axis([1, 5200, 0, 28])
plt.savefig('u_log_python.png',bbox_inches='tight')


########################################## U lin
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(u,y,'b-')
plt.plot(u_DNS[jDNS],y_DNS[jDNS],'bo')
plt.xlabel("$U^+$")
plt.ylabel("$y^+$")
plt.axis([0, 28, 0, 2])
plt.savefig('u_lin_python.png',bbox_inches='tight')


########################################## k 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yplus,k,'b-')
plt.plot(yplus_DNS[jDNS],k_DNS[jDNS],'bo')
plt.ylabel(r"$k$")
plt.xlabel("$y^+$")
plt.axis([1, 5200, 0, 11])
plt.savefig('k_python.png',bbox_inches='tight')


########################################## omega 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yplus,om,'b-')
#plt.plot(yplus_DNS[jDNS],k_DNS[jDNS],'bo')
plt.ylabel(r"$\omega$")
plt.xlabel("$y^+$")
plt.axis([1, 5200, 0, 2000])
plt.savefig('omega_python.png',bbox_inches='tight')


########################################## uv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yplus,uv,'b-')
plt.plot(yplus_DNS[jDNS],uvDNS[jDNS],'bo')
plt.ylabel(r"$\overline{u'v'}$")
plt.xlabel("$y^+$")
plt.axis([1, 5200, -1, 0])
plt.savefig('uv_python.png',bbox_inches='tight')



########################################## u time
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(u5,'b-',label="$j=5$")
plt.plot(u10,'r-',label="$j=10$")
plt.plot(u20,'k-',label="$j=20$")
plt.plot(u30,'b--',label="$j=30$")
plt.plot(u40,'r--',label="$j=40$")
plt.plot(u50,'k--',label="$j=50$")
plt.plot(u60,'g-',label="$j=60$")
#plt.legend()
plt.xlabel('time step')
plt.ylabel('$U$')
plt.savefig('u_vs_time.png',bbox_inches='tight')




