
def modify_init(u3d,v3d,w3d,k3d,om3d,eps3d,vis3d):
   
   data=xp.loadtxt('y_u_k_om_uv_5200_nj96.txt')

   u_rans=data[:,1]
# make it 2D
   u_rans=xp.repeat(u_rans[:,None], repeats=nk, axis=1)


   k_rans=data[:,2]
# make it 2D
   k_rans=xp.repeat(k_rans[:,None], repeats=nk, axis=1)

   om_rans=data[:,3]
# make it 2D
   om_rans=xp.repeat(om_rans[:,None], repeats=nk, axis=1)

# make it 3D
   om_rans_3d=xp.repeat(om_rans[None,:,:], repeats=ni, axis=0)

# set inlet field in entire domain
   u3d=xp.repeat(u_rans[None,:,:], repeats=ni, axis=0)
   k3d=0.2*xp.repeat(k_rans[None,:,:], repeats=ni, axis=0)
   om3d=om_rans_3d

   vis3d=k3d/om3d+viscos

   print('xp.max(vis3d)/viscos',xp.max(vis3d)/viscos)

   return u3d,v3d,w3d,k3d,om3d,eps3d,vis3d,dist3d

def modify_inlet():

   global y_rans,y_rans,u_rans,v_rans,k_rans,om_rans,uv_rans,zp,a_synt,b_synt,usynt_inlet,vsynt_inlet,wsynt_inlet,\
          uu_synt,vv_synt,ww_synt,uv_synt,two_corr,u_time,uv_aver,w_synt,k_bc_west,eps_bc_west,om_bc_west
  
   global usynt,vsynt,wsynt

   if itstep == 0:
      two_corr=xp.zeros(2*nk-1)
      uv_aver=0
      u_time=xp.zeros(ntstep)
      y_u_k_om=xp.loadtxt('y_u_k_om_uv_5200_nj96.txt')
      y_rans=y_u_k_om[:,0]
      u_rans=y_u_k_om[:,1]
# make it 2D
      u_rans=xp.repeat(u_rans[:,None], repeats=nk, axis=1)
      k_rans=y_u_k_om[:,2]
# make it 2D
      k_rans=xp.repeat(k_rans[:,None], repeats=nk, axis=1)
      om_rans=y_u_k_om[:,3]
# make it 2D
      om_rans=xp.repeat(om_rans[:,None], repeats=nk, axis=1)

      uv_rans=xp.abs(y_u_k_om[:,4])

# z grid
      zp = xp.linspace(0, zmax, nk)
      usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
      if gpu:
         usynt = xp.asarray(usynt)
         vsynt = xp.asarray(vsynt)
         wsynt = xp.asarray(wsynt)
# correct usynt so that it is = 0 (easier to converge the p solver)
      uinc=xp.sum(usynt*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
      usynt=usynt-uinc
      usynt_inlet=usynt
      vsynt_inlet=vsynt
      wsynt_inlet=wsynt
      uin=xp.sum(u_rans*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
# tturb from ustar=1
      tturb=L_t_synt/1
      a_synt=xp.exp(-dt[itstep]/tturb)
      b_synt=(1.-a_synt**2)**0.5
      print('uin,a_synt,b_synt,tturb',uin,a_synt,b_synt,tturb)
      uu_synt=xp.zeros(nj)
      vv_synt=xp.zeros(nj)
      ww_synt=xp.zeros(nj)
      uv_synt=xp.zeros(nj)

      k_bc_west=k_rans
      om_bc_west=om_rans


   usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
   if gpu:
      usynt = xp.asarray(usynt)
      vsynt = xp.asarray(vsynt)
      wsynt = xp.asarray(wsynt)
# correct usynt so that it is = 0 (easier to converge the p solver)
   uinc=xp.sum(usynt*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
   usynt=usynt-uinc
   usynt_inlet=a_synt*usynt_inlet+b_synt*usynt
   vsynt_inlet=a_synt*vsynt_inlet+b_synt*vsynt
   wsynt_inlet=a_synt*wsynt_inlet+b_synt*wsynt
   u_bc_west=u_rans+usynt_inlet
   v_bc_west=vsynt_inlet
   w_bc_west=wsynt_inlet


   uu_synt=uu_synt+xp.mean(usynt**2,axis=1)
   vv_synt=vv_synt+xp.mean(vsynt**2,axis=1)
   ww_synt=ww_synt+xp.mean(wsynt**2,axis=1)
   uv_synt=uv_synt+xp.mean(usynt*vsynt,axis=1)

# update face velocity and convw at inlet
#  u3d_face_w[0,:,:]=u_bc_west
#  convw[0,:,:]=-u_bc_west*areawx[0,:,:]-v_bc_west*areawy[0,:,:]

# compute two-point corr in node 10
   two_corr=two_corr+xp.correlate(w_bc_west[10,:],w_bc_west[10,:],'full')

# sum over timesteps
   uv_aver=uv_aver+xp.mean(u_bc_west[58,:]*v_bc_west[58,:])

# compute average
   if itstep % 100 == 0:
      xp.save('two_corr_inlet',two_corr)
      xp.save('u_time',u_time)
      xp.save('uu_synt',uu_synt/(itstep+1))
      xp.save('uv_synt',uv_synt/(itstep+1))
      print('uvmean_aver at max',uv_aver/(itstep+1))

   return u_bc_west,v_bc_west,w_bc_west,k_bc_west,eps_bc_west,om_bc_west,u3d_face_w,convw

def modify_conv(convw,convs,convl):

   convs[:,0,:]=0
   convs[:,-1,:]=0

   return convw,convs,convl

def modify_u(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*u_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*u_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound



   return su3d,sp3d


def modify_v(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*v_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*v_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound



   return su3d,sp3d


def modify_w(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+convw[0,:,:]*w_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*w_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound



   return su3d,sp3d


def modify_k(su3d,sp3d,gen):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*k_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*k_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   comm_term=xp.zeros((nj,nk))

# commuation term at inlet
   delt_i1=0.09**(-0.25)*k3d[0,:,:]**0.5/om3d[0,:,:]
   delt_i2=vol[0,:,:]**0.333333
   flux_k_RANS=u3d[0,:,:]*k3d[0,:,:]
   vis_smag= (0.1 *delt_i2)**2*gen[0,:,:]**0.5
   rk_smag=(vis_smag/delt_i2)**2
   flux_k_LES=u3d[0,:,:]*rk_smag
   delt_LES=delt_i2
   delt_RANS=delt_i1
   dx=x2d[1,0]-x2d[0,0]
   comm_term=(flux_k_LES-flux_k_RANS)/(delt_LES-delt_RANS)*(delt_i2-delt_i1)/dx
   sp3d[0,:,:]=sp3d[0,:,:]+xp.minimum(comm_term,0.)*vol[0,:,:]/k3d[0,:,:]

   return su3d,sp3d,comm_term

def modify_eps(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*eps_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*eps_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d

def modify_om(su3d,sp3d,comm_term):

#        t_kolmog=6.*(viscos/0.09/phi(i,j,k,om)/phi(i,j,k,te))**0.5
#        t_scale=max(1./0.09/phi(i,j,k,om),t_kolmog)
   prod_extra=-om3d[0,:,:]/k3d[0,:,:]*comm_term
   su3d[0,:,:]=su3d[0,:,:]+xp.maximum(prod_extra,0.)*vol[0,:,:]

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*om_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-convw[0,:,:]
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*om_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound


   return su3d,sp3d

def modify_outlet(convw):

# inlet
   flow_in=xp.sum(convw[0,:,:])
   flow_out=xp.sum(convw[-1,:,:])
   area_out=xp.sum(areaw[-1,:,:])

   uinc=(flow_in-flow_out)/area_out
   ares=areaw[-1,:,:]
   convw[-1,:,:]=convw[-1,:,:]+uinc*ares

   print('area_out',area_out)

   flow_out_new=xp.sum(convw[-1,:,:])

   print('flow_in',flow_in,'flow_out',flow_out,'area_out',area_out,'flow_out_new',flow_out_new,'uinc:',uinc)

   return convw,u_bc_east

def modify_fk(fk3d):

   return fk3d

def fix_k():

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def fix_omega():

   aw3d[:,0,:]=0
   ae3d[:,0,:]=0
   as3d[:,0,:]=0
   an3d[:,0,:]=0
   al3d[:,0,:]=0
   ah3d[:,0,:]=0
   ap_max=xp.max(ap3d)
   ap3d[:,0,:]=ap_max
   su3d[:,0,:]=ap_max*om_bc_south


   aw3d[:,-1,:]=0
   ae3d[:,-1,:]=0
   as3d[:,-1,:]=0
   an3d[:,-1,:]=0
   al3d[:,-1,:]=0
   ah3d[:,-1,:]=0
   ap_max=xp.max(ap3d)
   ap3d[:,-1,:]=ap_max
   su3d[:,-1,:]=ap_max*om_bc_north

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def fix_eps():

   return aw3d,ae3d,as3d,an3d,al3d,ah3d,ap3d,su3d,sp3d

def modify_vis(vis3d):

   return vis3d



