import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from IPython import display
plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})

plt.interactive(True)

viscos=1/500


# makes sure figures are updated when using ipython
display.clear_output(wait=True)

datax= np.loadtxt("x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt("y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])

nk=32
zmax=1.6
# z grid
zmax, nk=np.loadtxt('z.dat')
nk=int(nk)
zp = np.linspace(0, zmax, nk)

itstep,nk,dz=np.load('itstep.npy')
p2d=np.load('p_averaged.npy')/itstep
u2d=np.load('u_averaged.npy')/itstep
v2d=np.load('v_averaged.npy')/itstep
w2d=np.load('w_averaged.npy')/itstep
k2d=np.load('k_averaged.npy')/itstep
vis2d=np.load('vis_averaged.npy')/itstep
uu2d=np.load('uu_stress.npy')/itstep
vv2d=np.load('vv_stress.npy')/itstep
ww2d=np.load('ww_stress.npy')/itstep
uv2d=np.load('uv_stress.npy')/itstep
fk2d=np.load('fk_averaged.npy')/itstep
om2d=np.load('om_averaged.npy')/itstep

uu2d=uu2d-u2d**2
uv2d=uv2d-u2d*v2d

k2d=0.5*(uu2d+vv2d+ww2d)

vis2d=vis2d/viscos


u=np.mean(u2d,axis=0)
uu=np.mean(uu2d,axis=0)
vv=np.mean(vv2d,axis=0)
ww=np.mean(ww2d,axis=0)
uv=np.mean(uv2d,axis=0)
k=np.mean(k2d,axis=0)


ustar=(viscos*u[0]/yp2d[1,0])**0.5
yplus=yp2d[1,:]*ustar/viscos

#       y/h             y+              U+             u'+             v'+             w'+           -Om_z+          om_x'+           om_y'+           om_z'+         uv'+             uw'+           vw'+             pr'+            ps'+          psto'+            p'
DNS_mean=np.genfromtxt("Re550.dat",comments="%")
y_exp=DNS_mean[:,0]
yplus_DNS=DNS_mean[:,1]
u_DNS=DNS_mean[:,2]
u2_DNS=DNS_mean[:,3]**2
v2_DNS=DNS_mean[:,4]**2
w2_DNS=DNS_mean[:,5]**2
uv_DNS=DNS_mean[:,10]

k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS)

k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS)

# find equi.distant DNS cells in log-scale
xx=0.
jDNS=[1]*40
for i in range (0,40):
   i1 = (np.abs(10.**xx-yplus_DNS)).argmin()
   jDNS[i]=int(i1)
   xx=xx+0.2


########################################## U 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.semilogx(yplus,u,'b-')
plt.semilogx(yplus_DNS[jDNS],u_DNS[jDNS],'bo')
plt.ylabel("$U^+$")
plt.xlabel("$y^+$")
plt.axis([1, 500, 0, 28])
plt.savefig('u_log_python.eps',bbox_inches='tight')


########################################## uu 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yplus,uu,'b-')
plt.plot(yplus_DNS[jDNS],u2_DNS[jDNS],'bo')
plt.ylabel(r"$\overline{u'u'}$")
plt.xlabel("$y^+$")
plt.axis([1, 500, 0, 11])
plt.savefig('uu_python.eps',bbox_inches='tight')



########################################## vv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yplus,vv,'b-')
plt.plot(yplus_DNS[jDNS],v2_DNS[jDNS],'bo')
plt.ylabel(r"$\overline{v'v'}$")
plt.xlabel("$y^+$")
plt.axis([1, 500, 0, 2])
plt.savefig('vv_python.eps',bbox_inches='tight')



########################################## ww 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yplus,ww,'b-')
plt.plot(yplus_DNS[jDNS],w2_DNS[jDNS],'bo')
plt.ylabel(r"$\overline{w'w'}$")
plt.xlabel("$y^+$")
plt.axis([1, 500, 0, 2])
plt.savefig('ww_python.eps',bbox_inches='tight')



########################################## uv 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 0
plt.plot(yplus,uv,'b-')
plt.plot(yplus_DNS[jDNS],uv_DNS[jDNS],'bo')
plt.ylabel(r"$\overline{u'v'}$")
plt.xlabel("$y^+$")
plt.axis([1, 500, -1, 0])
plt.savefig('uv_python.eps',bbox_inches='tight')





