import numpy as np
import time,random,sys
from scipy.signal import welch, hann
import matplotlib.pyplot as plt
import math

y_u_k_om=np.loadtxt('y_u_k_om_5200_nj98.dat')
y_rans=y_u_k_om[:,0]
u_rans=y_u_k_om[:,1]
k_rans=y_u_k_om[:,2]
om_rans=y_u_k_om[:,3]
vis_rans=k_rans/om_rans
nj=len(y_rans)
viscos=1/395
dudy=np.gradient(u_rans,y_rans)
uv_rans=np.abs(-(vis_rans-viscos)*dudy)
nk=32
nj=80
# z grid
zmax, nk=np.loadtxt('z.dat')
nk=np.int(nk)
dz=zmax/nk
zp = np.linspace(0, zmax, nk)

imax=min(20,nk)
u=np.zeros((nj,nk))
v=np.zeros((nj,nk))
w=np.zeros((nj,nk))
uu=np.zeros(nj)
vv=np.zeros(nj)
ww=np.zeros(nj)
uv=np.zeros(nj)
umean=np.zeros(nj)
vmean=np.zeros(nj)
two=np.zeros(2*nk-1)
imax=min(20,nk)
ntstep=3000
u_time=np.zeros(ntstep)
dt=1.172E-03 
L_t=0.2
t = np.linspace(0, ntstep*dt, ntstep)
ubulk=16
tturb=L_t/ubulk
a=0.9
b=(1-a**2)**0.5
j=10
for it in range(1,ntstep):
   file_name='/chalmers/users/lada/cit_kurser/calc-les-2020-test/channel-395-inlet/uvwp_' + str(it) + '.dat'
   print('file: ',file_name)
   data=np.loadtxt(file_name)
   u=data[:,0]
   v=data[:,1]
   w=data[:,2]
   u2d=np.reshape(u,(nj,nk))
   v2d=np.reshape(v,(nj,nk))
   w2d=np.reshape(w,(nj,nk))

   umean=umean+np.mean(u2d,axis=1)/ntstep
   vmean=vmean+np.mean(v2d,axis=1)/ntstep
   uu=uu+np.mean(u2d**2,axis=1)/ntstep
   vv=vv+np.mean(v2d**2,axis=1)/ntstep
   ww=ww+np.mean(w2d**2,axis=1)/ntstep
   uv=uv+np.mean(u2d*v2d,axis=1)/ntstep

   u_time[it]=w2d[j,10]

# compute two-point corr
   two=two+np.correlate(w2d[j,:],w2d[j,:],'full')


##### two-point correlation
uu=uu-umean**2
uv=uv-umean*vmean
# find max
nmax=np.argmax(two)
# and its value
two_max=np.max(two)
# two_max is symmetric. Pick the right half and normalize
two_sym_norm=two[nmax:]/two_max

#### auto-correlation
auto_uu=np.correlate(u_time,u_time,'full')
nmax_auto=np.argmax(auto_uu)
# and its value
auto_max=np.max(auto_uu)
# two_max is symmetric. Pick the right half and normalize
auto_sym_norm=auto_uu[nmax_auto:]/auto_max

########################
fig1 = plt.figure("Figure 1")
plt.plot(t,auto_sym_norm,'r-')
plt.plot(t,auto_sym_norm,'ro')
plt.xlabel('time')
plt.ylabel('auto-corr')
plt.title('synt-fluct')
plt.axis([0,1,-0.2,1.1])
plt.savefig('auto_uu_synt_fluct_from-calc-les-python.eps')

########################
fig2 = plt.figure("Figure 2")
plt.plot(zp[0:imax],two_sym_norm[0:imax],'r-')
plt.plot(zp[0:imax],two_sym_norm[0:imax],'ro')
plt.xlabel('zeta')
plt.ylabel('two-uu')
plt.title('synt-fluct')
plt.axis([0,0.7,-0.2,1.1])
plt.savefig('two_uu_synt_fluct_from-calc-les-python.eps')

########################
fig3 = plt.figure("Figure 3")
plt.plot(uu,y_rans,'b-')
plt.plot(vv,y_rans,'r--')
plt.plot(ww,y_rans,'k-.')
plt.plot(uv,y_rans,'g-')
plt.xlabel('j')
plt.ylabel('stresses')
plt.savefig('stresses_from-calc-les-python.eps')

