
def modify_init(u3d,v3d,w3d,k3d,om3d,eps3d,vis3d):
   
   data=xp.loadtxt('y_u_k_om_uv_395_DNS-python.txt')

   u_rans=data[:,1]
# make it 2D
   u_rans=xp.repeat(u_rans[:,None], repeats=nk, axis=1)

# set inlet field in enitre domain
   u3d=xp.repeat(u_rans[None,:,:], repeats=ni, axis=0)

   return u3d,v3d,w3d,k3d,om3d,eps3d,vis3d,dist3d

def modify_inlet():

   global y_rans,y_rans,u_rans,v_rans,k_rans,om_rans,uv_rans,zp,a_synt,b_synt,usynt_inlet,vsynt_inlet,wsynt_inlet,\
          uu_synt,vv_synt,ww_synt,uv_synt,two_corr,u_time,w_synt,k_bc_west,eps_bc_west
  
   global usynt,vsynt,wsynt

   if itstep == 0:
      two_corr=xp.zeros(2*nk-1)
      u_time=xp.zeros(ntstep)
      y_u_k_om=xp.loadtxt('y_u_k_om_uv_395_DNS-python.txt')
      y_rans=y_u_k_om[:,0]
      u_rans=y_u_k_om[:,1]
# make it 2D
      u_rans=xp.repeat(u_rans[:,None], repeats=nk, axis=1)

      uv_rans=xp.abs(y_u_k_om[:,4])

# z grid
      zp = xp.linspace(0, zmax, nk)
      usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
# correct usynt so that it is = 0 (easier to converge the p solver)
      uinc=xp.sum(usynt*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
      usynt=usynt-uinc
      usynt_inlet=usynt
      vsynt_inlet=vsynt
      wsynt_inlet=wsynt
      uin=xp.sum(u_rans*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
# tturb from ustar=1
      tturb=L_t_synt/1
      a_synt=xp.exp(-dt[itstep]/tturb)
      b_synt=(1.-a_synt**2)**0.5
      print('uin,a_synt,b_synt,tturb',uin,a_synt,b_synt,tturb)
      uu_synt=xp.zeros(nj)
      vv_synt=xp.zeros(nj)
      ww_synt=xp.zeros(nj)
      uv_synt=xp.zeros(nj)

   usynt,vsynt,wsynt=synt_fluct(nmodes_synt,itstep,L_t_synt,y_rans,zp,uv_rans,viscos,jmirror_synt,dmin_synt)
# correct usynt so that it is = 0 (easier to converge the p solver)
   uinc=xp.sum(usynt*areaw[0,:,:])/(y2d[0,-1]-y2d[0,0])/zmax
   usynt=usynt-uinc
   usynt_inlet=a_synt*usynt_inlet+b_synt*usynt
   vsynt_inlet=a_synt*vsynt_inlet+b_synt*vsynt
   wsynt_inlet=a_synt*wsynt_inlet+b_synt*wsynt
   u_bc_west=u_rans+usynt_inlet
   v_bc_west=vsynt_inlet
   w_bc_west=wsynt_inlet

   uu_synt=uu_synt+xp.mean(usynt**2,axis=1)
   vv_synt=vv_synt+xp.mean(vsynt**2,axis=1)
   ww_synt=ww_synt+xp.mean(wsynt**2,axis=1)
   uv_synt=uv_synt+xp.mean(usynt*vsynt,axis=1)

# update face velocity and convw at inlet
#  u3d_face_w[0,:,:]=u_bc_west
#  convw[0,:,:]=-u_bc_west*areawx[0,:,:]-v_bc_west*areawy[0,:,:]

# compute two-point corr in node 10
   two_corr=two_corr+xp.correlate(w_bc_west[10,:],w_bc_west[10,:],'full')

# compute average
   if itstep % 100 == 0:
      xp.save('two_corr_inlet',two_corr)
      xp.save('u_time',u_time)
      xp.save('uu_synt',uu_synt/(itstep+1))
      xp.save('uv_synt',uv_synt/(itstep+1))

   return u_bc_west,v_bc_west,w_bc_west,k_bc_west,eps_bc_west,om_bc_west,u3d_face_w,convw

def modify_conv(convw,convs,convl):

   convs[:,0,:]=0
   convs[:,-1,:]=0

   return convw,convs,convl

def modify_u(su3d,sp3d):

   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*u_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-xp.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*u_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound


   return su3d,sp3d


def modify_v(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*v_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-xp.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*v_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d


def modify_w(su3d,sp3d):
   su3d[0,:,:]= su3d[0,:,:]+xp.maximum(convw[0,:,:],0)*w_bc_west
   sp3d[0,:,:]= sp3d[0,:,:]-xp.maximum(convw[0,:,:],0)
   vist=vis3d[0,:,:]-viscos
   su3d[0,:,:]=su3d[0,:,:]+vist*aw_bound*w_bc_west
   sp3d[0,:,:]=sp3d[0,:,:]-vist*aw_bound

   return su3d,sp3d


def modify_k(su3d,sp3d,gen):

   return su3d,sp3d,comm_term


def modify_eps(su3d,sp3d):

   return su3d,sp3d

def modify_om(su3d,sp3d,comm_term):

   return su3d,sp3d

def modify_outlet(convw):

# inlet
   flow_in=xp.sum(convw[0,:,:])
   flow_out=xp.sum(convw[-1,:,:])
   area_out=xp.sum(areaw[-1,:,:])

   uinc=(flow_in-flow_out)/area_out
   ares=areaw[-1,:,:]
   convw[-1,:,:]=convw[-1,:,:]+uinc*ares

   print('area_out',area_out)

   flow_out_new=xp.sum(convw[-1,:,:])

   print('flow_in',flow_in,'flow_out',flow_out,'area_out',area_out,'flow_out_new',flow_out_new,'uinc:',uinc)

   return convw,u_bc_east

def modify_vis(vis3d):

   return vis3d
