import scipy.io as sio
import sys
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
import matplotlib.ticker as mtick
from matplotlib import ticker

plt.rcParams.update({'font.size': 22})
plt.rcParams.update({'figure.max_open_warning': 0})

plt.interactive(True)

viscos=3.57E-5



# file 2
name='./'

datax= np.loadtxt(str(name)+"x2d.dat")
x=datax[0:-1]
ni=int(datax[-1])
datay= np.loadtxt(str(name)+"y2d.dat")
y=datay[0:-1]
nj=int(datay[-1])

x2d=np.zeros((ni+1,nj+1))
y2d=np.zeros((ni+1,nj+1))

x2d=np.reshape(x,(ni+1,nj+1))
y2d=np.reshape(y,(ni+1,nj+1))

# compute cell centers
xp2d=0.25*(x2d[0:-1,0:-1]+x2d[0:-1,1:]+x2d[1:,0:-1]+x2d[1:,1:])
yp2d=0.25*(y2d[0:-1,0:-1]+y2d[0:-1,1:]+y2d[1:,0:-1]+y2d[1:,1:])


# read data 
itstep,nk,dz=np.load(str(name)+'itstep.npy')

# z grid
zmax, nk=np.loadtxt(str(name)+'z.dat')
nk=int(nk)
zp = np.linspace(0, zmax, nk)

p2d=np.load(str(name)+'p_averaged.npy')/itstep
u2d=np.load(str(name)+'u_averaged.npy')/itstep
v2d=np.load(str(name)+'v_averaged.npy')/itstep
w2d=np.load(str(name)+'w_averaged.npy')/itstep
k_model_2d=np.load(str(name)+'k_averaged.npy')/itstep
vis2d=np.load(str(name)+'vis_averaged.npy')/itstep
uu2d=np.load(str(name)+'uu_stress.npy')/itstep
vv2d=np.load(str(name)+'vv_stress.npy')/itstep
ww2d=np.load(str(name)+'ww_stress.npy')/itstep
uv2d=np.load(str(name)+'uv_stress.npy')/itstep
fk2d=np.load(str(name)+'fk_averaged.npy')/itstep
eps2d=np.load(str(name)+'eps_averaged.npy')/itstep

uu2d=uu2d-u2d**2
vv2d=vv2d-v2d**2
uv2d=uv2d-u2d*v2d

vis2d=vis2d/viscos

psi_small=fk2d[0,:]
c1=1.5
c2=1.9
term1=np.maximum((c2-c1*psi_small)/(c2-c1),1e-10)
fk2d_from_psi=term1**0.333

#  compute re_theta for boundary layer flow
x=x2d[:,1]
dx=x[3]-x[2]
re_mom_bl=np.zeros(ni)
for i in range (0,ni-1):
   d_mom=0
   for j in range (1,nj-1):
      up=u2d[i,j]/u2d[i,-1]
      dy=y2d[i,j]-y2d[i,j-1]
      d_mom=d_mom+up*(1.-min(up,1.))*dy

   re_mom_bl[i]=d_mom*u2d[i,-1]/viscos

re_mom_bl[-1]=re_mom_bl[-1-1]

# compute cf
cf=np.zeros(ni)
ustar=np.zeros(ni)
yplus2d=np.zeros((ni,nj))
for i in range (0,ni-1):
   uwall=u2d[i,0]
   yp=yp2d[i,0]
   ustar[i]=(uwall*viscos/yp)**0.5
   cf[i]=ustar[i]**2/(0.5*u2d[i,-1]**2)
   yplus2d[i,:]=ustar[i]*yp2d[i,:]/viscos

cf[-1]=cf[-2]

# find boundary layer thickness
delta=np.zeros(ni)
for i in range(1,ni-1):
   for j in range(0,nj-2):
      up=u2d[i,j]/u2d[i,-1]
      up1=u2d[i,j+1]/u2d[i,-1]
      if up < 0.99 and up1 > 0.99:
         jj = j
         break
   up=u2d[i,jj]/u2d[i,-1]
   up1=u2d[i,jj+1]/u2d[i,-1]
   delta[i]=y[jj]+(0.99-up)*(y[jj+1]-y[jj])/(up1-up)
#  delta[i]=y[jj]+(0.99-u2d[i,jj])*(y[jj+1]-y[jj])/(u2d[i,jj+1]-u2d[i,jj])
#  delta[i]=y[jj]

p2d_iddes=p2d
u2d_iddes=u2d
ustar_iddes=ustar
p2d_iddes=p2d
uu2d_iddes=uu2d
vv2d_iddes=vv2d
ww2d_iddes=ww2d
fk2d_iddes=fk2d
k_model_2d_iddes=k_model_2d
vis2d_iddes=vis2d
yplus2d_iddes=yplus2d
uv2d_iddes=uv2d
k_model_2d_iddes=k_model_2d
cf_iddes=cf
re_mom_bl_iddes=re_mom_bl
fk2d_from_psi_iddes=fk2d_from_psi

f_e_mean=np.load(str(name)+'f_e_mean.npy')/itstep
l_u=k_model_2d**1.5/eps2d
f_dt=np.load(str(name)+'f_dt_mean.npy')/itstep
f_b=np.load(str(name)+'f_b_mean.npy')/itstep
f_d_mean=np.maximum((1.-f_dt),f_b)

l_dist=0.15*yp2d
delta_max=np.diff(x2d[:,1:],axis=0)
l_max=0.15*delta_max
dy=np.diff(y2d[1:,:],axis=1)

l_temp=np.maximum(l_dist,l_max)
l_temp=np.maximum(l_temp,dy)
l_iddes=np.minimum(l_temp,delta_max)
#  l_iddes=np.minimum(np.maximum(l_dist,l_max,dy),delta_max)
cdes=0.67
l_c_mean=cdes*l_iddes  #eq. 9
l_u=k_model_2d**1.5/eps2d
l_c_mean_iddes=l_c_mean
f_e_mean_iddes=f_e_mean
f_d_mean_iddes=f_d_mean
l_u_iddes=l_u


vel_DNS=np.genfromtxt("Re_theta.5500.prof", dtype=None,comments="%")

 #y/d99           y+              urms            vrms            wrms            uv              uw              vw              umed            vmed            wmed            u3              v3              u2v             v2u             w2u             w2v             dumdy           dvmdy           dwmdy           oxmed           oymed           ozmed           oxrms           oyrms           ozrms           pm 


y_DNS=vel_DNS[:,0]
yplus_DNS=vel_DNS[:,1]
uu_DNS=vel_DNS[:,2]**2
vv_DNS=vel_DNS[:,3]**2
ww_DNS=vel_DNS[:,4]**2
uv_DNS=vel_DNS[:,5]
u_DNS=vel_DNS[:,8]

vel_DNS=np.genfromtxt("Re_theta.4000.prof.txt", dtype=None,comments="%")

 #y/d99           y+              urms            vrms            wrms            uv              uw              vw              umed            vmed            wmed            u3              v3              u2v             v2u             w2u             w2v             dumdy           dvmdy           dwmdy           oxmed           oymed           ozmed           oxrms           oyrms           ozrms           pm 


y_DNS_4000=vel_DNS[:,0]
yplus_DNS_4000=vel_DNS[:,1]
uu_DNS_4000=vel_DNS[:,2]**2
vv_DNS_4000=vel_DNS[:,3]**2
ww_DNS_4000=vel_DNS[:,4]**2
uv_DNS_4000=vel_DNS[:,5]
u_DNS_4000=vel_DNS[:,8]

# find equi.distant DNS cells in log-scale
xx=0.
jDNS=[1]*20
for i in range (0,20):
   i1 = (np.abs(10.**xx-yplus_DNS)).argmin()
   jDNS[i]=int(i1)
   xx=xx+0.2






########################################## cf
fig = plt.figure()
ax1 = fig.add_subplot(111)
ax2 = ax1.twiny()
plt.subplots_adjust(left=0.30, bottom=0.2, right=0.92, top=0.82, wspace=0, hspace=0.0)
ax1.plot(re_mom_bl_iddes,cf_iddes,'r--',label="$x=0$")
M = 2
xticks = ticker.MaxNLocator(M)
ax1.yaxis.set_major_locator(xticks)
ax1.yaxis.set_label_coords(-0.095, 0.6)

h1=ax1.set_ylabel(r"$C_f$")
h1.set_rotation(0)

ax1.set_ylabel(r"$C_f$")
ax1.set_xlabel(r"$Re_\theta$")
ax2.set_xlabel(r"$x/\delta_{in}$")
ax1.axis([2500,6000,0.002,0.0045])
ax1.yaxis.set_major_formatter(mtick.FormatStrFormatter('%.1e'))
#ax1.legend(loc="upper right",prop=dict(size=18))
xmax=x2d[-1,1]/delta[1]
ax2.axis([0, xmax,0.0025,0.004])
plt.savefig('cf_vs_re_mom-re-theta-2500-etmm13-journal.eps')

########################################## uu
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)

i1=633
plt.plot((uu2d_iddes[i1,:]+0.666*k_model_2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')
plt.plot(uu_DNS[::10],yplus_DNS[::10],'r+',label=r'$x=10$')
plt.xlabel(r"$\langle \bar{u}'\bar{u}' + 2k/3\rangle^+$")
plt.ylabel(r"$y^+$")
plt.axis([0,11,0,1000])
plt.savefig('uu_total_bound-re-theta-2500-re-theta-5500-re-theta-5500-etmm13-journal.eps')

########################################## uu
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)

i1=633
plt.plot((uu2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')
plt.plot(uu_DNS[::10],yplus_DNS[::10],'r+',label=r'$x=10$')
plt.xlabel(r"$\langle \bar{u}'\bar{u}'\rangle^+$")
plt.ylabel(r"$y^+$")
plt.axis([0,11,0,1000])
plt.savefig('uu_resolved_bound-re-theta-2500-re-theta-5500-re-theta-5500-etmm13-journal.eps')




########################################## U 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1=633
plt.semilogx(yplus2d_iddes[i1,:],u2d_iddes[i1,:]/ustar_iddes[i1],'r--')
plt.semilogx(yplus_DNS[jDNS],u_DNS[jDNS],'r+')
plt.ylabel(r"$\langle\bar{u}^+\rangle$")
plt.xlabel("$y^+$")
plt.axis([1, 1000, 0, 28])
plt.savefig('u_log_python-re-theta-2500-re-theta-5500-etmm13-journal.eps')


########################################## uu
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)

i1=633
plt.plot((uu2d_iddes[i1,:]+0.66*k_model_2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')

plt.plot((0.66*k_model_2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')

ax1.annotate('total', xy=(3,600), xytext=(6, 800),
            arrowprops=dict(facecolor='black', shrink=0.05))
ax1.annotate('modeled', xy=(0.3, 300), xytext=(5, 400),
            arrowprops=dict(facecolor='black', shrink=0.05))


plt.plot(uu_DNS[::10],yplus_DNS[::10],'r+',label=r'$x=10$')
plt.xlabel(r"$\langle 2k/3\rangle^+ \quad \langle \bar{u}'\bar{u}'\rangle^+$")
plt.ylabel(r"$y^+$")
plt.axis([0,9,1,1000])
plt.savefig('uu_total_model-bound-re-theta-2500-re-theta-5500-etmm13-journal.eps')





########################################## fk
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1=633
plt.plot(fk2d_iddes[i1,:],yplus2d_iddes[i1,:],'r--')
plt.xlabel(r"$\langle \psi\rangle$")
plt.ylabel("$y^+$")
plt.axis([0.7,1.8,0,1000])
plt.savefig('fk_python-re-theta-2500-re-theta-5500-etmm13-journal.eps')

########################################## vis
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(vis2d_iddes[i1,:]-1,yplus2d_iddes[i1,:],'r--')
plt.xlabel(r"$\langle \nu_t\rangle/\nu$")
plt.ylabel("$y^+$")
plt.axis([0,30,0, 1000])
plt.savefig('vis_python-re-theta-2500-re-theta-5500-etmm13-journal.eps')


########################################## fk
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(fk2d_iddes[i1,:],yplus2d_iddes[i1,:],'r--')
plt.xlabel(r"$\langle\psi\rangle$")
plt.ylabel("$y^+$")
plt.axis([0.7,1.8,0, 1000])
plt.savefig('fk_python-re-theta-2500-re-theta-5500-etmm13-journal.eps')




########################################## uu
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)

i1=367
plt.plot((uu2d_iddes[i1,:]+0.666*k_model_2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')
plt.plot(uu_DNS_4000[::10],yplus_DNS_4000[::10],'r+',label=r'$x=10$')
plt.xlabel(r"$\langle 2k/3\rangle^+ \quad \langle \bar{u}'\bar{u}'\rangle^+$")
plt.ylabel(r"$y^+$")
plt.axis([0,11,1,700])
plt.savefig('uu_total_bound-re-theta-2500-re-theta-4000-etmm13-journal.eps')

########################################## uu
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)

i1=267
plt.plot((uu2d_iddes[i1,:]+0.66*k_model_2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')

plt.plot((0.66*k_model_2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')

ax1.annotate('total', xy=(4,400), xytext=(7, 600),
            arrowprops=dict(facecolor='black', shrink=0.05))
ax1.annotate('modeled', xy=(0.3, 100), xytext=(7, 200),
            arrowprops=dict(facecolor='black', shrink=0.05))


plt.plot(uu_DNS[::10],yplus_DNS[::10],'r+',label=r'$x=10$')
plt.xlabel(r"$\langle 2k/3\rangle^+ \quad \langle \bar{u}'\bar{u}'\rangle^+$")
plt.ylabel(r"$y^+$")
plt.axis([0,13,1,1000])
plt.savefig('uu_total_model-bound-re-theta-2500-re-theta-4000-etmm13-journal.eps')


########################################## uu
fig59,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)

i1=267
plt.plot((uu2d_iddes[i1,:]+0.66*k_model_2d_iddes[i1,:])/ustar_iddes[i1]**2,yplus2d_iddes[i1,:],'r--')

plt.plot(uu_DNS[::10],yplus_DNS[::10],'r+',label=r'$x=10$')
plt.xlabel(r"$\langle 2k/3\rangle^+ \quad \langle \bar{u}'\bar{u}'\rangle^+$")
plt.ylabel(r"$y^+$")
plt.axis([0,13,1,1000])
plt.savefig('uu_total-bound-re-theta-2500-re-theta-4000-etmm13-journal.eps')





########################################## U 
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1=367
plt.semilogx(yplus2d_iddes[i1,:],u2d_iddes[i1,:]/ustar_iddes[i1],'r--')
plt.semilogx(yplus_DNS_4000[jDNS],u_DNS_4000[jDNS],'r+')
plt.ylabel("$U$")
plt.xlabel("$y^+$")
plt.axis([1, 700, 0, 28])
plt.savefig('u_log_python-re-theta-2500-re-theta-4000-etmm13-journal.eps')



########################################## fk
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1=367
plt.plot(fk2d_iddes[i1,:],yplus2d_iddes[i1,:],'r--')
plt.xlabel(r"$\psi$")
plt.ylabel("$y^+$")
plt.axis([1, 700, 0.7,1.8])
plt.savefig('fk_python-re-theta-2500-re-theta-4000-etmm13-journal.eps')

########################################## vis
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1 = 367
plt.plot(vis2d_iddes[i1,:]-1,yplus2d_iddes[i1,:],'r--')
plt.xlabel(r"$\nu_t/\nu$")
plt.ylabel("$y^+$")
plt.axis([0,20,0, 1000])
plt.savefig('vis_python-re-theta-2500-re-theta-4000-etmm13-journal.eps')


########################################## fk
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
i1=367
plt.plot(fk2d_iddes[i1,:],yplus2d_iddes[i1,:],'r--')
plt.xlabel(r"$\psi$")
plt.ylabel("$y^+$")
plt.axis([0.4,1.8,0, 1000])
plt.savefig('fk_python-re-theta-2500-re-theta-4000-etmm13-journal.eps')

