def STG(U0,viscos,itstep,deltat,xp2d_synt,yp2d_synt,zp2d_synt,dw2d,dx2d,dy2d,dz2d,r11,r12,r13,r22,r23,r33,k_rans,om_rans):
#!!!  number of modes                        = nmodes
#!!!  kinetic viscosity                      = visc

   global N,kn_wave,le_max,kx,ky,kz,psi,qnNorm,sxio,syio,szio,a11,a21,a22,a31,a32,a33
   
   nj = int(xp.size(yp2d_synt,0))
   nk = int(xp.size(yp2d_synt,1))

   if itstep == 0:

      uvmean_check=0
      uv_synt_mean=0
# compute length scales le, lcut, lnu, lt
      eps = 0.09*om_rans*k_rans

      lt  = k_rans**0.5/(0.09*om_rans)
      le  = xp.minimum(2.0*dw2d,3.0*lt)
      lnu = viscos**0.75/eps**0.25    
      le_max = xp.amax(le)
      
      tmp = xp.maximum(dy2d,dz2d)
      hmax = xp.maximum(tmp,dx2d)
      tmpNew = xp.maximum(tmp,0.3*hmax) + 0.1*dw2d
      lcut = 2.0*xp.minimum(tmpNew,hmax)
# compute ke, kcut, knu
      ke = 2.0*xp.pi/le
      kcut = 2.0*xp.pi/lcut 
      knu = 2*xp.pi/lnu
      
      ke_min = 2*xp.pi/le_max
      k_min_STG = 0.5*ke_min
      k_max = 1.5*xp.amax(kcut)
      alpha = 0.01
      
      N = int(xp.ceil(xp.log(k_max/k_min_STG)/xp.log(1+alpha) + 1))
      n = xp.linspace(1,N,N)
      kn = k_min_STG*(1+alpha)**(n-1)
      dkn = xp.zeros(N)
      dkn[0] = 0.5*(kn[1]-kn[0])
      dkn[1:-1] = 0.5*(kn[2:]-kn[0:-2])
      dkn[-1] = 0.5*(kn[-1]-kn[-2])
      
#      fcut = 
      
# create a seed from time 
      xp.random.seed()
      xp.random.seed(2)

# zero all arrays to zero
#      wnr=xp.zeros(nmodes+2)
#      fi=xp.zeros(nmodes+2)
      teta=xp.zeros(N)
      psi=xp.zeros(N)
#      wnr=xp.zeros(nmodes+2)
      kxio=xp.zeros((nj,nk,N))
      kyio=xp.zeros((nj,nk,N))
      kzio=xp.zeros((nj,nk,N))
      sxio=xp.zeros((nj,nk,N))
      syio=xp.zeros((nj,nk,N))
      szio=xp.zeros((nj,nk,N))
#  yp2d_wave=xp.zeros((nj,nk,nmodes+2))
      zp2d_wave=xp.zeros((nj,nk,N))
      u=xp.zeros((nj,nk))
      v=xp.zeros((nj,nk))
      w=xp.zeros((nj,nk))
 # # compute random angles
     
      fi = xp.random.uniform(0.,2.*math.pi,N)
      psi = xp.random.uniform(0.,2.*math.pi,N)
      alfa = xp.random.uniform(0.,2.*math.pi,N)
      ang = xp.random.uniform(0.,1,N)
      teta=xp.arccos(1.-ang/0.5) 
      
#   wavenumber vector from random angles
      kxio=xp.sin(teta)*xp.cos(fi)
      kyio=xp.sin(teta)*xp.sin(fi)
      kzio=xp.cos(teta)
#
# sigma (s=sigma) from random angles. sigma is the unit direction which gives the direction
# of the synthetic velocity vector (u, v, w)
      sxio=xp.cos(fi)*xp.cos(teta)*xp.cos(alfa)-xp.sin(fi)*xp.sin(alfa)
      syio=xp.sin(fi)*xp.cos(teta)*xp.cos(alfa)+xp.cos(fi)*xp.sin(alfa)
      szio=-xp.sin(teta)*xp.cos(alfa)
      
      kcut_wave =  xp.repeat(kcut[:,:,None], repeats=N, axis=2)
      knu_wave  =  xp.repeat(knu[:,:,None], repeats=N, axis=2)
      ke_wave  =  xp.repeat(ke[:,:,None], repeats=N, axis=2)
      kn_wave = xp.repeat(kn[:,None],repeats=nj,axis=1)
      kn_wave = xp.repeat(kn_wave[:,:,None],repeats=nk,axis=2)
      kn_wave = xp.transpose(kn_wave,(1,2,0))
      
      fnu = xp.exp(-(12.0*kn_wave/knu_wave)**2)
      fcut = xp.exp(-(4.0*xp.maximum(kn_wave-0.9*kcut_wave,xp.zeros((nj,nk,N)))/kcut_wave)**3)
      
      E = (kn_wave/ke_wave)**4/(1.0+2.4*(kn_wave/ke_wave)**2)**(17/6)*fnu*fcut 
      
      # print('ASD')
      # jidx = 35
      # kidx = 15

      # Eplot = E[jidx,kidx,:]

      # fig1,ax1 = plt.subplots()
      # plt.subplots_adjust(left=0.20,bottom=0.20)
      # plt.loglog(kn,Eplot,'b--',label="$x=0$")
      # plt.loglog(kn,kn**(-5/3),'r-',label="$x=0$")
      # plt.axis([1, xp.amax(kn), 0.000001, 1])
      
      qn = E*dkn
      qnSum = xp.sum(qn,axis=2)
      
      qnNorm = qn/xp.repeat(qnSum[:,:,None], repeats=N, axis=2)
      
      kx=kxio*kn
      ky=kyio*kn
      kz=kzio*kn
      
      # Cholesky Decomposition
      a11 = xp.sqrt(r11)
      a21 = r12/(a11)
      a22 = xp.sqrt(r22 - a21*a21)
      a31 = r13/(a11)
      a32 = (r23 - a21*a31)/(a22)
      a33 = xp.sqrt(r33 - a31*a31 - a32*a32)

      print('le_min :  ' + str(xp.amin(le)))
      print('lcut_min :  ' + str(xp.amin(lcut)))
      print('lnu_min :  ' + str(xp.amin(lnu)))
      print('k_min_STG :  ' + str(k_min_STG))
      print('k_max :  ' + str(k_max))
      print('NModes STG:  ' + str(N))
          
# #
# #=========================================================================
# #
     
   xp2d_wave=xp.repeat(xp2d_synt[:,:,None], repeats=N, axis=2)
   arg1=(2*xp.pi/(kn_wave*le_max))*(xp2d_wave-U0*deltat*itstep)*kx
      
   yp2d_wave=xp.repeat(yp2d_synt[:,:,None], repeats=N, axis=2)
   arg2=yp2d_wave*ky

   zp2d_wave=xp.repeat(zp2d_synt[:,:,None], repeats=N, axis=2)
   arg3=zp2d_wave*kz

   arg=arg1+arg2+arg3+psi

   tfunk=xp.cos(arg)

# sum over all wavenumbers => synthetic velocity field 
   usynt= xp.sqrt(6.0)*xp.sum(xp.sqrt(qnNorm)*tfunk*sxio,axis=2)
   vsynt= xp.sqrt(6.0)*xp.sum(xp.sqrt(qnNorm)*tfunk*syio,axis=2)
   wsynt= xp.sqrt(6.0)*xp.sum(xp.sqrt(qnNorm)*tfunk*szio,axis=2)
   
#  
   usynt_aniso = a11*usynt 
   vsynt_aniso = a21*usynt+a22*vsynt
   wsynt_aniso = a31*usynt+a32*vsynt+a33*wsynt
 
   return usynt_aniso,vsynt_aniso,wsynt_aniso
