% here the figures of paper
%
% M. Mirzaei, L. Davidson, A. Sohankar, F. Innings
%"The effect of corrugation on heat transfer and pressure drop in channel flow with 
% different Prandtl numbers", International Journal of Heat and Mass Transfer,
%  Vol. 66, pp. 164--176, 2013
%
%are plotted 

close all;clear all;clc
%--------------------figure 3
load nu_g1.dat
load nu_g2.dat
load nu_g3.dat
load nu_g4.dat
of paper


load cf_g1.dat
load cf_g2.dat
load cf_g3.dat
load cf_g4.dat
load twall.dat
%-----3a
figure(1)
plot(cf_g1(:,1),cf_g1(:,2),'b','linew',2)
 hold
plot(cf_g2(:,1),cf_g2(:,2),'k--','linew',2)
plot(cf_g3(:,1),cf_g3(:,2),'r-.','linew',2)
plot(cf_g4(:,1),cf_g4(:,2),'g.','linew',2)
plot(twall(:,1),(twall(:,2)/50)-0.002,'k-','linew',4)
 xlabel('x','fontsi',[20])
 ylabel('Cf','fontsi',[20])
 axis([0 3.7 -0.005 0.015])
h=gca;
set(h,'fontsi',[20])
print cf_grid.eps  -depsc
%
%-----3b
figure(2)
plot(nu_g1(:,1),nu_g1(:,2),'b','linew',2)
hold
plot(nu_g2(:,1),nu_g2(:,2),'k--','linew',2)
plot(nu_g3(:,1),nu_g3(:,2),'r-.','linew',2)
plot(nu_g4(:,1),nu_g4(:,2),'g.','linew',1)
plot(twall(:,1),(twall(:,2)*80)+30,'k-','linew',4)
plot(twall(:,1)+3.67,(twall(:,2)*80)+30,'k-','linew',4)
%legend('grid 1','grid 2','grid 3','grid 4',[15])
axis([0 7.2 15 80])
xlabel('x','fontsi',[20])
ylabel('Nu','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print nu_grid.eps  -depsc

%-------------------- figure 4
load nu_pr35_1.dat
load nu_pr35_2.dat

figure(3)
plot(nu_pr35_1(:,1),nu_pr35_1(:,2),'ks','linew',1)
hold
plot(nu_pr35_2(:,1),nu_pr35_2(:,2),'r--','linew',2)
plot(twall(:,1),(twall(:,2)*100)+50,'k-','linew',4)
axis([0 4 35 160])
xlabel('x','fontsi',[20])
ylabel('Nu','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print nu_35_fine.eps  -depsc


%----------------- figure 5
load cf_dns_1.dat
load cf_dns_2.dat
load cf_dns_3.dat
load nu_dns_1.dat
load nu_dns_2.dat
%----5a

figure(4)
plot(cf_dns_1(:,1),cf_dns_1(:,2),'k','linew',2)
hold
plot(cf_dns_2(:,1),cf_dns_2(:,2),'g-.','linew',2)
plot(cf_dns_3(:,1),cf_dns_3(:,2),'r--','linew',2)
plot(twall(:,1),(twall(:,2)/50)-0.002,'k-','linew',4)
xlabel('x','fontsi',[20])
ylabel('cf','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print cf_dns.eps  -depsc

%-----5b
figure(5)
plot(nu_dns_1(:,1),nu_dns_1(:,2),'k-','linew',2)
hold
plot(nu_dns_2(:,1),nu_dns_2(:,2),'r--','linew',2)
axis([0 3.6 15 80])
xlabel('x','fontsi',[20])
ylabel('Nu','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print nu_dns.eps  -depsc

%-------------------figure 6
%----6a
load two_cor_05.dat
figure(6)
plot(two_cor_05(:,1),two_cor_05(:,2),'k-','linew',2)
hold
plot(two_cor_05(:,1),two_cor_05(:,3),'b--','linew',2)
plot(two_cor_05(:,1),two_cor_05(:,4),'r-.','linew',2)

axis([0 0.25 -0.3 1])
xlabel('z','fontsi',[20])
ylabel('B_{ww}(z)','fontsi',[20])
h1=gca;
set(h1,'fontsi', [20])
print two-0.5.eps  -depsc

%---- 6b
load two_cor_1.dat
figure(7)
plot(two_cor_1(:,1),two_cor_1(:,2),'k-','linew',2)
hold
plot(two_cor_1(:,1),two_cor_1(:,3),'b--','linew',2)
plot(two_cor_1(:,1),two_cor_1(:,4),'r-.','linew',2)

axis([0 0.5 -0.2 1])
xlabel('z','fontsi',[20])
ylabel('B_{ww}(z)','fontsi',[20])
h1=gca;
set(h1,'fontsi', [20])
print two-1.eps  -depsc

%------------figure 7
load cf_z05.dat
load cf_z1.dat
load nu_z05.dat
load nu_z1.dat

%---7a
figure(8)
plot(cf_z05(:,1),cf_z05(:,2),'k-','linew',2)
hold
plot(cf_z1(:,1),cf_z1(:,2),'r--','linew',2)
plot(twall(:,1),(twall(:,2)/50)-0.002,'k-','linew',4)
xlabel('x','fontsi',[20])
ylabel('Cf','fontsi',[20])
axis([0 3.7 -0.005 0.015])
h=gca;
set(h,'fontsi',[20])
print cf_z.eps  -depsc
%----7b
figure(9)
plot(nu_z05(:,1),nu_z05(:,2),'k-','linew',2)
hold
plot(nu_z1(:,1),nu_z1(:,2),'r--','linew',2)
plot(twall(:,1),(twall(:,2)*80)+25,'k-','linew',4)
axis([0 3.6 10 70])
xlabel('x','fontsi',[20])
ylabel('Nu','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print nu_z.eps  -depsc

%------------- figure 8
load linex06m.dat
load linex16m.dat
load dns_1.dat
load dns_2.dat
load dns_3.dat

x_1=dns_1(:,2);

%------- 8a   
figure(10)
plot(linex16m(:,2)*395.,linex16m(:,5).^0.5,'linew',2)
hold
plot(linex16m(:,2)*395.,linex16m(:,6).^0.5,'r','linew',2)
plot(linex16m(:,2)*395.,linex16m(:,7).^0.5,'k','linew',2)
plot(x_1,sqrt(dns_1(:,4)),'o','linew',2)
plot(x_1,sqrt(dns_1(:,5)),'ks','linew',2)
plot(x_1,sqrt(dns_2(:,3)),'r+','linew',2)
xlabel('y+','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print u2_v2_rms_dns.eps  -depsc

%-----8b
figure(11)
semilogx(linex06m(:,2)*395,linex06m(:,3),'linew',2)
hold
semilogx(dns_1(:,2),dns_1(:,3),'ks','linew',2.)
y3=linspace(0,11,100);
x3=y3;
semilogx(x3,y3,'r--','linew',3)
x4=10:1000;
y4=(1/0.41)*log(x4)+5.3;
semilogx(x4,y4,'r--','linew',3)
axis([0.4 400 0 25])
xlabel('x','fontsi',[20])
ylabel('y','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print u_dns.eps  -depsc

%-----8c
figure(12)
plot(linex06m(:,2)*395,linex06m(:,18)*1000,'k','linew',2)
hold
plot(dns_3(:,2),dns_3(:,3),'ks','linew',2.)
xlabel('y+','fontsi',[20])
ylabel('vt','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print vt_dns.eps  -depsc
%--------------figure 10
load p.dat
load prms_k.dat

%------10a
figure(13)
plot(p(:,1),p(:,2),'k-','linew',2)
hold
plot(twall(:,1),(twall(:,2)/5-0.02),'k-','linew',4)
xlabel('x','fontsi',[20])
 ylabel('p','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print p.eps  -depsc
%----10b
figure(14)
plot(prms_k(:,1),-prms_k(:,2),'k-','linew',2)
hold
plot(twall(:,1),(twall(:,2)/70)-0.0005,'k-','linew',4)
xlabel('x','fontsi',[20])
 ylabel('prms','fontsi',[20])
 axis([0 1.5 -0.003 0.008])
h=gca;
set(h,'fontsi',[20])
print prms.eps  -depsc

%-------------- figure 11
load nu_pr07.dat
load nu_pr35.dat
load nu_analy.dat
load cf_g1.dat
%---11a
figure(15)
plot(nu_pr07(:,1),nu_pr07(:,2),'ko','linew',1)
hold
h2=plot(nu_pr35(:,1),nu_pr35(:,2),'ko','linew',1)
set(h2,'MarkerFaceColor','black')
plot(nu_pr07(:,1),nu_analy(:,1),'r--','linew',2)
plot(nu_pr07(:,1),nu_analy(:,3),'b-','linew',2)
plot(nu_pr07(:,1),nu_analy(:,2),'r--','linew',2)
xlabel('x','fontsi',[14])
ylabel('Nu','fontsi',[14])
h=gca;
set(h,'fontsi',[14])
print nu_pr.eps  -depsc

%---11b
figure(16)
plot(cf_g1(:,1),cf_g1(:,2)/cf_g1(1,2),'r--','linew',2)
hold
plot(nu_pr07(:,1),nu_pr07(:,2)/nu_pr07(1,2),'k-','linew',2)
plot(twall(:,1),(twall(:,2)*4)-0.5,'k-','linew',4)
axis([0 2 -1.5 2.5])
xlabel('x','fontsi',[20])
h=gca;
set(h,'fontsi',[15])
print nu_cf.eps  -depsc

%--------------- figure 12
load linex0m.dat
load linex01m.dat
load linex02m.dat
load linex03m.dat
load linex04m.dat
load linex05m.dat
load linex06m_l.dat
load linex07m.dat
load linex08m.dat
load linex09m.dat
load linex1m.dat
load linex11m.dat
load linex12m.dat
load linex13m.dat
load linex14m.dat
load linex15m.dat
load linex16m_l.dat
load linex18m.dat

load dns_ch.dat
load kawa_u.dat
load kawa_v2.dat
load kawa_vt.dat

load twall.dat

%---12a
figure(17)
plot(linex0m(:,3),linex0m(:,2)-linex0m(1,2),'k-','linew',2)
hold
plot(linex01m(:,3),linex01m(:,2)-linex01m(1,2),'b--','linew',2)
plot(linex02m(:,3),linex02m(:,2)-linex02m(1,2),'r.','linew',2)
plot(linex03m(:,3),linex03m(:,2)-linex03m(1,2),'g-.','linew',2)
L=dns_ch;
n=length(L);
jj=1:5:n;
plot(L(jj,13)/18.1,L(jj,2),'ks','linew',2)
xlabel('u','fontsi',[15])
ylabel('y-yw','fontsi',[15])
axis([0. 1.4 0. 1.2])
h=gca;
set(h,'fontsi',[15])
print u_1_full.eps  -depsc
%-----12b
figure(18)
plot(linex0m(:,3),linex0m(:,2)-linex0m(1,2),'k-','linew',2)
hold
plot(linex01m(:,3),linex01m(:,2)-linex01m(1,2),'b--','linew',2)
plot(linex02m(:,3),linex02m(:,2)-linex02m(1,2),'r.','linew',2)
plot(linex03m(:,3),linex03m(:,2)-linex03m(1,2),'g-.','linew',2)
L=dns_ch;
n=length(L);
jj=1:5:n;
plot(L(jj,13)/18.1,L(jj,2),'ks','linew',2)
xlabel('u','fontsi',[15])
ylabel('y-yw','fontsi',[15])
axis([0. 1. 0. 0.1])
h=gca;
set(h,'fontsi',[15])
print u_1.eps  -depsc

%-----12c
figure(19)
plot(linex04m(:,3),linex04m(:,2)-linex04m(1,2),'k','linew',4)
hold
plot(linex06m_l(:,3),linex06m_l(:,2)-linex06m_l(1,2),'b--','linew',2)
plot(linex08m(:,3),linex08m(:,2)-linex08m(1,2),'r.','linew',2)
plot(linex09m(:,3),linex09m(:,2)-linex09m(1,2),'g-.','linew',2)
plot(linex1m(:,3),linex1m(:,2)-linex1m(1,2),'k','linew',2)
xlabel('u','fontsi',[15])
ylabel('y-yw','fontsi',[15])
axis([-0.2 1. 0. 0.1])
h=gca;
set(h,'fontsi',[15])
print u_2.eps  -depsc

%-------12d
figure(20)
plot(linex11m(:,3)+1.1,(linex11m(:,2)-linex11m(1,2))-0.01,'k','linew',4)
hold
plot(linex12m(:,3)+1.2,(linex12m(:,2)-linex12m(1,2))-0.0045,'b--','linew',2)
plot(linex14m(:,3)+1.4,linex14m(:,2)-linex14m(1,2),'r.','linew',2)
plot(linex16m_l(:,3)+1.6,linex16m_l(:,2)-linex16m_l(1,2),'g-.','linew',2)
plot(linex18m(:,3)+1.8,linex18m(:,2)-linex18m(1,2),'k','linew',2)
L=dns_ch;
n=length(L);
jj=1:5:n;
plot((L(jj,13)/18.1)+1.75,L(jj,2)-L(1,2),'ks','linew',2)
plot(twall(:,1),(twall(:,2)/7),'b-','linew',4)
xlabel('u','fontsi',[15])
ylabel('y-yw','fontsi',[15])
axis([0.8 2.7 -0.025 0.1])
h=gca;
set(h,'fontsi',[15])
print u_3.eps  -depsc
%----------------------------figure 14
%-----14a
figure(21)
plot(linex02m(:,6),linex02m(:,2)-linex02m(2,2),'b--','linew',2)
hold
plot(linex04m(:,6),linex04m(:,2)-linex04m(1,2),'r.','linew',2)
plot(linex06m_l(:,6),linex06m_l(:,2)-linex06m_l(1,2),'g-.','linew',2)
plot(linex08m(:,6),linex08m(:,2)-linex08m(1,2),'k','linew',2)
L=kawa_v2;
n=length(L);
jj=1:2:n;
plot(kawa_v2(jj,3)/(17.*17.),kawa_v2(jj,2)/395,'ks','linew',2)
xlabel('v2','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([0 0.011 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print vrms_1.eps  -depsc

%-----14b
figure(22)
plot(linex1m(:,6),linex1m(:,2)-linex1m(1,2),'b--','linew',2)
hold
plot(linex12m(:,6),linex12m(:,2)-linex12m(1,2),'r.','linew',2)
plot(linex14m(:,6),linex14m(:,2)-linex14m(1,2),'g-.','linew',2)
plot(linex18m(:,6),linex18m(:,2)-linex18m(1,2),'k-','linew',2)
L=kawa_v2;
n=length(L);
jj=1:2:n;
plot(kawa_v2(jj,3)/(17.*17.),kawa_v2(jj,2)/395,'ks','linew',2)
xlabel('v2','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([0 0.011 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print vrms_2.eps  -depsc
%-----14c
figure(23)
plot(linex02m(:,8),linex02m(:,2)-linex02m(1,2),'b--','linew',2)
hold
plot(linex04m(:,8),linex04m(:,2)-linex04m(1,2),'r.','linew',2)
plot(linex06m_l(:,8),linex06m_l(:,2)-linex06m_l(1,2),'g-.','linew',2)
plot(linex08m(:,8),linex08m(:,2)-linex08m(1,2),'k','linew',2)
L=kawa_v2;
n=length(L);
jj=1:2:n;
plot(-kawa_v2(jj,4)/(17.*17.),kawa_v2(jj,2)/395,'ks','linew',2)
xlabel('uv','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([-0.01 0.002 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print uv_1.eps  -depsc
%-----14d
figure(24)
plot(linex1m(:,8),linex1m(:,2)-linex1m(1,2),'b--','linew',2)
hold
plot(linex12m(:,8),linex12m(:,2)-linex12m(1,2),'r.','linew',2)
plot(linex14m(:,8),linex14m(:,2)-linex14m(1,2),'g-.','linew',2)
plot(linex18m(:,8),linex18m(:,2)-linex18m(1,2),'k-','linew',2)
L=kawa_v2;
n=length(L);
jj=1:2:n;
plot(-kawa_v2(jj,4)/(17.*17.),kawa_v2(jj,2)/395,'ks','linew',2)
xlabel('uv','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([-0.01 0.002 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print uv_2.eps  -depsc
%-----14e
figure(25)
plot(linex02m(:,10),linex02m(:,2)-linex02m(1,2),'b--','linew',2)
hold
plot(linex04m(:,10),linex04m(:,2)-linex04m(1,2),'r.','linew',2)
plot(linex06m_l(:,10),linex06m_l(:,2)-linex06m_l(1,2),'g-.','linew',2)
plot(linex08m(:,10),linex08m(:,2)-linex08m(1,2),'k','linew',2)
xlabel('p12','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([-0.045 0.005 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print p12_1.eps  -depsc
%------14f
figure(26)
plot(linex1m(:,10),linex1m(:,2)-linex1m(1,2),'b--','linew',2)
hold
plot(linex12m(:,10),linex12m(:,2)-linex12m(1,2),'r.','linew',2)
plot(linex14m(:,10),linex14m(:,2)-linex14m(1,2),'g-.','linew',2)
plot(linex18m(:,10),linex18m(:,2)-linex18m(1,2),'k','linew',2)
xlabel('p12','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([-0.045 0.005 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print p12_2.eps  -depsc
%----------------------figure 16
load data.dat
%------16a
figure(27)
plot(data(:,2)-data(1,2),data(:,10),'k','linew',2)
hold
plot(data(:,2)-data(1,2),data(:,11),'b--','linew',2) 
plot(data(:,2)-data(1,2),data(:,12),'r.','linew',2)
plot(data(:,2)-data(1,2),data(:,13),'g-.','linew',2)
axis([0 1.1 -0.04 0.04])
xlabel('x','fontsi',[20])
ylabel('y','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print uv_balance.eps  -depsc
%-----16b
figure(28)
plot(data(:,2)-data(1,2),data(:,10),'k','linew',2)
hold
plot(data(:,2)-data(1,2),data(:,11),'b--','linew',2) 
plot(data(:,2)-data(1,2),data(:,12),'r.','linew',2)
plot(data(:,2)-data(1,2),data(:,13),'g-.','linew',2)
axis([0 0.1 -0.04 0.04])
xlabel('x','fontsi',[20])
ylabel('y','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print uv_balance_zoom.eps  -depsc

%------------------------figure 18
load u2_x_wavy.dat
x=4;
y1=0.0028;  
y2=0.0043;
y3=0.026;
figure(29)
plot(u2_x_wavy(:,1),u2_x_wavy(:,2),'k','linew',2)
hold
plot(u2_x_wavy(:,1),u2_x_wavy(:,3),'b--','linew',2)
plot(u2_x_wavy(:,1),u2_x_wavy(:,4),'r.','linew',2)
plot(twall(:,1),(twall(:,2)/20),'k-','linew',4)
plot(x,y1,'bo','linew',4)
plot(x,y2,'ro','linew',4)
plot(x,y3,'ko','linew',4)
xlabel('x','fontsi',[20])
ylabel('u2','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print u2_v2_x.eps  -depsc
%-----------------------figure 19
%----19a
figure(30)
plot(-linex02m(:,12)+linex02m(1,12),linex02m(:,2)-linex02m(1,2),'k','linew',2)
hold
plot(-linex04m(:,12)+linex04m(1,12),linex04m(:,2)-linex04m(1,2),'b--','linew',2)
plot(-linex06m_l(:,12)+linex06m_l(1,12),linex06m_l(:,2)-linex06m_l(1,2),'r.','linew',2)
plot(-linex08m(:,12)+linex08m(1,12),linex08m(:,2)-linex08m(1,2),'g-.','linew',2)
L=dns_ch;
n=length(L);
jj=1:8:n;
plot(((-L(jj,15)+L(1,15))*18.),L(jj,2)-0.0037,'ks','linew',2)
axis([0. 0.5 0. 0.2])
xlabel('Tw-T','fontsi',[20])
ylabel('y-yw','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print T_pr07_1.eps  -depsc
%------19b
figure(31)
plot(-linex1m(:,12)+linex1m(1,12),linex1m(:,2)-linex1m(1,2),'k','linew',2)
hold
plot(-linex12m(:,12)+linex12m(1,12),linex12m(:,2)-linex12m(1,2),'b--','linew',2)
plot(-linex14m(:,12)+linex14m(1,12),linex14m(:,2)-linex14m(1,2),'r.','linew',2)
plot(-linex18m(:,12)+linex18m(1,12),linex18m(:,2)-linex18m(1,2),'g-.','linew',2)
L=dns_ch;
n=length(L);
jj=1:8:n;
plot(((-L(jj,15)+L(1,15))*18.),L(jj,2)-0.0037,'ks','linew',2)
axis([0. 0.4 0. 0.2])
 xlabel('T_w-T','fontsi',[17])
 ylabel('y-y_w','fontsi',[17])
h=gca;
set(h,'fontsi',[17])
print T_pr07_2.eps  -depsc
%----------------figure 20

load linex02m_3.dat
load linex04m_3.dat
load linex06m_3.dat
load linex08m_3.dat
load linex1m_3.dat
load linex12m_3.dat
load linex14m_3.dat
load linex18m_3.dat

%-------20a
figure(32)
plot(-linex02m_3(:,12)+linex02m_3(1,12),linex02m_3(:,2)-linex02m_3(1,2),'k','linew',2)
hold
plot(-linex04m(:,12)+linex04m(1,12),linex04m(:,2)-linex04m_3(1,2),'b--','linew',2)
plot(-linex06m_3(:,12)+linex06m_3(1,12),linex06m_3(:,2)-linex06m_3(1,2),'r.','linew',2)
plot(-linex08m_3(:,12)+linex08m_3(1,12),linex08m_3(:,2)-linex08m_3(1,2),'g-.','linew',2)
xlabel('Tw-T','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([0. 1.2 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print T_pr35_1.eps  -depsc
%-----20b
figure(33)
plot(-linex1m_3(:,12)+linex1m_3(1,12),linex1m_3(:,2)-linex1m_3(1,2),'k','linew',2)
hold
plot(-linex12m_3(:,12)+linex12m_3(1,12),linex12m_3(:,2)-linex12m_3(1,2),'b--','linew',2)
plot(-linex14m_3(:,12)+linex14m_3(1,12),linex14m_3(:,2)-linex14m_3(1,2),'r.','linew',2)
plot(-linex18m_3(:,12)+linex18m_3(1,12),linex18m_3(:,2)-linex18m_3(1,2),'g-.','linew',2)
xlabel('Tw-T','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([0. 0.6 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print T_pr35_2.eps  -depsc
%---------------figure 23
load linex04m_3.dat
load linex08m_3.dat
load linex12m_3.dat
load linex20m_3.dat

figure(34)
plot(linex04m_3(:,13),linex04m_3(:,2)-linex04m_3(2,2),'k-','linew',2)
hold
plot(linex08m_3(:,13),linex08m_3(:,2)-linex08m_3(2,2),'b--','linew',2)
plot(linex12m_3(:,13),linex12m_3(:,2)-linex12m_3(2,2),'r.','linew',2)
plot(linex20m_3(:,13),linex20m_3(:,2)-linex20m_3(2,2),'g-.','linew',2)
xlabel('Trms','fontsi',[20])
ylabel('y-yw','fontsi',[20])
axis([0. 0.035 0. 0.2])
h=gca;
set(h,'fontsi',[20])
print Trms_35_2.eps  -depsc
%--------------figure 24
%----24a
load trms.dat
load trms_35.dat
load twall.dat
x=1.5;
y1=0.00875;

figure(35)
plot(trms(:,1),trms(:,2)*5,'b','linew',2)
hold
plot(trms_35(:,1),trms_35(:,2),'r--','linew',2) 
plot(x,y1,'ko','linew',4)
plot(twall(:,1),(twall(:,2)/30)+0.005,'k-','linew',4)
axis([0 1.5 0. 0.03])
 xlabel('x','fontsi',[20])
 ylabel('y','fontsi',[20])
h=gca;
set(h,'fontsi',[20])
print Trms_x_new.eps  -depsc
%-------24b
load tau.dat
load tau_35.dat

t_35=tau_35(:,6);
t_1=tau_35(:,2);
t_2=tau_35(:,3);
t_3=tau_35(:,4);
t_4=tau_35(:,5);
t_5=tau_35(:,6);
t_w=tau_35(:,1);

t1_mean=mean(t_1);
t2_mean=mean(t_2);
t3_mean=mean(t_3);
t4_mean=mean(t_4);

t_1_flac=t_1-mean(t_1);
t_2_flac=t_2-mean(t_2);
t_3_flac=t_3-mean(t_3);
t_4_flac=t_4-mean(t_4);

[N1_flac,X1_flac]=hist(t_1_flac);
[N2_flac,X2_flac]=hist(t_2_flac);
[N3_flac,X3_flac]=hist(t_3_flac);
[N4_flac,X4_flac]=hist(t_4_flac);
% 
figure(36)
plot(X1_flac,N1_flac,'k-','linew',2)
hold
plot(X2_flac,N2_flac,'b--','linew',2)
plot(X3_flac,N3_flac,'r-.','linew',2)
plot(X4_flac,N4_flac,'g--','linew',2)
xlabel('Temperature fluctuations','fontsi',[15])
ylabel('PDF','fontsi',[15])
h=gca;
set(h,'fontsi',[15])
print hist.eps  -depsc

