close all
clear all


%************************* fig6a
figure(1)
load fig6a.dat
load fig6a_exp_persson_karlsson.dat
load fig6a_exp_tsuji_nagano.dat
plot(fig6a(:,1),fig6a(:,2),'linew',2)
hold
plot(fig6a_exp_persson_karlsson(:,1),fig6a_exp_persson_karlsson(:,2),'o','linew',2)
plot(fig6a_exp_tsuji_nagano(:,1),fig6a_exp_tsuji_nagano(:,2),'+','linew',2)
axis([0.5 2000 -4 12])
title('U')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig6a.ps -depsc


%************************* fig6b
figure(2)
load fig6b.dat
load fig6b_exp_persson_karlsson.dat
load fig6b_exp_tsuji_nagano.dat
plot(fig6b(:,1),fig6b(:,2),'linew',2)
hold
plot(fig6b_exp_persson_karlsson(:,1),fig6b_exp_persson_karlsson(:,2),'o','linew',2)
plot(fig6b_exp_tsuji_nagano(:,1),fig6b_exp_tsuji_nagano(:,2),'+','linew',2)
axis([0.5 2000 0 20])
title('T')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig6b.ps -depsc

%************************* fig7
figure(3)
load fig7.dat
plot(fig7(:,1),fig7(:,2),'linew',2)
hold
plot(fig7(:,3),fig7(:,4),'r--','linew',2)
plot(fig7(:,5),fig7(:,6),'k-.','linew',2)
plot(fig7(:,7),fig7(:,8),'o','linew',2)
axis([0.1 1000 0 10])
title('U')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig7.ps -depsc

%************************* fig8
figure(4)
load fig8.dat
load fig8_exp_tsuji_nagano_Tw60.dat
load fig8_exp_tsuji_nagano_Tw100.dat
plot(fig8(:,1),fig8(:,2),'linew',2)
hold
plot(fig8_exp_tsuji_nagano_Tw60(:,1),fig8_exp_tsuji_nagano_Tw60(:,2),'o','linew',2)
plot(fig8_exp_tsuji_nagano_Tw100(:,1),fig8_exp_tsuji_nagano_Tw100(:,2),'+','linew',2)
axis([500 5e11 1 5000])
title('T')
h=gca;
set(h,'xscale','log')
set(h,'yscale','log')
set(h,'fontsi',[20])
print fig8.ps -depsc

%************************* fig9a
figure(5)
ustar=0.0758;
tstar= 3.2816;

load fig9a.dat
load fig9a_exp.dat 

plot(fig9a(:,1),fig9a(:,2)/ustar,'linew',2)
hold
plot(fig9a(:,1),fig9a(:,3)/tstar,'r--','linew',2)
plot(fig9a(:,1),fig9a(:,4)/ustar,'k-.','linew',2)
plot(fig9a_exp(:,1),fig9a_exp(:,2),'o','linew',2)
plot(fig9a_exp(:,1),fig9a_exp(:,3),'s','linew',2)
plot(fig9a_exp(:,1),fig9a_exp(:,4),'d','linew',2)
axis([0.1 2000 0 3.5])
title('normal stresses')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig9a.ps -depsc

%************************* fig9b
figure(6)
ustar=0.0758;
tstar= 3.2816;

load fig9b.dat
load fig9b_exp_vzvz.dat 
load fig9b_exp_vrvr.dat
load fig9b_exp_tt.dat

plot(fig9b(:,1),fig9b(:,2)/ustar,'linew',2)
hold
plot(fig9b(:,1),fig9b(:,3)/tstar,'r--','linew',2)
plot(fig9b(:,1),fig9b(:,4)/ustar,'k-.','linew',2)
plot(fig9b_exp_vzvz(:,1),fig9b_exp_vzvz(:,2),'o','linew',2)
plot(fig9b_exp_vrvr(:,1),fig9b_exp_vrvr(:,2),'s','linew',2)
plot(fig9b_exp_tt(:,1),fig9b_exp_tt(:,2),'d','linew',2)
axis([0.1 2000 0 3.5])
title('normal stresses')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig9b.ps -depsc

%************************* fig10a
figure(7)
ustar=0.0758;
tstar= 3.2816;

load fig10a.dat
load fig10a_exp.dat 
load fig10a_exp.dat
load fig10a_exp.dat

plot(fig10a(:,1),fig10a(:,2)/ustar^2,'linew',2)
hold
plot(fig10a(:,1),fig10a(:,3)/tstar/ustar,'r--','linew',2)
plot(fig10a(:,1),fig10a(:,4)/ustar/tstar,'k-.','linew',2)
plot(fig10a_exp(:,1),fig10a_exp(:,2),'o','linew',2)
plot(fig10a_exp(:,1),fig10a_exp(:,3),'s','linew',2)
plot(fig10a_exp(:,1),fig10a_exp(:,4),'d','linew',2)
axis([0.1 2000 -0.5 3])
title('shear stresses')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig10a.ps -depsc


%************************* fig10b
figure(8)
ustar=0.0758;
tstar= 3.2816;

load fig10b.dat
load fig10b_exp_vzvr.dat 
load fig10b_exp_vzt.dat
load fig10b_exp_vrt.dat

plot(fig10b(:,1),fig10b(:,2)/ustar^2,'linew',2)
hold
plot(fig10b(:,1),fig10b(:,3)/tstar/ustar,'r--','linew',2)
plot(fig10b(:,1),fig10b(:,4)/ustar/tstar,'k-.','linew',2)
plot(fig10b_exp_vzvr(:,1),fig10b_exp_vzvr(:,2),'o','linew',2)
plot(fig10b_exp_vzt(:,1),fig10b_exp_vzt(:,2),'s','linew',2)
plot(fig10b_exp_vrt(:,1),fig10b_exp_vrt(:,2),'d','linew',2)
axis([0.1 2000 -0.5 3])
title('shear stresses')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig10b.ps -depsc

%************************* fig12
figure(9)
load fig12.dat
plot(fig12(:,1).^(1/3),fig12(:,2),'linew',2)
hold
plot(fig12(:,1).^(1/3),fig12(:,3),'r--','linew',2)
plot(fig12(:,1).^(1/3),fig12(:,4),'k-.','linew',2)
plot(fig12(:,1).^(1/3),fig12(:,5),'o','linew',2)
axis([0 4 -50 300])
title('prod-vz-vz')
h=gca;
set(h,'fontsi',[20])
print fig12.ps -depsc


%************************* fig13
figure(10)
load fig13.dat
plot(fig13(:,1).^(1/3),fig13(:,2),'linew',2)
hold
plot(fig13(:,1).^(1/3),fig13(:,3),'r--','linew',2)
plot(fig13(:,1).^(1/3),fig13(:,4),'k-.','linew',2)
plot(fig13(:,1).^(1/3),fig13(:,5),'o','linew',2)
axis([0 4 -100 150])
title('prod-vz-vr')
h=gca;
set(h,'fontsi',[20])
print fig13.ps -depsc


%************************* fig14a
figure(11)
ustar2 =0.005740132210136;


load fig14a.dat
plot(fig14a(:,1),fig14a(:,2)/ustar2,'linew',2) %AT
hold
plot(fig14a(:,1),fig14a(:,3)/ustar2,'r--','linew',2) %VT
plot(fig14a(:,1),fig14a(:,4)/ustar2,'k-.','linew',2) %BT
plot(fig14a(:,1),fig14a(:,5)/ustar2,'.','linew',2) %FT
axis([0.1 1000 -4e-3 5e-3])
title('balance-mom')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig14a.ps -depsc

%************************* fig14b
figure(12)
ustar_tstar= 0.248897072735678;

load fig14b.dat
plot(fig14b(:,1),fig14b(:,2)/ustar_tstar,'linew',2) %AT
hold
plot(fig14b(:,1),fig14b(:,3)/ustar_tstar,'r--','linew',2) %CT
plot(fig14b(:,1),fig14b(:,4)/ustar_tstar,'k-.','linew',2) %FT
axis([0.1 1000 -1e-3 1e-3])
title('balance-energy')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig14b.ps -depsc

%************************* fig16
figure(13)

load fig16.dat
load fig16_exp_persson_karlsson.dat
load fig16_exp_tsuji_nagano.dat
plot(fig16(:,1),fig16(:,2),'linew',2)
hold
plot(fig16_exp_tsuji_nagano(:,1),fig16_exp_tsuji_nagano(:,2),'r+','linew',2) 
plot(fig16_exp_persson_karlsson(:,1),fig16_exp_persson_karlsson(:,2),'o','linew',2) 
axis([0.1 1000 -0.4 0.6])
title('Ruv')
h=gca;
set(h,'xscale','log')
set(h,'fontsi',[20])
print fig16.ps -depsc

