close all
clear all

load fig5_u_CI.dat
load fig5_u_VFI.dat
load fig5_u_VFII.dat
load fig5_u_CII.dat

%************************* fig5a
figure(1)
plot(fig5_u_VFI(:,1),fig5_u_VFI(:,2),'r-.','linew',2)
hold
plot(fig5_u_CI(:,1),fig5_u_CI(:,2),'linew',2)
axis([0 1 0 1.6])
title('u-I')
h=gca;
set(h,'fontsi',[20])
print fig5a.ps -depsc

%************************* fig5b
figure(2)
plot(fig5_u_VFII(:,1),fig5_u_VFII(:,2),'r--','linew',2)
hold
plot(fig5_u_CII(:,1),fig5_u_CII(:,2),'linew',2)
axis([0 1 0 1.4])
title('u-II')
h=gca;
set(h,'fontsi',[20])
print fig5b.ps -depsc

load fig7_qwall_CI.dat 
load fig7_qwall_CII.dat
load fig7_qwall_VFI.dat
load fig7_qwall_VFII.dat

%************************* fig7a
figure(3)
plot(fig7_qwall_CI(:,1),fig7_qwall_CI(:,2),'linew',2)
hold
plot(fig7_qwall_VFI(:,1),fig7_qwall_VFI(:,2),'r-.','linew',2)
axis([360 460 1 3.5])
title('qwall-I')
h=gca;
set(h,'fontsi',[20])
print fig7a.ps -depsc

%************************* fig7b
figure(4)
plot(fig7_qwall_CII(:,1),fig7_qwall_CII(:,2),'linew',2)
hold
plot(fig7_qwall_VFII(:,1),fig7_qwall_VFII(:,2),'r-.','linew',2)
axis([1100 1600 1 3.5])
title('qwall-II')
h=gca;
set(h,'fontsi',[20])
print fig7b.ps -depsc

load fig8_Nu_y_CI.dat  
load fig8_Nu_y_CII.dat  
load fig8_Nu_y_VFI.dat
load fig8_Nu_y_VFII.dat

%************************* fig8a
figure(5)
plot(fig8_Nu_y_CI(:,1),fig8_Nu_y_CI(:,2),'linew',2)
hold
plot(fig8_Nu_y_VFI(:,1),fig8_Nu_y_VFI(:,2),'r-.','linew',2)
axis([0 15 0 160])
title('Nu-I')
h=gca;
set(h,'fontsi',[20])
print fig8a.ps -depsc

%************************* fig8b
figure(6)
plot(fig8_Nu_y_CII(:,1),fig8_Nu_y_CII(:,2),'linew',2)
hold
plot(fig8_Nu_y_VFII(:,1),fig8_Nu_y_VFII(:,2),'r-.','linew',2)
axis([0 15 0 160])
title('Nu-II')
h=gca;
set(h,'fontsi',[20])
print fig8b.ps -depsc

load fig9_Tc_y_VFI.dat
load fig9_Th_y_VFI.dat
load fig9_Tc_y_CI.dat
load fig9_Th_y_CI.dat
load fig9_Tc_y_CII.dat
load fig9_Th_y_CII.dat
load fig9_Tc_y_VFII.dat
load fig9_Th_y_VFII.dat

%************************* fig9a
figure(7)
hold off
plot(fig9_Tc_y_VFI(:,1),fig9_Tc_y_VFI(:,2),'r-.','linew',2)
hold
plot(fig9_Th_y_VFI(:,1),fig9_Th_y_VFI(:,2),'linew',2)
axis([1 3.5 0 120])
title('Th-h-I')
h=gca;
set(h,'fontsi',[20])
print fig9a.ps -depsc


%************************* fig9b
figure(8)
hold off
plot(fig9_Tc_y_VFII(:,1),fig9_Tc_y_VFII(:,2),'r-.','linew',2)
hold
plot(fig9_Th_y_VFII(:,1),fig9_Th_y_VFII(:,2),'linew',2)
axis([1 3.5 0 300])
title('Th-h-II')
h=gca;
set(h,'fontsi',[20])
print fig9b.ps -depsc

load fig10_uv_x_CI.dat  
load fig10_uv_x_CII.dat  
load fig10_uv_x_VFI.dat
load fig10_uv_x_VFII.dat


%************************* fig10a
figure(10)
hold off
plot(fig10_uv_x_VFI(:,1),fig10_uv_x_VFI(:,2),'r-.','linew',2)
hold
plot(fig10_uv_x_CI(:,1),fig10_uv_x_CI(:,2),'linew',2)
axis([0 1 -4e-3 2e-3])
title('uv-I')
h=gca;
set(h,'fontsi',[20])
print fig10a.ps -depsc


%************************* fig10b
figure(11)
hold off
plot(fig10_uv_x_VFII(:,1),fig10_uv_x_VFII(:,2),'r-.','linew',2)
hold
plot(fig10_uv_x_CII(:,1),fig10_uv_x_CII(:,2),'linew',2)
axis([0 1 -2e-3 5e-4])
title('uv-I')
h=gca;
set(h,'fontsi',[20])
print fig10b.ps -depsc

load fig11_u_rms_CI.dat  
load fig11_u_rms_VFI.dat  
load fig11_v_rms_CI.dat  
load fig11_v_rms_VFI.dat  
load fig11_w_rms_CI.dat  
load fig11_w_rms_VFI.dat


%************************* fig11a
figure(12)
hold off
plot(fig11_v_rms_VFI(:,1),fig11_v_rms_VFI(:,2),'r-.','linew',2)
hold
plot(fig11_u_rms_VFI(:,1),fig11_u_rms_VFI(:,2),'linew',2)
plot(fig11_w_rms_VFI(:,1),fig11_w_rms_VFI(:,2),'k-.','linew',2)
axis([0 1 0 0.16])
title('u-v-w-rms-I')
h=gca;
set(h,'fontsi',[20])
print fig11a.ps -depsc


load fig11_u_rms_CII.dat  
load fig11_u_rms_VFII.dat  
load fig11_v_rms_CII.dat  
load fig11_v_rms_VFII.dat  
load fig11_w_rms_CII.dat  
load fig11_w_rms_VFII.dat


%************************* fig11b
figure(13)
hold off
plot(fig11_v_rms_VFII(:,1),fig11_v_rms_VFII(:,2),'r-.','linew',2)
hold
plot(fig11_u_rms_VFII(:,1),fig11_u_rms_VFII(:,2),'linew',2)
plot(fig11_w_rms_VFII(:,1),fig11_w_rms_VFII(:,2),'k-.','linew',2)
axis([0 1 0 0.16])
title('u-v-w-rms-II')
h=gca;
set(h,'fontsi',[20])
print fig11b.ps -depsc


load fig13_tt_rms_CI.dat  
load fig13_tt_rms_VFI.dat  
load fig13_ut_CI.dat  
load fig13_ut_VFI.dat  
load fig13_vt_CI.dat  
load fig13_vt_VFI.dat

load fig13_tt_rms_CII.dat  
load fig13_tt_rms_VFII.dat  
load fig13_ut_CII.dat  
load fig13_ut_VFII.dat  
load fig13_vt_CII.dat  
load fig13_vt_VFII.dat

%************************* fig13a
figure(14)
hold off
plot(fig13_ut_VFI(:,1),10*fig13_ut_VFI(:,2),'r-.','linew',2)
hold
plot(fig13_tt_rms_VFI(:,1),fig13_tt_rms_VFI(:,2),'linew',2)
plot(fig13_vt_VFI(:,1),40*fig13_vt_VFI(:,2),'k-.','linew',2)
axis([0 1 -0.4 0.8])
title('ut-vt-tt-I')
h=gca;
set(h,'fontsi',[20])
print fig13a.ps -depsc

%************************* fig13a
figure(15)
hold off
plot(fig13_ut_VFII(:,1),10*fig13_ut_VFII(:,2),'r-.','linew',2)
hold
plot(fig13_tt_rms_VFII(:,1),fig13_tt_rms_VFII(:,2),'linew',2)
plot(fig13_vt_VFII(:,1),20*fig13_vt_VFII(:,2),'k-.','linew',2)
axis([0 1 -0.7 1.7])
title('ut-vt-tt-II')
h=gca;
set(h,'fontsi',[20])
print fig13b.ps -depsc


 %x1=  0.5 
 %x2=  0.7 
 %x3=  0.9 
 %x4=  1.2 
 %x5=  1.4 
 %x6=  1.6 
 %x7=  1.8 
 %x8=  2.0 
 %x9=  2.3 

load fig17a_u_prof_x_05_VFI.dat
load fig17a_u_prof_x_07_VFI.dat
load fig17a_u_prof_x_09_VFI.dat
load fig17a_u_prof_x_12_VFI.dat
load fig17a_u_prof_x_14_VFI.dat
load fig17a_u_prof_x_16_VFI.dat
load fig17a_u_prof_x_18_VFI.dat
load fig17a_u_prof_x_2_VFI.dat
load fig17a_u_prof_x_23_VFI.dat
load fig17a_u_prof_x_25_VFI.dat

%************************* fig17a
dd=0.49;
figure(16)
hold off
plot(fig17a_u_prof_x_05_VFI(:,1),dd+0.5+fig17a_u_prof_x_05_VFI(:,2),'linew',2)
hold
plot(fig17a_u_prof_x_07_VFI(:,1),dd+0.7+fig17a_u_prof_x_07_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_09_VFI(:,1),dd+0.9+fig17a_u_prof_x_09_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_12_VFI(:,1),dd+1.2+fig17a_u_prof_x_12_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_14_VFI(:,1),dd+1.4+fig17a_u_prof_x_14_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_16_VFI(:,1),dd+1.6+fig17a_u_prof_x_16_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_18_VFI(:,1),dd+1.8+fig17a_u_prof_x_18_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_2_VFI(:,1),dd+2.0+fig17a_u_prof_x_2_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_23_VFI(:,1),dd+2.3+fig17a_u_prof_x_23_VFI(:,2),'linew',2)
plot(fig17a_u_prof_x_25_VFI(:,1),dd+2.5+fig17a_u_prof_x_25_VFI(:,2),'linew',2)
axis([0 1 1 5])
title('v-profiles')
h=gca;
set(h,'fontsi',[20])
print fig17a.ps -depsc


load fig17b_t_prof_x_05_VFI.dat
load fig17b_t_prof_x_07_VFI.dat
load fig17b_t_prof_x_09_VFI.dat
load fig17b_t_prof_x_12_VFI.dat
load fig17b_t_prof_x_14_VFI.dat
load fig17b_t_prof_x_16_VFI.dat
load fig17b_t_prof_x_18_VFI.dat
load fig17b_t_prof_x_2_VFI.dat
load fig17b_t_prof_x_23_VFI.dat
load fig17b_t_prof_x_25_VFI.dat

%************************* fig17b
dd=0.49;
figure(17)
hold off
plot(fig17b_t_prof_x_05_VFI(:,1),dd+0.5+fig17b_t_prof_x_05_VFI(:,2),'linew',2)
hold
plot(fig17b_t_prof_x_07_VFI(:,1),dd+0.7+fig17b_t_prof_x_07_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_09_VFI(:,1),dd+0.9+fig17b_t_prof_x_09_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_12_VFI(:,1),dd+1.2+fig17b_t_prof_x_12_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_14_VFI(:,1),dd+1.4+fig17b_t_prof_x_14_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_16_VFI(:,1),dd+1.6+fig17b_t_prof_x_16_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_18_VFI(:,1),dd+1.8+fig17b_t_prof_x_18_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_2_VFI(:,1),dd+2.0+fig17b_t_prof_x_2_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_23_VFI(:,1),dd+2.3+fig17b_t_prof_x_23_VFI(:,2),'linew',2)
plot(fig17b_t_prof_x_25_VFI(:,1),dd+2.5+fig17b_t_prof_x_25_VFI(:,2),'linew',2)
axis([0 1 1 4])
title('t-profiles')
h=gca;
set(h,'fontsi',[20])
print fig17b.ps -depsc


load fig18a_uv_prof_x_05_VFI.dat
load fig18a_uv_prof_x_07_VFI.dat
load fig18a_uv_prof_x_09_VFI.dat
load fig18a_uv_prof_x_12_VFI.dat
load fig18a_uv_prof_x_14_VFI.dat
load fig18a_uv_prof_x_16_VFI.dat
load fig18a_uv_prof_x_18_VFI.dat
load fig18a_uv_prof_x_2_VFI.dat
load fig18a_uv_prof_x_23_VFI.dat
load fig18a_uv_prof_x_25_VFI.dat
%************************* fig18a
dd=0.49;
rf=0.005;
figure(18)
hold off
plot(fig18a_uv_prof_x_05_VFI(:,1),dd+0.5+fig18a_uv_prof_x_05_VFI(:,2)/rf,'linew',2)
hold
plot(fig18a_uv_prof_x_07_VFI(:,1),dd+0.7+fig18a_uv_prof_x_07_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_09_VFI(:,1),dd+0.9+fig18a_uv_prof_x_09_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_12_VFI(:,1),dd+1.2+fig18a_uv_prof_x_12_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_14_VFI(:,1),dd+1.4+fig18a_uv_prof_x_14_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_16_VFI(:,1),dd+1.6+fig18a_uv_prof_x_16_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_18_VFI(:,1),dd+1.8+fig18a_uv_prof_x_18_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_2_VFI(:,1),dd+2.0+fig18a_uv_prof_x_2_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_23_VFI(:,1),dd+2.3+fig18a_uv_prof_x_23_VFI(:,2)/rf,'linew',2)
plot(fig18a_uv_prof_x_25_VFI(:,1),dd+2.5+fig18a_uv_prof_x_25_VFI(:,2)/rf,'linew',2)
axis([0 1 0.5 3.5])
title('uv-profiles')
h=gca;
set(h,'fontsi',[20])
print fig18a.ps -depsc


load fig18b_vt_prof_x_05_VFI.dat
load fig18b_vt_prof_x_07_VFI.dat
load fig18b_vt_prof_x_09_VFI.dat
load fig18b_vt_prof_x_12_VFI.dat
load fig18b_vt_prof_x_14_VFI.dat
load fig18b_vt_prof_x_16_VFI.dat
load fig18b_vt_prof_x_18_VFI.dat
load fig18b_vt_prof_x_2_VFI.dat
load fig18b_vt_prof_x_23_VFI.dat
load fig18b_vt_prof_x_25_VFI.dat
%************************* fig18b
dd=0.5;
rf=0.02;
figure(19)
hold off
plot(fig18b_vt_prof_x_05_VFI(:,1),dd+0.5+fig18b_vt_prof_x_05_VFI(:,2)/rf,'linew',2)
hold
plot(fig18b_vt_prof_x_07_VFI(:,1),dd+0.7+fig18b_vt_prof_x_07_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_09_VFI(:,1),dd+0.9+fig18b_vt_prof_x_09_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_12_VFI(:,1),dd+1.2+fig18b_vt_prof_x_12_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_14_VFI(:,1),dd+1.4+fig18b_vt_prof_x_14_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_16_VFI(:,1),dd+1.6+fig18b_vt_prof_x_16_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_18_VFI(:,1),dd+1.8+fig18b_vt_prof_x_18_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_2_VFI(:,1),dd+2.0+fig18b_vt_prof_x_2_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_23_VFI(:,1),dd+2.3+fig18b_vt_prof_x_23_VFI(:,2)/rf,'linew',2)
plot(fig18b_vt_prof_x_25_VFI(:,1),dd+2.5+fig18b_vt_prof_x_25_VFI(:,2)/rf,'linew',2)
axis([0 0.95 0.5 3.5])
title('vt-profiles')
h=gca;
set(h,'fontsi',[20])
print fig18b.ps -depsc

load fig19a_vv_prof_x_05_VFI.dat
load fig19a_vv_prof_x_07_VFI.dat
load fig19a_vv_prof_x_09_VFI.dat
load fig19a_vv_prof_x_12_VFI.dat
load fig19a_vv_prof_x_14_VFI.dat
load fig19a_vv_prof_x_16_VFI.dat
load fig19a_vv_prof_x_18_VFI.dat
load fig19a_vv_prof_x_2_VFI.dat
load fig19a_vv_prof_x_23_VFI.dat
load fig19a_vv_prof_x_25_VFI.dat
%************************* fig19a
dd=0.49;
rf=0.04;
figure(20)
hold off
plot(fig19a_vv_prof_x_05_VFI(:,1),dd+0.5+fig19a_vv_prof_x_05_VFI(:,2)/rf,'linew',2)
hold
plot(fig19a_vv_prof_x_07_VFI(:,1),dd+0.7+fig19a_vv_prof_x_07_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_09_VFI(:,1),dd+0.9+fig19a_vv_prof_x_09_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_12_VFI(:,1),dd+1.2+fig19a_vv_prof_x_12_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_14_VFI(:,1),dd+1.4+fig19a_vv_prof_x_14_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_16_VFI(:,1),dd+1.6+fig19a_vv_prof_x_16_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_18_VFI(:,1),dd+1.8+fig19a_vv_prof_x_18_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_2_VFI(:,1),dd+2.0+fig19a_vv_prof_x_2_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_23_VFI(:,1),dd+2.3+fig19a_vv_prof_x_23_VFI(:,2)/rf,'linew',2)
plot(fig19a_vv_prof_x_25_VFI(:,1),dd+2.5+fig19a_vv_prof_x_25_VFI(:,2)/rf,'linew',2)
axis([0 1 1 4.5])
title('vv-profiles')
h=gca;
set(h,'fontsi',[20])
print fig19a.ps -depsc

load fig19b_uu_prof_x_05_VFI.dat
load fig19b_uu_prof_x_07_VFI.dat
load fig19b_uu_prof_x_09_VFI.dat
load fig19b_uu_prof_x_12_VFI.dat
load fig19b_uu_prof_x_14_VFI.dat
load fig19b_uu_prof_x_16_VFI.dat
load fig19b_uu_prof_x_18_VFI.dat
load fig19b_uu_prof_x_2_VFI.dat
load fig19b_uu_prof_x_23_VFI.dat
load fig19b_uu_prof_x_25_VFI.dat
%************************* fig19a
dd=0.49;
rf=0.2;
figure(21)
hold off
plot(fig19b_uu_prof_x_05_VFI(:,1),dd+0.5+fig19b_uu_prof_x_05_VFI(:,2)/rf,'linew',2)
hold
plot(fig19b_uu_prof_x_07_VFI(:,1),dd+0.7+fig19b_uu_prof_x_07_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_09_VFI(:,1),dd+0.9+fig19b_uu_prof_x_09_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_12_VFI(:,1),dd+1.2+fig19b_uu_prof_x_12_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_14_VFI(:,1),dd+1.4+fig19b_uu_prof_x_14_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_16_VFI(:,1),dd+1.6+fig19b_uu_prof_x_16_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_18_VFI(:,1),dd+1.8+fig19b_uu_prof_x_18_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_2_VFI(:,1),dd+2.0+fig19b_uu_prof_x_2_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_23_VFI(:,1),dd+2.3+fig19b_uu_prof_x_23_VFI(:,2)/rf,'linew',2)
plot(fig19b_uu_prof_x_25_VFI(:,1),dd+2.5+fig19b_uu_prof_x_25_VFI(:,2)/rf,'linew',2)
axis([0 1 1 4])
title('uu-profiles')
h=gca;
set(h,'fontsi',[20])
print fig19b.ps -depsc

load fig20a_ut_prof_x_05_VFI.dat
load fig20a_ut_prof_x_07_VFI.dat
load fig20a_ut_prof_x_09_VFI.dat
load fig20a_ut_prof_x_12_VFI.dat
load fig20a_ut_prof_x_14_VFI.dat
load fig20a_ut_prof_x_16_VFI.dat
load fig20a_ut_prof_x_18_VFI.dat
load fig20a_ut_prof_x_2_VFI.dat
load fig20a_ut_prof_x_23_VFI.dat
load fig20a_ut_prof_x_25_VFI.dat
%************************* fig19a
dd=0.49;
rf=0.1;
figure(22)
hold off
plot(fig20a_ut_prof_x_05_VFI(:,1),dd+0.5+fig20a_ut_prof_x_05_VFI(:,2)/rf,'linew',2)
hold
plot(fig20a_ut_prof_x_07_VFI(:,1),dd+0.7+fig20a_ut_prof_x_07_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_09_VFI(:,1),dd+0.9+fig20a_ut_prof_x_09_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_12_VFI(:,1),dd+1.2+fig20a_ut_prof_x_12_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_14_VFI(:,1),dd+1.4+fig20a_ut_prof_x_14_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_16_VFI(:,1),dd+1.6+fig20a_ut_prof_x_16_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_18_VFI(:,1),dd+1.8+fig20a_ut_prof_x_18_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_2_VFI(:,1),dd+2.0+fig20a_ut_prof_x_2_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_23_VFI(:,1),dd+2.3+fig20a_ut_prof_x_23_VFI(:,2)/rf,'linew',2)
plot(fig20a_ut_prof_x_25_VFI(:,1),dd+2.5+fig20a_ut_prof_x_25_VFI(:,2)/rf,'linew',2)
axis([0 1 0.5 4])
title('ut-profiles')
h=gca;
set(h,'fontsi',[20])
print fig20a.ps -depsc

load fig20b_tt_prof_x_05_VFI.dat
load fig20b_tt_prof_x_07_VFI.dat
load fig20b_tt_prof_x_09_VFI.dat
load fig20b_tt_prof_x_12_VFI.dat
load fig20b_tt_prof_x_14_VFI.dat
load fig20b_tt_prof_x_16_VFI.dat
load fig20b_tt_prof_x_18_VFI.dat
load fig20b_tt_prof_x_2_VFI.dat
load fig20b_tt_prof_x_23_VFI.dat
load fig20b_tt_prof_x_25_VFI.dat
%************************* fig19a
dd=0.49;
rf=1;
figure(23)
hold off
plot(fig20b_tt_prof_x_05_VFI(:,1),dd+0.5+fig20b_tt_prof_x_05_VFI(:,2)/rf,'linew',2)
hold
plot(fig20b_tt_prof_x_07_VFI(:,1),dd+0.7+fig20b_tt_prof_x_07_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_09_VFI(:,1),dd+0.9+fig20b_tt_prof_x_09_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_12_VFI(:,1),dd+1.2+fig20b_tt_prof_x_12_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_14_VFI(:,1),dd+1.4+fig20b_tt_prof_x_14_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_16_VFI(:,1),dd+1.6+fig20b_tt_prof_x_16_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_18_VFI(:,1),dd+1.8+fig20b_tt_prof_x_18_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_2_VFI(:,1),dd+2.0+fig20b_tt_prof_x_2_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_23_VFI(:,1),dd+2.3+fig20b_tt_prof_x_23_VFI(:,2)/rf,'linew',2)
plot(fig20b_tt_prof_x_25_VFI(:,1),dd+2.5+fig20b_tt_prof_x_25_VFI(:,2)/rf,'linew',2)
axis([0 1 1 4])
title('tt-profiles')
h=gca;
set(h,'fontsi',[20])
print fig20b.ps -depsc

load inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI.dat
figure(24)
% plot inlet y_U_T
hold off
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,2),'linew',2)
hold
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),0.05*inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,3),'r--','linew',2)
axis([0 1 0 1.2])
title('inlet: u and T')
h=gca;
set(h,'fontsi',[20])
print inlet_U_T.ps -depsc

% plot inlet y_uu_vv_ww_uv
figure(25)
hold off
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,4),'linew',2)
hold
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,5),'r--','linew',2)
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,6),'k-.','linew',2)
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,7),'o','linew',2)
axis([0 1 -0.01 0.035])
title('inlet: uu, vv, ww, uv')
h=gca;
set(h,'fontsi',[20])
print inlet_uu_vv_ww_uv.ps -depsc

% plot inlet y_ut_vt_tt
figure(26)
hold off
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,8),'linew',2)
hold
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,9),'r--','linew',2)
plot(inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,1),inlet_y_U_T_uu_vv_ww_uv_ut_vt_tt_VFI(:,10),'k-.','linew',2)
axis([0 1 -1e-6 1e-6])
title('inlet: ut, vt, tt')
h=gca;
set(h,'fontsi',[20])
print inlet_ut_vt_tt.ps -depsc

