close all
clear all

ubulkb=9.758;  % Bulk velocity, buoyancy case
ubulk=15.584; % Bulk velocity, no buoyancy case

qw= -0.025; % Wall heat transfer, buoyancy case
qwb= -0.022; % Wall heat transfer, no buoyancy case


load figure_2a_T_buoy.dat
load figure_2a_U_buoy.dat
load figure_2a_T_no_buoy.dat
load figure_2a_U_no_buoy.dat

%************************* fig2a
figure(1)
plot(figure_2a_T_no_buoy(:,1),figure_2a_T_no_buoy(:,2),'--')
hold
plot(figure_2a_U_no_buoy(:,1),figure_2a_U_no_buoy(:,2)/ubulk)
plot(figure_2a_T_buoy(:,1),figure_2a_T_buoy(:,2),'--','linew',2)
plot(figure_2a_U_buoy(:,1),figure_2a_U_buoy(:,2)/ubulkb,'linew',2)
axis([0 2 0 1.25])
title('u-T')
h=gca;
set(h,'fontsi',[20])
print fig2a.ps -depsc

%************************* fig2b
load figure_2b_urms_buoy.dat     
load figure_2b_vrms_buoy.dat     
load figure_2b_wrms_buoy.dat
load figure_2b_urms_no_buoy.dat  
load figure_2b_vrms_no_buoy.dat  
load figure_2b_wrms_no_buoy.dat


figure(2)
plot(figure_2b_urms_no_buoy(:,1),figure_2b_urms_no_buoy(:,2)/ubulk)
hold
plot(figure_2b_urms_buoy(:,1),figure_2b_urms_buoy(:,2)/ubulkb,'linew',2)

plot(figure_2b_vrms_no_buoy(:,1),figure_2b_vrms_no_buoy(:,2)/ubulk,'--')
plot(figure_2b_vrms_buoy(:,1),figure_2b_vrms_buoy(:,2)/ubulkb,'--','linew',2)

plot(figure_2b_wrms_no_buoy(:,1),figure_2b_wrms_no_buoy(:,2)/ubulk,'-.')
plot(figure_2b_wrms_buoy(:,1),figure_2b_wrms_buoy(:,2)/ubulkb,'-.','linew',2)

axis([0 2 0 0.22])
title('uuvvww')
h=gca;
set(h,'fontsi',[20])
print fig2b.ps -depsc


%************************* fig3a
load figure_3a_press_grad.dat  
load figure_3a_turb_shear.dat  
load figure_3a_visc_shear.dat

figure(3)
plot(figure_3a_press_grad(:,1),figure_3a_press_grad(:,2)/ubulk^2,'linew',2)
hold
plot(figure_3a_visc_shear(:,1),figure_3a_visc_shear(:,2)/ubulk^2)
plot(figure_3a_turb_shear(:,1),-figure_3a_turb_shear(:,2)/ubulk^2,'-.')

axis([0 2 -5e-3 5e-3])
title('u-bal-no-buoy')
h=gca;
set(h,'fontsi',[20])
print fig3a.ps -depsc

%************************* fig3b
load figure_3b_press_grad.dat  
load figure_3b_turb_shear.dat  
load figure_3b_visc_shear.dat
load figure_3b_buoy.dat

figure(4)
plot(figure_3b_press_grad(:,1),figure_3b_press_grad(:,2)/ubulkb^2,'linew',2)
hold
plot(figure_3b_visc_shear(:,1),figure_3b_visc_shear(:,2)/ubulkb^2)
plot(figure_3b_turb_shear(:,1),-figure_3b_turb_shear(:,2)/ubulkb^2,'-.')
plot(figure_3b_buoy(:,1),figure_3b_buoy(:,2)/ubulkb^2,'--','linew',2)

axis([0 2 -0.01 0.015])
title('u-bal-buoy')
h=gca;
set(h,'fontsi',[20])
print fig3b.ps -depsc

%************************* fig4a
load figure_4a_tt_buoy.dat     
load figure_4a_ut_buoy.dat     
load figure_4a_vt_buoy.dat
load figure_4a_tt_no_buoy.dat  
load figure_4a_ut_no_buoy.dat  
load figure_4a_vt_no_buoy.dat

figure(5)
plot(figure_4a_ut_buoy(:,1),figure_4a_ut_buoy(:,2)/qwb,'linew',2)
hold
plot(figure_4a_ut_no_buoy(:,1),figure_4a_ut_no_buoy(:,2)/qw)
plot(figure_4a_vt_buoy(:,1),-figure_4a_vt_buoy(:,2)/qwb,'--','linew',2)
plot(figure_4a_vt_no_buoy(:,1),-figure_4a_vt_no_buoy(:,2)/qw,'--')
plot(figure_4a_tt_buoy(:,1),500*figure_4a_tt_buoy(:,2),'-.','linew',2)
plot(figure_4a_tt_no_buoy(:,1),500*figure_4a_tt_no_buoy(:,2),'-.')

axis([0 2 -8 8])
title('ut-vt-tty')
h=gca;
set(h,'fontsi',[20])
print fig4a.ps -depsc

%************************* fig4b
load figure_4b_visc_heat_flux_buoy.dat  
load figure_4b_visc_heat_flux_no_buoy.dat  
load figure_4b_vt_buoy.dat  
load figure_4b_vt_no_buoy.dat


figure(6)
plot(figure_4b_visc_heat_flux_buoy(:,1),-figure_4b_visc_heat_flux_buoy(:,2)/abs(qwb),'--','linew',2)
hold
plot(figure_4b_visc_heat_flux_no_buoy(:,1),-figure_4b_visc_heat_flux_no_buoy(:,2)/abs(qw),'--')
plot(figure_4b_vt_buoy(:,1),figure_4b_vt_buoy(:,2)/abs(qwb),'--','linew',2)
plot(figure_4b_vt_no_buoy(:,1),figure_4b_vt_no_buoy(:,2)/abs(qw),'--')

axis([0 2 0 1])
title('heat-flux')
h=gca;
set(h,'fontsi',[20])
print fig4b.ps -depsc

%************************* fig5a
load figure_5a_buoy.dat  
load figure_5a_press.dat  
load figure_5a_turb_diff.dat
load figure_5a_diss.dat  
load figure_5a_prod.dat   
load figure_5a_visc_diff.dat

figure(7)
plot(figure_5a_turb_diff(:,1),-figure_5a_turb_diff(:,2)/ubulk^3)
hold
plot(figure_5a_press(:,1),-figure_5a_press(:,2)/ubulk^3,'--','linew',2)
plot(figure_5a_diss(:,1),-figure_5a_diss(:,2)/ubulk^3,'-.')
plot(figure_5a_visc_diff(:,1),figure_5a_visc_diff(:,2)/ubulk^3,'+')
plot(figure_5a_prod(:,1),figure_5a_prod(:,2)/ubulk^3,'s')
plot(figure_5a_buoy(:,1),figure_5a_buoy(:,2)/ubulk^3,':')

axis([0 2 -0.02 0.02])
title('uu-bal-no-buoy')
h=gca;
set(h,'fontsi',[20])
print fig5a.ps -depsc

%************************* fig5b
load figure_5b_buoy.dat  
load figure_5b_press.dat  
load figure_5b_turb_diff.dat
load figure_5b_diss.dat  
load figure_5b_prod.dat   
load figure_5b_visc_diff.dat

figure(8)
plot(figure_5b_turb_diff(:,1),-figure_5b_turb_diff(:,2)/ubulkb^3)
hold
plot(figure_5b_press(:,1),-figure_5b_press(:,2)/ubulkb^3,'--','linew',2)
plot(figure_5b_diss(:,1),-figure_5b_diss(:,2)/ubulkb^3,'-.')
plot(figure_5b_visc_diff(:,1),figure_5b_visc_diff(:,2)/ubulkb^3,'+')
plot(figure_5b_prod(:,1),figure_5b_prod(:,2)/ubulkb^3,'s')
plot(figure_5b_buoy(:,1),figure_5b_buoy(:,2)/ubulkb^3,':')

axis([0 2 -0.02 0.02])
title('uu-bal-buoy')
h=gca;
set(h,'fontsi',[20])
print fig5b.ps -depsc

%************************* fig6a
load figure_6a_buoy.dat  
load figure_6a_press.dat  
load figure_6a_turb_diff.dat
load figure_6a_diss.dat  
load figure_6a_prod.dat   
load figure_6a_visc_diff.dat

figure(9)
plot(figure_6a_turb_diff(:,1),-figure_6a_turb_diff(:,2)/ubulk^3)
hold
plot(figure_6a_press(:,1),-figure_6a_press(:,2)/ubulk^3,'--','linew',2)
plot(figure_6a_diss(:,1),-figure_6a_diss(:,2)/ubulk^3,'-.')
plot(figure_6a_visc_diff(:,1),figure_6a_visc_diff(:,2)/ubulk^3,'+')
plot(figure_6a_prod(:,1),figure_6a_prod(:,2)/ubulk^3,'s')
plot(figure_6a_buoy(:,1),figure_6a_buoy(:,2)/ubulk^3,':')

axis([0 2 -0.003 0.003])
title('uv-bal-no-buoy')
h=gca;
set(h,'fontsi',[20])
print fig6a.ps -depsc

%************************* fig6b
load figure_6b_buoy.dat  
load figure_6b_press.dat  
load figure_6b_turb_diff.dat
load figure_6b_diss.dat  
load figure_6b_prod.dat   
load figure_6b_visc_diff.dat

figure(10)
plot(figure_6b_turb_diff(:,1),-figure_6b_turb_diff(:,2)/ubulkb^3)
hold
plot(figure_6b_press(:,1),-figure_6b_press(:,2)/ubulkb^3,'--','linew',2)
plot(figure_6b_diss(:,1),-figure_6b_diss(:,2)/ubulkb^3,'-.')
plot(figure_6b_visc_diff(:,1),figure_6b_visc_diff(:,2)/ubulkb^3,'+')
plot(figure_6b_prod(:,1),figure_6b_prod(:,2)/ubulkb^3,'s')
plot(figure_6b_buoy(:,1),figure_6b_buoy(:,2)/ubulkb^3,':')

axis([0 2 -0.0042 0.005])
title('uv-bal-buoy')
h=gca;
set(h,'fontsi',[20])
print fig6b.ps -depsc

%************************* fig7a
load figure_7a_press.dat  
load figure_7a_turb_diff.dat
load figure_7a_diss.dat  
load figure_7a_prod.dat   
load figure_7a_visc_diff.dat

figure(11)
hold off
plot(figure_7a_turb_diff(:,1),-figure_7a_turb_diff(:,2)/ubulk^2)
hold
plot(figure_7a_press(:,1),-figure_7a_press(:,2)/ubulk^2,'--','linew',2)
plot(figure_7a_diss(:,1),-figure_7a_diss(:,2)/ubulk^2,'-.')
plot(figure_7a_visc_diff(:,1),figure_7a_visc_diff(:,2)/ubulk^2,'+')
plot(figure_7a_prod(:,1),figure_7a_prod(:,2)/ubulk^2,'s')

axis([0 2 -0.001 0.001])
title('vt-bal-no-buoy')
h=gca;
set(h,'fontsi',[20])
print fig7a.ps -depsc

%************************* fig7b
load figure_7b_press.dat  
load figure_7b_turb_diff.dat
load figure_7b_diss.dat  
load figure_7b_prod.dat   
load figure_7b_visc_diff.dat

figure(11)
hold off
plot(figure_7b_turb_diff(:,1),-figure_7b_turb_diff(:,2)/ubulkb^2)
hold
plot(figure_7b_press(:,1),-figure_7b_press(:,2)/ubulkb^2,'--','linew',2)
plot(figure_7b_diss(:,1),-figure_7b_diss(:,2)/ubulkb^2,'-.')
plot(figure_7b_visc_diff(:,1),figure_7b_visc_diff(:,2)/ubulkb^2,'+')
plot(figure_7b_prod(:,1),figure_7b_prod(:,2)/ubulkb^2,'s')

axis([0 2 -0.0015 0.002])
title('vt-bal-buoy')
h=gca;
set(h,'fontsi',[20])
print fig7b.ps -depsc

%************************* fig8a
load figure_8a_turb_diff.dat
load figure_8a_diss.dat  
load figure_8a_prod.dat   
load figure_8a_visc_diff.dat

figure(12)
hold off
plot(figure_8a_turb_diff(:,1),-figure_8a_turb_diff(:,2)/ubulk)
hold
plot(figure_8a_diss(:,1),-figure_8a_diss(:,2)/ubulk,'-.')
plot(figure_8a_visc_diff(:,1),figure_8a_visc_diff(:,2)/ubulk,'+')
plot(figure_8a_prod(:,1),figure_8a_prod(:,2)/ubulk,'s')

axis([0 2 -0.002 0.003])
title('vt-bal-no-buoy')
h=gca;
set(h,'fontsi',[20])
print fig8a.ps -depsc


%************************* fig8b
load figure_8b_turb_diff.dat
load figure_8b_diss.dat  
load figure_8b_prod.dat   
load figure_8b_visc_diff.dat

figure(13)
hold off
plot(figure_8b_turb_diff(:,1),-figure_8b_turb_diff(:,2)/ubulkb)
hold
plot(figure_8b_diss(:,1),-figure_8b_diss(:,2)/ubulkb,'-.')
plot(figure_8b_visc_diff(:,1),figure_8b_visc_diff(:,2)/ubulkb,'+')
plot(figure_8b_prod(:,1),figure_8b_prod(:,2)/ubulkb,'s')

axis([0 2 -0.0023 0.0027])
title('vt-bal-buoy')
h=gca;
set(h,'fontsi',[20])
print fig8b.ps -depsc

