#!/usr/bin/env python
# coding: utf-8

# In[1]:


import numpy as np
from numpy import linalg as LA
import math as m
import os
import sys
from matplotlib.image import imread
import matplotlib.pyplot as plt
from matplotlib import rcParams # for changing default values
import scipy.io as sio
from scipy.optimize import minimize
import timeit
import torch
import random
import torch.nn as nn
import torch.optim as optim
from scipy.integrate import odeint
from torch.autograd import grad
import torch.optim.lr_scheduler as lr_scheduler

plt.close('all')
plt.interactive(True)
# set all fontsizes to 12
rcParams["font.size"] = 16
rcParams["axes.axisbelow"] = True # make sure grid is behind plots

viscos = 1/2000

# solve differential equation for k

# load DNS data
#   y/h             y+              U+             u'+             v'+             w'+           -Om_z+          om_x'+           om_y'+           om_z'+         uv'+             uw'+           vw'+             pr'+            ps'+          psto'+            p'

DNS_mean=np.genfromtxt("Re2000_jimenez.dat",comments="%")
y_DNS=DNS_mean[:,0];
yplus_DNS=DNS_mean[:,1];
u_DNS=DNS_mean[:,2];
dudy_DNS=np.gradient(u_DNS,yplus_DNS)

u2_DNS=DNS_mean[:,3]**2
v2_DNS=DNS_mean[:,4]**2
w2_DNS=DNS_mean[:,5]**2
uv_DNS=DNS_mean[:,10]
k_DNS=0.5*(u2_DNS+v2_DNS+w2_DNS)
dkdy_DNS=np.gradient(k_DNS,yplus_DNS,edge_order=2)
d2kdy2_DNS=np.gradient(dkdy_DNS,yplus_DNS,edge_order=2)


#    y/h               y+           dissip          produc         p-strain          p-diff          t-diff         v-diff            bal          tp-kbal

DNS_k_terms=np.genfromtxt("Re2000_bal_k.dat",comments="%")

diss_DNS=-DNS_k_terms[:,2]
Pk_DNS=DNS_k_terms[:,3]
diff_DNS=DNS_k_terms[:,6]
diff_DNS_visc =  DNS_k_terms[:,7]

diss_DNS_iso = np.maximum(diss_DNS-diff_DNS_visc,1e-10)


########################################## k  balance zoom from pyCALC
fig1,ax1 = plt.subplots()
plt.subplots_adjust(left=0.20,bottom=0.20)
plt.plot(yplus_DNS,Pk_DNS,'b-',label= '$P^k$')
plt.plot(yplus_DNS,-diss_DNS_iso,'r-',label= r'$D^{k,\nu}-\varepsilon$')
plt.plot(yplus_DNS,diff_DNS,'k-',label= r'$D^{k,t}$')
plt.legend(loc='best',fontsize=20)
plt.ylabel('terms in $k$ eq.')
plt.xlabel("$y^+$")
plt.axis([0, 100, -0.30, 0.30])
plt.savefig('k-balance_diss-iso-2000-channel-kom.png',bbox_inches='tight')


